REM $Header: wfldapchk.sql 26.1 2004/08/04 14:26:16 achitlan noship $
REM +======================================================================+
REM | Copyright (c) 1996, 2004 Oracle. All rights reserved.                |
REM |                                                                      |
REM +======================================================================+
REM
REM NAME
REM     wfldapchk.sql - Check LDAP Params
REM NOTES:
REM    Check the LDAP paremets LDAP Host Name and LDAP Port
REM    Use it to determine if the install is SSO enabled or NOT
REM
REM MODIFICATION LOG:
REM     Created 
REM =======================================================================
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE;
SET VERIFY OFF

SET SERVEROUTPUT ON;
DECLARE
  l_ldap_host    varchar2(256);
  l_ldap_port    varchar2(256);
  PRAGMA AUTONOMOUS_TRANSACTION;
BEGIN
  BEGIN
    --Get the value of LDAP Host Name and Port 
    l_ldap_host := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'HOST');
    l_ldap_port := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'PORT');
  EXCEPTION
    when others then
      --exceptions are not for this script to 
      --handle , we take that it is  SSO enabled
      --its less riskier than overwritting existing config.
      null;
  END;
  
  --lets check both to determine if its SSO enabled
  if ((l_ldap_host is not  NULL) OR (l_ldap_port is not NULL)) then
    raise_application_error(-20001,'SSOENABLED');
  end if;
EXCEPTION
  when others then
    --raise the exception here as we already did our 
    --coverup and now we are on our expected raise path
    raise;
END;
/
commit;
exit;




