REM $Header: wfldpprf.sql 26.2 2003/08/11 04:59:51 achitlan ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM     wfldpprf.sql  -  WorkFlow DIRectory service Create schema
REM NOTES:Pass Ldap parameters from wfca.
REM       LDAP Host Name,LDAP Port,LDAP admin user,LDAP admin passsword ,
REM       LDAP Changelog, LDAP Base SearchDN     
REM
REM MODIFICATION LOG:
REM =======================================================================
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE;
SET VERIFY OFF

Declare
  p_ldap_host  varchar2(256) := &1;
  p_ldap_port  varchar2(256) := &2;
  p_ldap_user  varchar2(256) := &3;
  p_ldap_pwd  varchar2(256) := &4;
  p_ldap_log_base varchar2(256) := &5;
  p_ldap_user_base varchar2(256) := &6;

  l_ldap_pwd    varchar2(256);

Begin


      if upper(p_ldap_pwd) <> 'NULL'
     then
      l_ldap_pwd := p_ldap_pwd; 
     end if;

     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'HOST',     p_ldap_host);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'PORT',     p_ldap_port);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'USERNAME', p_ldap_user);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'CHANGELOG_DIR', p_ldap_log_base);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'USER_DIR', p_ldap_user_base);

      fnd_preference.eput('#INTERNAL','LDAP_SYNCH', 'EPWD', l_ldap_pwd, 'LDAP_PWD');
End;
/
 commit;
 exit;
