REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*+=======================================================================*
  |    Copyright (c) 2003 Oracle Corporation, Redwood Shores, CA, USA     |
  |                         All rights reserved.                          |
  +=======================================================================+
  | FILENAME
  |   wflobs.sql
  | DESCRIPTION
  |   PL/SQL Specification for package: WF_TEMP_LOB
  *=======================================================================*/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

CREATE OR REPLACE package WF_TEMP_LOB as
/* $Header: wflobs.pls 26.2 2003/07/28 14:29:18 smayze noship $*/

TYPE wf_temp_lob_rec_type IS RECORD
(
  temp_lob clob,
  free     boolean
);

TYPE wf_temp_lob_table_type IS TABLE OF 
  wf_temp_lob_rec_type INDEX BY BINARY_INTEGER;

function GetLob(p_lob_tab in out nocopy wf_temp_lob_table_type)
return pls_integer;

procedure ReleaseLob(
  p_lob_tab in out nocopy wf_temp_lob_table_type,
  loc in pls_integer);

procedure ShowLob(p_lob_tab in out nocopy wf_temp_lob_table_type);

END WF_TEMP_LOB;
/
commit;
exit;
