REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wflucs.sql
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_LOOKUPS_PKG
 *=======================================================================*/
set verify off;
whenever sqlerror exit failure rollback;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_LOOKUPS_PKG as
/* $Header: wflucs.pls 26.2 2002/11/06 13:35:00 rosthoma ship $ */
procedure INSERT_ROW (
  X_ROWID in out VARCHAR2,
  X_LOOKUP_TYPE in VARCHAR2,
  X_LOOKUP_CODE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_MEANING in VARCHAR2,
  X_DESCRIPTION in VARCHAR2
);
procedure LOCK_ROW (
  X_LOOKUP_TYPE in VARCHAR2,
  X_LOOKUP_CODE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_MEANING in VARCHAR2,
  X_DESCRIPTION in VARCHAR2
);
procedure UPDATE_ROW (
  X_LOOKUP_TYPE in VARCHAR2,
  X_LOOKUP_CODE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_MEANING in VARCHAR2,
  X_DESCRIPTION in VARCHAR2
);
procedure DELETE_ROW (
  X_LOOKUP_TYPE in VARCHAR2,
  X_LOOKUP_CODE in VARCHAR2
);
procedure ADD_LANGUAGE;
end WF_LOOKUPS_PKG;
/
-- show errors package WF_LOOKUPS_PKG
commit;
exit;
