REM $Header: wfmlrc.sql 26.6 2004/12/27 04:29:08 dmani ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM     wfmlrc.sql - WorkFlow Mailer Create tables
REM
REM DESCRIPTION
REM	09/2002 VARRAJAR Added column SECURITY_GROUP_ID
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where tables aready exist
WHENEVER SQLERROR CONTINUE;

/*
** WF_MAILER_PARAMETERS
*/
create table WF_MAILER_PARAMETERS (
   NAME varchar2 (12) not null,
   PARAMETER varchar2 (30) not null,
   VALUE varchar2 (200),
   REQUIRED varchar2(1),
   CB VARCHAR2 (60),
   ALLOW_RELOAD varchar2(1),
   SECURITY_GROUP_ID varchar2(32)
) STORAGE (INITIAL 10K NEXT 10K);

/*
**  WF_MAILER_TAGS
*/ 
create table WF_MAILER_TAGS ( 
   NAME varchar2 (12) not null, 
   TAG_ID number not null,
   ACTION varchar2 (8) not null,
   PATTERN varchar2 (200),
   ALLOW_RELOAD varchar2(1),
   SECURITY_GROUP_ID varchar2(32)
) STORAGE (INITIAL 10K NEXT 10K);

create unique index WF_MAILER_PARAMETERS_U1
   on WF_MAILER_PARAMETERS (NAME, PARAMETER)
   storage (initial 1k next 1k pctincrease 100);

create unique index WF_MAILER_TAGS_U1
   on WF_MAILER_TAGS (NAME, TAG_ID)
   storage (initial 1k next 1k pctincrease 100);

create sequence WF_MAILER_TAGS_S; 

commit;
exit;
