REM
REM dbdrv: none
REM
REM $Header: wfmlrcfg.sql 26.4 2005/01/28 11:21:47 dmani ship $
REM +========================================================================+
REM |  Copyright (c) 2003 Oracle Corporation Redwood Shores, California, USA
REM |                          All Rights Reserved
REM +========================================================================+
REM | FILENAME
REM |   wfmlrcfg.sql
REM |
REM | DESCRIPTION
REM |   Script to set Java Mailer configuration parameters
REM |
REM | ARGUMENTS
REM |   sqlplus <wf_schema>/<pass> @wfmlrcfg.sql <IMAPHost> <IMAPAcc> <HTMLAgent> 
REM |                                   <SMTPHost> <ReplyToAddr> <IMAPTextPass>
REM |                                   <ProcessFolder> <DiscardFolder>
REM |
REM | NOTES
REM |   The script configures Java Mailer
REM |
REM |
REM | HISTORY
REM ===========================================================================
REM
REM

WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE;
SET VERIFY OFF

SET SERVEROUTPUT ON SIZE 200000

Declare
  l_count        number; 
  l_ret          number; 
  I_Host         varchar2(200) := '&1';
  Account        varchar2(200) := '&2';
  HTML_Agent     varchar2(200) := '&3';
  O_Host         varchar2(200) := '&4';
  Reply_To       varchar2(200) := '&5';
  I_Password     varchar2(200) := '&6';
  process_folder varchar2(200) := '&7';
  discard_folder varchar2(200) := '&8';
  l_pass         varchar2(4000); 
  l_err          varchar2(4000); 

Begin

  begin
    select 1 into l_count from fnd_svc_components where 
         component_name = 'Workflow Notification Mailer' and 
         component_status in ('NOT_CONFIGURED', 'STOPPED', 
                              'STOPPED_ERROR', 'DEACTIVATED_USER', 
                              'DEACTIVATED_SYSTEM'); 
  exception
  when others then
   l_count := 0;
  end;

  if ( (l_count = 1) and
       not((I_Host is null) or (Account is null) or (HTML_Agent is null)
	   or (O_Host is null) or (Reply_To is null) or (I_Password is null)
	   or (process_folder is null) or (discard_folder is null) )
       )
  then  
	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'OUTBOUND_SERVER',
 						O_Host , 
						'L',-1, 'ORACLE' );
  
	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'HTMLAGENT',
       		   				HTML_Agent,
						'L',-1, 'ORACLE' );

	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'INBOUND_SERVER', 
 						I_Host ,
						'L',-1, 'ORACLE' );

	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'ACCOUNT',
 						Account ,
						'L',-1, 'ORACLE' );

	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'REPLYTO', 
 						Reply_To ,
						'L',-1, 'ORACLE' );

        ECX_OBFUSCATE.ECX_DATA_ENCRYPT(I_Password,l_pass,l_err,l_ret);
 
	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'INBOUND_PASSWORD',
 						 l_pass, 
						'L',-1, 'ORACLE' );

	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'PROCESS',
 						 process_folder, 
						'L',-1, 'ORACLE' );

	FND_SVC_COMP_PARAM_VALS_PKG.LOAD_ROW ( 'Workflow Notification Mailer', 
						'DISCARD',
 						 discard_folder, 
						'L',-1, 'ORACLE' );

        update fnd_svc_components set component_status = 'STOPPED' 
            where component_name = 'Workflow Notification Mailer';
   end if;

end;
/

commit;
exit;
