REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=dat+1 \
REM dbdrv: checkfile:~PROD:~PATH:~FILE 
REM $Header: wfmlrqi.sql 26.9 2004/10/05 18:39:36 htay ship $
rem **************************************************************
rem NAME:
rem      wfmlrqi.sql
rem DESCRIPTION:
rem The purpose of this script is to examine the WF_QUEUES table
rem for the existance of any SMTP OUTBOUND queues. It will then
rem create a single queue in the event that none are found.
rem NOTE: 
rem      ** THESE TOKENS MUST NOT BE TRANSLATED
rem      ** Should be run at end of install, but can be rerun if needed
rem USAGE:
rem sqlplus APPS/pw @wfmlrqi.sql APPS pw
rem **************************************************************

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

REM Connect to the base account to coincide with the way wfquec is run to
REM match the WF_SCHEMA resource row

REM Adpatch runs it in apps
REM always run this script in AMERICAN, that way any wf_core.translate()
REM function is guaranteed to retrieve a valid value. 

alter session set nls_language=American;

declare
   l_queues integer := 0;
begin
   -- Check for the existance of a SMTP queue.
   begin 
      select queue_count
      into l_queues
      from WF_QUEUES
      where PROTOCOL = 'SMTP'
        and INBOUND_OUTBOUND = 'OUTBOUND'
        and DISABLE_FLAG = 'N'
        and rownum = 1;
   exception
      when NO_DATA_FOUND then
         l_queues := 0;
      when others then 
         raise;
   end;
 
   if l_queues = 0 then
      -- No queues are defined. Create a single default queue
      WF_QUEUE.CREATE_GENERIC_QUEUE('SMTP','OUTBOUND',
                                    'SMTP OUTBOUND Mailer Queue', 1);
   end if;
end;
/
commit;
exit;


