REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus &phase=last \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
REM
REM +======================================================================+
REM | Copyright (c) 2002 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wfmlrreq.sql
REM   DESCRIPTION
REM       Load scheduled requests for seeded 'Workflow Notification Mailer'
REM       Service Component
REM   USAGE
REM       sqlplus apps/apps @wfmlrreq.sql
REM   NOTES
REM       Normally you would use afsvcc.lct to seed scheduled requests.  This
REM       script should only be used for special needs.
REM
REM $Header: wfmlrreq.sql 26.2 2003/02/03 17:27:46 ankung ship $

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

DECLARE

  l_count NUMBER;

BEGIN

  SELECT COUNT(*) INTO l_count 
  FROM fnd_svc_components sc, fnd_svc_comp_requests scr 
  WHERE sc.component_id = scr.component_id
    AND sc.component_name = 'Workflow Notification Mailer'
    AND scr.event_name = 'oracle.apps.fnd.wf.mailer.Mailer.notification.summary';

  IF l_count = 0 THEN
    FND_SVC_COMP_REQUESTS_PKG.LOAD_ROW
    (
      X_COMPONENT_NAME => 'Workflow Notification Mailer'
    , X_EVENT_NAME => 'oracle.apps.fnd.wf.mailer.Mailer.notification.summary'
    , X_EVENT_DATE => SYSDATE + 1 -- 1 DAY
    , X_REQUESTED_BY_USER => NULL
    , X_EVENT_PARAMS => NULL
    , X_EVENT_FREQUENCY => 1440 -- 60 MIN/HR * 24 HR/DAY
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
    );

  END IF;

END;

/

COMMIT;
EXIT;

