REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
REM +=======================================================================+
REM |    Copyright (c) 2002 Oracle Corporation, Redwood Shores, CA, USA     |
REM |                         All rights reserved.                          |
REM +=======================================================================+
REM | FILENAME
REM |   wfmluts.pls
REM |
REM | DESCRIPTION
REM |   Mailer Utility package.
REM |
REM | HISTORY
REM |   Vijay Shanmugam(10/11/2002) - Created
REM +=======================================================================+

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_MAIL_UTIL as
/* $Header: wfmluts.pls 26.10 2005/03/03 12:44:15 smayze ship $ */
/*# 
 * This package provides the notification mailer utility APIs to 
 * perform conversions of Notification data.
 * @rep:scope public
 * @rep:product OWF
 * @rep:displayname Workflow Notification Mailer Utility
 * @rep:lifecycle active
 * @rep:compatibility S
 * @rep:category BUSINESS_ENTITY WF_NOTIFICATION
 * @rep:ihelp FND/@mlrutilapi See the related online help
 */

TYPE parserStack_t IS TABLE OF varchar2(2000) INDEX BY BINARY_INTEGER;

-- EncodeBLOB
--   Receives a BLOB input and encodes it to Base64 CLOB
-- IN
--   BLOB data
-- OUT
--   CLOB data
/*#
 * Encodes the specified BLOB to base64 and returns the encoded data as
 * a character large object (CLOB). You can use this procedure to store a
 * BLOB in a PL/SQL CLOB document to be included in a notification
 * message.
 * @param pIDoc Input BLOB Document
 * @param pODoc Output CLOB Document
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Encode BLOB Document to base64
 * @rep:compatibility S
 * @rep:ihelp FND/@mlrutilapi#a_encblob See the related online help
 */
procedure EncodeBLOB(pIDoc  in     blob,
                     pODoc  in out nocopy clob);

-- DecodeBLOB
--   Receives a CLOB input and decodes it from Base64 to BLOB
-- IN
--   CLOB data
-- OUT
--   BLOB data
procedure DecodeBLOB(pIDoc  in     clob,
                     pODoc  in out nocopy blob);
-- StrParser 
--   Parse a string and seperate the elements into a memeory table based on the 
--   content of the seperators.
-- IN
--    str - The Varchar2 that is to be parsed
--    sep - The list of SINGLE character seprators that will
--          segment the str.
-- RETURN 
--    parserStack_t a memory table of Varchar2
--
function strParser(str in varchar2, sep in varchar2) return parserStack_t;

-- ParseContentType
--   Parses document type returned by the PLSQL/PLSQLCLOB/PLSQLBLOB document
--   APIs and returns the parameters
-- IN
--   pContentType - Document Type
-- OUT
--   pMimeType - Content Type of the document
--   pFileName - File Name
--   pExtn     - File Extension
--   pEncoding - Content Encoding

procedure parseContentType(pContentType in varchar2,
                           pMimeType out nocopy varchar2,
                           pFileName out nocopy varchar2,
                           pExtn out nocopy varchar2,
                           pEncoding out nocopy varchar2); 
end WF_MAIL_UTIL;
/
commit;
exit;
