REM $Header: wfmqsubc.sql 26.9 2004/07/30 05:27:55 rosthoma ship $
REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=tbm+3 \
REM dbdrv: checkfile:~PROD:~PATH:~FILE \
REM dbdrv: &un_fnd &pw_fnd
REM ***********************************************************************
REM   NAME
REM       wfmqsubc.sql -
REM   DESCRIPTION
REM       Creates Subscribers for Multiconsumer Queues
REM   USAGE
REM       sqlplus apps/pwd@dbinst @wfmqsubc.sql <wf schema> <wf schema pwd> 
REM ********************************************************************/
REM Queues require storage and consequently must be run in the base account
REM (autopatch will run all scripts in apps account)
SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

connect &&1/&&2
WHENEVER SQLERROR CONTINUE;
declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_DEFERRED',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_DEFERRED',subscriber=>lagent,
  rule=>'1=1');
exception
  when subscriber_exist then
    -- just add the rule if subscriber exists
    dbms_aqadm.alter_subscriber(queue_name =>'&&1..WF_DEFERRED',
                                subscriber=>lagent,
                                rule=>'1=1');
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_IN',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_IN',subscriber=>lagent,
  rule=>'1=2');
exception
  when subscriber_exist then
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_OUT',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_OUT',subscriber=>lagent,
  rule=>'1=2');
exception
  when subscriber_exist then
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_ERROR',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_ERROR',subscriber=>lagent,
  rule=>'1=2');
exception
  when subscriber_exist then
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_JMS_OUT',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_JMS_OUT',subscriber=>lagent,
  rule=>'1=1');
exception
  when subscriber_exist then
    dbms_aqadm.alter_subscriber(queue_name =>'&&1..WF_JMS_OUT',
                                subscriber=>lagent,
                                rule=>'1=1');
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_JMS_IN',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_JMS_IN',subscriber=>lagent,
  rule=>'1=1');
exception
  when subscriber_exist then
    dbms_aqadm.alter_subscriber(queue_name =>'&&1..WF_JMS_IN',
                                subscriber=>lagent,
                                rule=>'1=1');
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_NOTIFICATION_OUT',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_NOTIFICATION_OUT',
                            subscriber=>lagent, rule=>'1=1');
exception
  when subscriber_exist then
    dbms_aqadm.alter_subscriber(queue_name =>'&&1..WF_NOTIFICATION_OUT',
                                subscriber=>lagent,
                                rule=>'1=1');
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_NOTIFICATION_IN',null,0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_NOTIFICATION_IN',
                            subscriber=>lagent, rule=>'1=1');
exception
  when subscriber_exist then
    dbms_aqadm.alter_subscriber(queue_name =>'&&1..WF_NOTIFICATION_IN',
                                subscriber=>lagent,
                                rule=>'1=1');
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_JAVA_DEFERRED', null, 0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_JAVA_DEFERRED',
                            subscriber=>lagent, rule=>'1=1');
exception
  when subscriber_exist then
    dbms_aqadm.alter_subscriber(queue_name =>'&&1..WF_JAVA_DEFERRED',
                                subscriber=>lagent,
                                rule=>'1=1');
    null;  -- ignore if we already added this subscriber.
end;
/

declare
  lagent sys.aq$_agent;
  subscriber_exist exception;
  pragma EXCEPTION_INIT(subscriber_exist, -24034);
begin
  lagent := sys.aq$_agent('WF_JAVA_ERROR', null, 0);
  dbms_aqadm.add_subscriber(queue_name =>'&&1..WF_JAVA_ERROR',
                            subscriber=>lagent, rule=>'1=1');
exception
  when subscriber_exist then
    dbms_aqadm.alter_subscriber(queue_name =>'&&1..WF_JAVA_ERROR',
                                subscriber=>lagent,
                                rule=>'1=1');
    null;  -- ignore if we already added this subscriber.
end;
/

commit;
exit;





