REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfmsas.sql
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_MESSAGE_ATTRIBUTES_PKG
 *=======================================================================*/
set verify off;
whenever sqlerror exit failure rollback;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_MESSAGE_ATTRIBUTES_PKG as
/* $Header: wfmsas.pls 26.2 2002/11/06 13:35:18 rosthoma ship $ */
procedure INSERT_ROW (
  X_ROWID in out VARCHAR2,
  X_MESSAGE_NAME in VARCHAR2,
  X_MESSAGE_TYPE in VARCHAR2,
  X_NAME in VARCHAR2,
  X_SEQUENCE in NUMBER,
  X_TYPE in VARCHAR2,
  X_SUBTYPE in VARCHAR2,
  X_VALUE_TYPE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_FORMAT in VARCHAR2,
  X_TEXT_DEFAULT in VARCHAR2,
  X_NUMBER_DEFAULT in NUMBER,
  X_DATE_DEFAULT in DATE,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2,
  X_ATTACH in VARCHAR2
);
procedure LOCK_ROW (
  X_MESSAGE_NAME in VARCHAR2,
  X_MESSAGE_TYPE in VARCHAR2,
  X_NAME in VARCHAR2,
  X_SEQUENCE in NUMBER,
  X_TYPE in VARCHAR2,
  X_SUBTYPE in VARCHAR2,
  X_VALUE_TYPE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_FORMAT in VARCHAR2,
  X_TEXT_DEFAULT in VARCHAR2,
  X_NUMBER_DEFAULT in NUMBER,
  X_DATE_DEFAULT in DATE,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2
);
procedure UPDATE_ROW (
  X_MESSAGE_NAME in VARCHAR2,
  X_MESSAGE_TYPE in VARCHAR2,
  X_NAME in VARCHAR2,
  X_SEQUENCE in NUMBER,
  X_TYPE in VARCHAR2,
  X_SUBTYPE in VARCHAR2,
  X_VALUE_TYPE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_FORMAT in VARCHAR2,
  X_TEXT_DEFAULT in VARCHAR2,
  X_NUMBER_DEFAULT in NUMBER,
  X_DATE_DEFAULT in DATE,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2,
  X_ATTACH in VARCHAR2
);
procedure DELETE_ROW (
  X_MESSAGE_NAME in VARCHAR2,
  X_MESSAGE_TYPE in VARCHAR2,
  X_NAME in VARCHAR2
);
procedure ADD_LANGUAGE;
end WF_MESSAGE_ATTRIBUTES_PKG;
/
-- show errors package WF_MESSAGE_ATTRIBUTES_PKG
commit;
exit;
