REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfmtns.sql
 |
 | DESCRIPTION
 |   PL/SQL spec for package: WF_MAINTENANCE 
 |
 | NOTES
 |   Routines to maintain design and runtime data.
 |
 | HISTORY
 |
 | 17-NOV-2000	rwunderl.us	created
 *=======================================================================*/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_MAINTENANCE as
 /* $Header: wfmtns.pls 26.6 2002/11/11 06:29:55 rosthoma ship $ */

g_CommitFrequency NUMBER := 500;


-- procedure PropagateChangedName
--   Locates all occurrences of an old username and changes to 
--   the new username.
--
-- IN:
--   OldName - Old Username we are changing from.
--   NewName - New Username we are changing to.
--   docommit - boolean default false.
--
procedure PropagateChangedName(
  OldName in varchar2,
  NewName in varchar2,
  docommit in BOOLEAN default FALSE);

end WF_MAINTENANCE;
/

commit;
exit;
