REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
 /*+=======================================================================*
  |    Copyright (c) 1996 Oracle Corporation, Redwood Shores, CA, USA     |
  |                         All rights reserved.                          |
  +=======================================================================+
  | FILENAME
  |   wfmxmls.sql
  | DESCRIPTION
  |   PL/SQL Specification for package: WF_XML
  *=======================================================================*/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

set scan off;


CREATE OR REPLACE package  WF_XML as
/* $Header: wfmxmls.pls 26.20 2004/11/30 07:59:34 smayze ship $ */


/*===========================================================================

  PL*SQL TABLE NAME:	wf_xml_attr_rec_type

  DESCRIPTION:	Stores a list of element attribute/value pairs
============================================================================*/

   TYPE wf_xml_attr_rec_type IS RECORD
   (
      attribute           VARCHAR2(250), -- Name for the attribute,
      value               VARCHAR2(1000) -- Value that the attribute 
                                         -- will take on
   );


   TYPE wf_xml_attr_table_type IS TABLE OF
       wf_xml_attr_rec_type INDEX BY BINARY_INTEGER;


   WF_NTF_REASIGN VARCHAR2(100) := 'oracle.apps.wf.notification.reassign';
   WF_NTF_CLOSE VARCHAR2(100) := 'oracle.apps.wf.notification.close';
   WF_NTF_CANCEL VARCHAR2(100) := 'oracle.apps.wf.notification.cancel';

   -- Part of the oracle.apps.wf.notification.send.group group
   WF_NTF_SEND_MESSAGE VARCHAR2(100) := 'oracle.apps.wf.notification.send';
   WF_NTF_SEND_SUMMARY VARCHAR2(100) := 
                                'oracle.apps.wf.notification.summary.send';
   WF_NTF_SUMMARY VARCHAR2(100) := 'oracle.apps.fnd.wf.mailer.Mailer.notification.summary';

   -- Part of the oracle.apps.wf.notification.receive group
   WF_NTF_RECEIVE_ERROR VARCHAR2(100) := 
                                'oracle.apps.wf.notification.receive.error';
   WF_NTF_RECEIVE_MESSAGE VARCHAR2(100) := 
                                'oracle.apps.wf.notification.receive.message';
   WF_NTF_RECEIVE_SENDRETURN VARCHAR2(100) := 
                              'oracle.apps.wf.notification.receive.sendreturn';
   WF_NTF_RECEIVE_UNAVAIL VARCHAR2(100) := 
                                'oracle.apps.wf.notification.receive.unavail';

   -- GetTagValue - Obtain the value for a given TAG from within the
   --               Document Tree
   -- IN
   --    document as a CLOB
   --    TAG to find the value of
   --    The position to start looking for the TAG from
   -- OUT
   --    Value of the TAG. ie the value between the start and end TAGs
   --    The position in the CLOB after the find
   --    The list of attributes associated with the TAG (Not implemented as yet)
   procedure GetTagValue(p_doc in out NOCOPY CLOB, p_tag in varchar2,
                         p_value out NOCOPY varchar2,
                         p_pos in out NOCOPY integer,
                         p_attrlist in out NOCOPY wf_xml_attr_table_type);

   -- GetXMLMessage - Return a CLOB Document containing an XML encoded 
   --                 version of the notification. No recipients list 
   --                 will be populated. That will be the responsibility 
   --                 of the calling procedure.
   --
   -- IN
   --     notification id
   --     Protocol for the message
   --     List of recipients to recieve the notification
   --     mailer node name
   --     Web Agent for the HTML attachments
   --     Reply to address for the final notification
   --     Language for the notification
   --     Territory for the notification
   -- OUT
   --     Prioirty
   --     A CLOB Containing the XML encoded message.
   procedure GetXMLMessage (p_nid       in  number,
                        p_protocol  in varchar2,
                        p_recipient_list in WF_DIRECTORY.wf_local_roles_tbl_type,
                        p_node      in  varchar2,
                        p_agent     in  varchar2,
                        p_replyto   in  varchar2,
                        p_nlang     in  varchar2,
                        p_nterr     in varchar2,
                        p_priority out NOCOPY number,
                        p_message in out NOCOPY CLOB);

   -- EnqueueNotification - To push a notification to the outbound notification
   --                       queue.
   -- IN
   --    Notification ID
   procedure EnqueueNotification(p_nid in number);


   -- DequeueMessage - Remove a notification from the queue
   -- IN
   --    Queue name to operate on
   --    Correlation for the message - NID in this implementation
   -- OUT
   --    The message that is obtained from the queue.
   --    Timeout to signal whether the queue is empty.

   procedure DequeueMessage(p_queue_name in varchar2,
                            p_correlation in varchar2 default NULL,
                            p_message   in out NOCOPY CLOB,
                            p_timeout out NOCOPY boolean);
   -- GetMessage - Get email message data
   -- IN
   --    Queue name to operate on
   -- OUT
   --    Notification ID
   --    Comma seperated list of the recipients of the notification
   --    Status of the notification - For the purpose of message templating
   --    Timout. Returns TRUE where the queue is empty.
   --    Error message
   procedure GetMessage(
       p_queue     in  number,
       p_nid          out NOCOPY number,
       p_receiverlist out NOCOPY varchar2,
       p_status      out NOCOPY varchar2,
       p_timeout      out NOCOPY integer,
       p_error_result in out NOCOPY varchar2);

   -- GetSortMessage - Get email message data
   -- IN
   --    Queue number to operate on
   -- OUT
   --    Notification ID
   --    Recipient
   --    Status of the notification - For the purpose of message templating
   --    Timout. Returns TRUE where the queue is empty.
   --    Error message
   procedure GetShortMessage(
       p_queue        in  number,
       p_nid          out NOCOPY number,
       p_recipient    out NOCOPY varchar2,
       p_status       out NOCOPY varchar2,
       p_timeout      out NOCOPY integer,
       p_error_result in out NOCOPY varchar2);

   -- GetExceptionMessage - Get email message data
   -- IN
   --    Queue number to operate on
   -- OUT
   --    Notification ID
   --    Recipient
   --    Status of the notification - For the purpose of message templating
   --    Timout. Returns TRUE where the queue is empty.
   --    Error message
   procedure GetExceptionMessage(
       p_queue     in  number,
       p_nid          out NOCOPY number,
       p_recipient out NOCOPY varchar2,
       p_status      out NOCOPY varchar2,
       p_timeout      out NOCOPY boolean,
       p_error_result in out NOCOPY varchar2);

   -- GetShortMessage - Get email message data
   -- IN
   --    Queue name to operate on
   -- OUT
   --    Notification ID
   --    Recipient
   --    Status of the notification - For the purpose of message templating
   --    Timout. Returns TRUE where the queue is empty.
   --    Error message
   procedure GetQueueMessage(
       p_queuename    in  varchar2,
       p_nid          out NOCOPY number,
       p_recipient out NOCOPY varchar2,
       p_status      out NOCOPY varchar2,
       p_timeout      out NOCOPY integer,
       p_error_result in out NOCOPY varchar2);

   -- RemoveNotification
   --     To remove all enqueues messages for a given notification.
   -- IN
   --    Notification ID of the message to locate and remove.
   -- NOTE
   --    This is a destructive procedure that's sole purpose is to purge the
   --    message from the queue. We only call this when we do not care for the
   --    content.
   procedure RemoveNotification(p_nid in number);

   -- setFistMessage
   --    To set the global variable g_first_message
   -- IN
   --    'Y' to set the flag to TRUE
   procedure setFirstMessage(p_first_message IN varchar2);
   

   -- Generate
   -- The generate function for the WF_NOTIFICATION_OUT queue. This 
   -- will handle all oracle.apps.wf.notification.send.% events and 
   -- generate an XML representation of the outbound notification.
   -- IN 
   -- p_event_name - The VARCHAR2 event name
   -- p_event_key - The VARCHAR2 event key
   -- p_parameter_list - The wf_parameter_list_t containing the parameters
   --                    that were passed in with the event.
   -- OUT
   -- CLOB The XML representation of the outbound notification
   function Generate(p_event_name in varchar2,
                      p_event_key in varchar2,
                      p_parameter_list in wf_parameter_list_t default null) 
                     return clob;

   function GetAttachment(p_nid in number,
                          p_doc in out NOCOPY CLOB,
                          p_agent in varchar2,
                          p_disposition in varchar2,
                          p_doc_type in varchar2,
                          p_pos in out NOCOPY integer) return integer;

   -- sendNotification
   -- This API is a wrapper to the wf_xml.enqueueNotification. It is provided
   -- as forward compatabilty for the original mailer since the call to
   -- wf_xml.enqueueNotification has been removed from 
   -- wf_notification.sendSingle.
   -- To use the original mailer, one must enable the subscription that will
   --  call this rule function.
   -- IN
   -- p_subscription
   -- p_event
   -- RETURN
   -- varchar2 of the status
   function SendNotification (p_subscription_guid in raw,
                     p_event in out NOCOPY WF_EVENT_T) return varchar2;

   -- receive
   -- Handle the notification receive events
   -- This will handle the processing of the inbound responses
   -- IN
   -- p_subscription_guid - The RAW GUID of the event subscription
   -- p_event - The WF_EVENT_T containing the event information
   function receive (p_subscription_guid in raw,
                     p_event in out NOCOPY WF_EVENT_T) return varchar2;

   -- GetResponseDetails
   -- Gets the response details from the incoming XML Notifiction
   -- structure.
   --
   -- IN
   -- message - The XML Notification structure containing the 
   --           inbound response
   procedure getResponseDetails(message in CLOB);

   -- SummaryRule
   -- To handle the summary notification request event
   -- and call the approapriate summary generate function for 
   -- either the role or the member of the role.
   function SummaryRule (p_subscription_guid in raw,
                     p_event in out NOCOPY WF_EVENT_T) return varchar2;

   /*
   ** error_rule - dispatch functionality for error subscription processing
   **
   **   Identical to default_rule, but if an exception is caught we raise it
   **   up to cause a rollback.  We don't want messages processed off the
   **   error queue to be continually recycled back on to the error queue.
   **
   **   Returns SUCCESS or raises an exception
   **
   */
   FUNCTION error_rule(p_subscription_guid in raw,
                       p_event in out nocopy wf_event_t) return varchar2;

   -- Gets the LOB content for a PLSQLCLOB
   -- IN
   -- pAPI the API to call
   -- pDoc The LOB to take the document
   procedure getDocContent(pNid in NUMBER, pAPI in VARCHAR2,
                           pDoc in out nocopy CLOB);

   -- Gets the LOB content for a PLSQLCLOB
   -- IN
   -- pAPI the API to call
   -- pDoc The LOB to take the document
   procedure getBDocContent(pNid in NUMBER, pAPI in VARCHAR2,
                           pDoc in out nocopy BLOB);

-- gets the size of the current LOB table
function getLobTableSize return number;

end WF_XML;
/
-- show errors package WF_XML
commit;
exit;
