REM $Header: wfnscpol.sql 26.0 2003/09/25 05:52:22 mfisher noship $

REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=upa \
REM dbdrv: checkfile:~PROD:~PATH:~FILE &un_fnd &pw_fnd

REM /*=======================================================================+
REM  |     Copyright (c) 2002 Oracle Corporation Belmont, California, USA    |
REM  |                         All rights reserved.                          |
REM  +=======================================================================+
REM  |
REM  | NAME 
REM  |   wfdigspi.sql  
REM  |
REM  | DESCRIPTION
REM  |
REM  |  This script will populate the wf_security_policies table
REM  |  with Policy information for the various supported policies.
REM  |
REM  |
REM  | HISTORY
REM  | 
REM  |   09/17/03   mfisher   -Created
REM  +=======================================================================*/


SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK
WHENEVER OSERROR EXIT FAILURE ROLLBACK

REM insert the info if its not there yet 
insert into WF_NTF_SECURITY_POLICIES
   (POLICY_NAME, email_allowed)
  select 'DEFAULT', 'Y'
    from dual
   where not exists
     (select 1 
        from WF_NTF_SECURITY_POLICIES
       where POLICY_NAME = 'DEFAULT');

insert into WF_NTF_SECURITY_POLICIES
   (POLICY_NAME, email_allowed)
  select 'EMAIL_OK', 'Y'
    from dual
   where not exists
     (select 1 
        from WF_NTF_SECURITY_POLICIES
       where POLICY_NAME = 'EMAIL_OK');

insert into WF_NTF_SECURITY_POLICIES
   (POLICY_NAME, email_allowed)
  select 'NO_EMAIL', 'N'
    from dual
   where not exists
     (select 1 
        from WF_NTF_SECURITY_POLICIES
       where POLICY_NAME = 'NO_EMAIL');

insert into WF_NTF_SECURITY_POLICIES
   (POLICY_NAME, email_allowed)
  select 'ENC_EMAIL_ONLY', 'E'
    from dual
   where not exists
     (select 1 
        from WF_NTF_SECURITY_POLICIES
       where POLICY_NAME = 'ENC_EMAIL_ONLY');

commit;
exit;

