REM dbdrv: none
REM $Header: wfntfc.sql 26.15 2005/01/21 09:36:26 vshanmug ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM     wfntfc.sql - WorkFlow NoTiFication Create tables
REM
REM DESCRIPTION
REM
REM MODIFICATION LOG:
REM     05/2002 VSHANMUG Bug 2353079 - Added new column SECURITY_GROUP_ID 
REM             to all the tables
REM     05/2002 ROSTHOMA Bug 2404491 - Added the column LANGUAGE in table
REM             WF_COMMENTS
REM     09/2002 VARRAJAR Modified SECURITY_GROUP_ID to be VARCHAR2
REM     03.12.2003 VARRAJAR Modified all role/user related columns to be
REM                         VARCHAR2(320)
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where tables aready exist
WHENEVER SQLERROR CONTINUE;


/*
** WF_MESSAGES
*/
create table WF_MESSAGES
(
    TYPE             varchar2(8)   not null,
    NAME             varchar2(30)  not null,
    PROTECT_LEVEL    number        default 1000 not null,
    CUSTOM_LEVEL     number        default 0 not null,
    DEFAULT_PRIORITY number,
    READ_ROLE        varchar2(320),
    WRITE_ROLE       varchar2(320),
    SECURITY_GROUP_ID varchar2(32)
);

create table WF_MESSAGES_TL
(
    TYPE          varchar2(8)    not null,
    NAME          varchar2(30)   not null,
    LANGUAGE      varchar2(4)    not null,
    SOURCE_LANG   varchar2(4)    not null,
    DISPLAY_NAME  varchar2(80)   not null,
    SUBJECT       varchar2(240)  not null,
    PROTECT_LEVEL number         default 1000 not null,
    CUSTOM_LEVEL  number         default 0 not null,
    DESCRIPTION   varchar2(240),
    BODY          varchar2(4000),
    HTML_BODY     varchar2(4000),
    SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_MESSAGE_ATTRIBUTES
*/
create table WF_MESSAGE_ATTRIBUTES
(
    MESSAGE_TYPE   varchar2(8)    not null,
    MESSAGE_NAME   varchar2(30)   not null,
    NAME           varchar2(30)   not null,
    SEQUENCE       number         not null,
    TYPE           varchar2(8)    not null,
    SUBTYPE        varchar2(8)    not null,
    ATTACH         varchar2(1),
    VALUE_TYPE     varchar2(8)    default 'CONSTANT' not null,
    PROTECT_LEVEL  number         default 1000 not null,
    CUSTOM_LEVEL   number         default 0 not null,
    FORMAT         varchar2(240),
    TEXT_DEFAULT   varchar2(4000),
    NUMBER_DEFAULT number,
    DATE_DEFAULT   date,
    SECURITY_GROUP_ID varchar2(32)
);

create table WF_MESSAGE_ATTRIBUTES_TL
(
    MESSAGE_TYPE  varchar2(8)  not null,
    MESSAGE_NAME  varchar2(30) not null,
    NAME          varchar2(30) not null,
    LANGUAGE      varchar2(4) not null,
    SOURCE_LANG   varchar2(4) not null,
    DISPLAY_NAME  varchar2(80) not null,
    PROTECT_LEVEL number       default 1000 not null,
    CUSTOM_LEVEL  number       default 0 not null,
    DESCRIPTION   varchar2(240),
    SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_NOTIFICATIONS
*/
create table WF_NOTIFICATIONS
(
    NOTIFICATION_ID    number       not null,
    GROUP_ID           number       not null,
    MESSAGE_TYPE       varchar2(8)  not null,
    MESSAGE_NAME       varchar2(30) not null,
    RECIPIENT_ROLE     varchar2(320) not null,
    ORIGINAL_RECIPIENT varchar2(320) not null,
    STATUS             varchar2(8)  not null,
    ACCESS_KEY         varchar2(80) not null,
    MAIL_STATUS        varchar2(8),
    PRIORITY           number,
    BEGIN_DATE         date,
    END_DATE           date,
    DUE_DATE           date,
    RESPONDER          varchar2(240),
    USER_COMMENT       varchar2(4000),
    CALLBACK           varchar2(240),
    CONTEXT            varchar2(2000),
    FROM_USER          varchar2(320),
    TO_USER            varchar2(320),
    SUBJECT            varchar2(2000),
    LANGUAGE           varchar2(4),
    MORE_INFO_ROLE     VARCHAR2(320),
    FROM_ROLE          VARCHAR2(320),
    SECURITY_GROUP_ID varchar2(32)
);

create sequence WF_NOTIFICATIONS_S;


/*
** WF_NOTIFICATION_ATTRIBUTES
*/
create table WF_NOTIFICATION_ATTRIBUTES
(
    NOTIFICATION_ID number          not null,
    NAME            varchar2(30)    not null,
    TEXT_VALUE      varchar2(4000),
    NUMBER_VALUE    number,
    DATE_VALUE      date,
    EVENT_VALUE     wf_event_t,
    SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_ROUTING_RULES
*/
create table WF_ROUTING_RULES (
  RULE_ID         number not null,
  ROLE            varchar2(320) not null,
  ACTION          varchar2(8) not null,
  BEGIN_DATE      date,
  END_DATE        date,
  MESSAGE_TYPE    varchar2(8),
  MESSAGE_NAME    varchar2(30),
  ACTION_ARGUMENT varchar2(2000),
  RULE_COMMENT    varchar2(4000),
  SECURITY_GROUP_ID varchar2(32)
);

create sequence WF_ROUTING_RULES_S;

/*
** WF_ROUTING_RULE_ATTRIBUTES
*/
create table WF_ROUTING_RULE_ATTRIBUTES (
  RULE_ID      number not null,
  NAME         varchar2(30) not null,
  TYPE         varchar2(8) not null,
  TEXT_VALUE   varchar2(2000),
  NUMBER_VALUE number,
  DATE_VALUE   date,
  RULE_COMMENT    varchar2(4000),
  SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_COMMENTS
*/
create table WF_COMMENTS
(
 SEQUENCE          NUMBER NOT NULL,
 NOTIFICATION_ID   NUMBER NOT NULL,
 FROM_ROLE         VARCHAR2(320) NOT NULL,
 FROM_USER         VARCHAR2(320) NOT NULL,
 TO_ROLE           VARCHAR2(320),
 TO_USER           VARCHAR2(360),
 PROXY_ROLE        VARCHAR2(320),
 COMMENT_DATE      DATE NOT NULL,
 ACTION            VARCHAR2(30) NOT NULL,
 ACTION_TYPE       VARCHAR2(30),
 USER_COMMENT      VARCHAR2(4000),
 LANGUAGE          VARCHAR2(4),
 SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_NTF_SECURITY_POLICIES
*/
create table WF_NTF_SECURITY_POLICIES
(
 POLICY_NAME 	VARCHAR2(20) NOT NULL,
 EMAIL_ALLOWED 	VARCHAR2(1) NOT NULL
);

commit;
exit;
