REM dbdrv: none
REM $Header: wfntfd.sql 26.2 2001/12/27 23:01:19 dlam ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM   wfntfd.sql - WorkFlow NoTiFication Drop objects
REM DESCRIPTION
REM   drops all objects associated with the notificication system
REM USAGE
REM   sqlplus apps/apps @wfntfd applsys fnd
REM   sqlplus apps/apps @wfntfd apps apps
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where constraints may not exist
WHENEVER SQLERROR CONTINUE;

-- Drop packages
drop package  WF_MESSAGES_PKG;
drop package  WF_MESSAGE_ATTRIBUTES_PKG;
drop package  WF_NOTIFICATION;
drop package  WFA_HTML;
drop package  WF_MAIL;
drop package  WF_MAILER_PARAMETER;

-- Drop views
drop view     WF_MESSAGES_VL;
drop view     WF_MESSAGE_ATTRIBUTES_VL;
drop view     WF_NOTIFICATIONS_VIEW;
drop view     WF_NOTIFICATION_ATTR_RESP_V;
drop view     WF_WORKLIST_V;

-- Drop tables
drop table    WF_COMMENTS;
drop table    WF_ROUTING_RULE_ATTRIBUTES;
drop table    WF_ROUTING_RULES;
drop table    WF_NOTIFICATION_ATTRIBUTES;
drop table    WF_NOTIFICATIONS;
drop table    WF_MESSAGE_ATTRIBUTES_TL;
drop table    WF_MESSAGE_ATTRIBUTES;
drop table    WF_MESSAGES_TL;
drop table    WF_MESSAGES;
drop table    WF_MAILER_PARAMETERS;
drop table    WF_MAILER_TAGS;

-- Drop sequences
drop sequence WF_NOTIFICATIONS_S;
drop sequence WF_ROUTING_RULES_S;
drop sequence WF_MAILER_TAGS_S;

-- Drop synonyms
drop synonym  WF_MESSAGES_PKG;
drop synonym  WF_MESSAGE_ATTRIBUTES_PKG;
drop synonym  WF_NOTIFICATION;
drop synonym  WFA_HTML;
drop synonym  WF_MAIL;
drop synonym  WF_MESSAGES_VL;
drop synonym  WF_MESSAGE_ATTRIBUTES_VL;
drop synonym  WF_NOTIFICATIONS_VIEW;
drop synonym  WF_NOTIFICATION_ATTR_RESP_V;
drop synonym  WF_ROUTING_RULE_ATTRIBUTES;
drop synonym  WF_ROUTING_RULES;
drop synonym  WF_NOTIFICATION_ATTRIBUTES;
drop synonym  WF_NOTIFICATIONS;
drop synonym  WF_MESSAGE_ATTRIBUTES_TL;
drop synonym  WF_MESSAGE_ATTRIBUTES;
drop synonym  WF_MESSAGES_TL;
drop synonym  WF_MESSAGES;
drop synonym  WF_NOTIFICATIONS_S;
drop synonym  WF_ROUTING_RULES_S;

commit;
exit;
