REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=plb \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfprfb.pls
 | DESCRIPTION
 |   PL/SQL body for package:  WF_PREF
 |
 | MODIFICATION LOG:
 |   01/2002 JWSMITH BUG 2001012 - Increased username, admin_role, l_username,
 |           to varchar2(320), display_name to 360
 *=======================================================================*/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

set arraysize 1
set scan off

create or replace package body WF_PREF as
/* $Header: wfprfb.pls 26.35 2005/03/11 06:21:27 anachatt ship $ */


--
-- Package Globals
--

--
-- Error (PRIVATE)
--   Print a page with an error message.
--   Errors are retrieved from these sources in order:
--     1. wf_core errors
--     2. Oracle errors
--     3. Unspecified INTERNAL error
--
procedure Error
as
  error_name      varchar2(30);
  error_message   varchar2(2000);
  error_stack     varchar2(32000);
begin
    htp.htmlOpen;
    htp.headOpen;
    htp.title(wf_core.translate('ERROR'));
    htp.headClose;

    begin
      wfa_sec.Header(background_only=>TRUE);
    exception
      when others then
        htp.bodyOpen;
    end;

    htp.header(nsize=>1, cheader=>wf_core.translate('ERROR'));

    wf_core.get_error(error_name, error_message, error_stack);
    -- Bug 4215720
    error_message:=wf_core.substitutespecialchars(error_message);
    error_stack:=wf_core.substitutespecialchars(error_stack);

    if (error_name is not null) then
        htp.p(error_message);
    else
        htp.p(sqlerrm);
    end if;

    htp.hr;
    htp.p(wf_core.translate('WFENG_ERRNAME')||':  '||error_name);
    htp.br;
    htp.p(wf_core.translate('WFENG_ERRSTACK')||': '||
          replace(error_stack,wf_core.newline,'<br>'));

    wfa_sec.Footer;
    htp.htmlClose;
end Error;

/*===========================================================================

Function        get_open_lov_window_html

Purpose         Get the javascript function to open a lov window based on 
                a url and a window size.  

============================================================================*/
PROCEDURE get_open_lov_window_html IS

BEGIN

   htp.p('<SCRIPT LANGUAGE="JavaScript"> <!-- hide the script''s contents from feeble browsers');

   htp.p(
      'function fnd_open_dm_window(x,y)
       {
          window.focus();
          document.WF_PREF.p_dm_home.value = x + '':''+ y;
       }'
   );

   htp.p('<!-- done hiding from old browsers --> </SCRIPT>');

   htp.p('<NOSCRIPT>' || WF_CORE.Translate('WFA_NOSCRIPT') || '</NOSCRIPT>');

   EXCEPTION
   WHEN OTHERS THEN
      Wf_Core.Context('wf_pref', 
                      'get_open_lov_window_html'); 
      RAISE;

END get_open_lov_window_html;

-- Javascript function to validate new passwords
-- Bug# 2127392

PROCEDURE validate_password IS

BEGIN

   htp.p('<SCRIPT LANGUAGE="JavaScript"> <!-- hide the script''s contents from feeble browsers'); 

   htp.p(
      'function form_submit()
       {
          var l_submit = true;
          if ( document.WF_PREF.p_ldap_npwd.value.length > 0 || document.WF_PREF.p_ldap_rpwd.value.length > 0 )
          {
             if ( document.WF_PREF.p_ldap_npwd.value.length < 5 )
             {
                 l_submit = false;
                 window.alert("' || wf_core.translate('WFPREF_LDAP_PASSWORD_LEN') ||'");
                 document.WF_PREF.p_ldap_npwd.focus();
             }
             else if( document.WF_PREF.p_ldap_npwd.value != document.WF_PREF.p_ldap_rpwd.value )
             {
                 l_submit = false;
                 window.alert("' || wf_core.translate('WFPREF_LDAP_PASSWORD_MISMATCH') || '");
                 document.WF_PREF.p_ldap_rpwd.focus();
             }
           }
           if ( l_submit == true)
              document.WF_PREF.submit();
       }'
   );

   htp.p('<!-- done hiding from old browsers --> </SCRIPT>');

   htp.p('<NOSCRIPT>' || WF_CORE.Translate('WFA_NOSCRIPT') || '</NOSCRIPT>');

   EXCEPTION
   WHEN OTHERS THEN
      Wf_Core.Context('wf_pref',
                      'validate_password');
      RAISE;

END validate_password;


procedure create_reg_button (
when_pressed_url  IN VARCHAR2,
onmouseover       IN VARCHAR2,
icon_top          IN VARCHAR2,
icon_name         IN VARCHAR2,
show_text         IN VARCHAR2)
IS

onmouseover_text varchar2(240) := null;

BEGIN
 
    wfa_html.create_reg_button (when_pressed_url, onmouseover, icon_top, icon_name, show_text);

exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'create_reg_button',when_pressed_url,onmouseover,
                    icon_top,icon_name,show_text);
    wf_pref.Error;

end create_reg_button;

--
-- Edit
--   Edit user preferences
--
procedure edit (edit_defaults in varchar2)
is
  username      varchar2(320);   -- Username to query
  realname      varchar2(360);   -- Display name of username
  admin_role    varchar2(320);   -- Role for admin mode
  admin_mode    varchar2(1);    -- Does user have admin privledges
  s0            varchar2(2000);
  language      varchar2(30);   -- Language preference
  territory     varchar2(30);   -- Territory preference
  mail_type     varchar2(30);   -- Email preference
  text_signon   varchar2(10);   -- Text only signon 
  install_type  varchar2(30);   -- Embedded install vs standalone
  date_format   varchar2(40);   -- date format preference
  dm_node_id    number;         -- Document Management Home preference
  dm_node_name  varchar2(240);
  l_checked     varchar2(1);
  l_media       varchar2(240) := wfa_html.image_loc;
  l_icon        varchar2(30) := 'FNDILOV.gif';
  l_message     varchar2(240)   := wfa_html.replace_onMouseOver_quotes(wf_core.translate ('WFPREF_LOV'));
  l_text        varchar2(30) := '';
  l_onmouseover varchar2(240);
  l_url         varchar2(1000);
  l_error_msg   varchar2(2000) := null;
  web_agent     varchar2(2000);  -- Web agent
  /* 
   ** Bug 2307342
  classid       varchar2(2000);  -- Jinitiator Class id
  plugin_loc    varchar2(2000);  -- Java Plugin (Jinitiator) Download Location
  plugin_ver    varchar2(2000);  -- Java Plugin Version
  */
  l_sguid       raw(16);         -- Local System GUID
  l_sname       varchar2(30);    -- Local System Name
  l_sdname      varchar2(80);    -- Local System Display Name
  l_sstatus     varchar2(240);   -- Local System Status

  l_ldap_host      varchar2(240); -- LDAP host name
  l_ldap_port      varchar2(240); -- LDAP port number
  l_ldap_user      varchar2(240); -- LDAP username
  l_ldap_pwd       varchar2(240); -- LDAP password
  l_ldap_log_base  varchar2(240); -- LDAP directory containing change logs
  l_ldap_user_base varchar2(240); -- LDAP directory containing user records

begin

  -- Check session and current user
  wfa_sec.GetSession(username);
  username := upper(username);
  wf_directory.GetRoleInfo(username, realname, s0, s0, s0, s0);

  IF (edit_defaults = 'Y') THEN

     admin_mode := 'N';
     admin_role := wf_core.translate('WF_ADMIN_ROLE');
     if (admin_role = '*' or 
         Wf_Directory.IsPerformer(username, admin_role)) then
         admin_mode := 'Y';
         username := '-WF_DEFAULT-';
     else
         -- cannot edit defaults unless you're the administrator
         l_error_msg := wf_core.translate('WFPREF_INVALID_ADMIN');

     end if;

     -- get the default web agent
     web_agent := wf_core.translate ('WF_WEB_AGENT');

     /*
     ** Bug 2307342
     ** Jinitiator related info will no longer be 
     ** displayed on the Global Preferences page

     --get the Java Plugin (Jinitiator) related info
     classid    := wf_core.translate ('WF_CLASSID');
     plugin_loc := wf_core.translate ('WF_PLUGIN_DOWNLOAD');
     plugin_ver := wf_core.translate ('WF_PLUGIN_VERSION');
     */

     -- get the local system info
     --l_sguid := Wf_Setup.GetLocalSystemGUID;
     if wf_core.translate('WF_SYSTEM_GUID') <> '[WF_SYSTEM_GUID]' then
       l_sguid := hextoraw(wf_core.translate('WF_SYSTEM_GUID'));

       begin
         select NAME
           into l_sname
           from WF_SYSTEMS
          where GUID = l_sguid;

         l_sdname := l_sname;

       exception
         when NO_DATA_FOUND then
           wf_core.token('GUID', rawtohex(l_sguid));
           l_sdname := wf_core.translate('WFE_SYSTEM_NOGUID');
       end;

     end if;

     -- find out the system status
     l_sstatus := substr(wf_core.translate('WF_SYSTEM_STATUS'), 1, 8);
     if (l_sstatus = 'LOCAL') then
       l_sstatus := wf_core.translate('LOCAL_ONLY');
     elsif (l_sstatus = 'EXTERNAL') then
       l_sstatus := wf_core.translate('EXTERNAL_ONLY');
     else
       l_sstatus := wf_core.translate(l_sstatus);
     end if;

  END IF;

  -- Get the language preference
  language := wf_pref.get_pref (username, 'LANGUAGE');

  -- Get the terriory preference
  territory := wf_pref.get_pref (username, 'TERRITORY');

  -- get the mail preference
  mail_type := wf_pref.get_pref (username, 'MAILTYPE');

  -- get the text mail only preference
  text_signon := wf_pref.get_pref (username, 'WF_SIG_TEXT_ONLY');

  -- get the date format preference
  date_format := wf_pref.get_pref (username, 'DATEFORMAT');

  -- get the installation type (Embedded vs Standalone)
  install_type := wf_core.translate ('WF_INSTALL');

  -- get the document management home node information
  fnd_document_management.get_dm_home (username, dm_node_id, dm_node_name);

  -- get the LDAP related information
  l_ldap_host := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'HOST');
  l_ldap_port := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'PORT');
  l_ldap_user := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'USERNAME');

  -- Bug 2127392
  -- commented password retrieval to avoid display in web page

  -- l_ldap_pwd  := fnd_preference.eget('#INTERNAL','LDAP_SYNCH', 'EPWD', 
  --                                     'LDAP_PWD');
  -- Bug3471734: Added token to translate the text "Not Shown"
  -- l_ldap_pwd := 'Not Shown';
  l_ldap_pwd := wf_core.translate('WFPREF_NOT_SHOWN');

  l_ldap_log_base  := fnd_preference.get('#INTERNAL','LDAP_SYNCH',
                                         'CHANGELOG_DIR');
  l_ldap_user_base := fnd_preference.get('#INTERNAL','LDAP_SYNCH','USER_DIR');


  -- Set page title
  htp.htmlOpen;
  htp.headOpen;
  if (edit_defaults = 'Y') THEN
     htp.title(wf_core.translate('WFPREF_EDIT_DEF_PREFS_TITLE')|| ' - '||realname);
     wfa_html.create_help_function('wf/links/gpr.htm?GPREF');
  else
     htp.title(wf_core.translate('WFPREF_EDIT_PREFS_TITLE')|| ' - '||realname);
     wfa_html.create_help_function('wf/links/upr.htm?UPREF');
  end if;
  
  htp.headClose;

  -- Page header
  if (edit_defaults = 'Y') THEN
     wfa_sec.Header(FALSE, '', wf_core.translate('WFPREF_EDIT_DEF_PREFS_TITLE'), TRUE);
  else
     wfa_sec.Header(FALSE, '', wf_core.translate('WFPREF_EDIT_PREFS_TITLE'), TRUE);
  end if;

  IF (l_error_msg IS NOT NULL) THEN

     htp.center(htf.bold(l_error_msg));
     return;

  END IF;

  htp.tableopen(calign=>'CENTER', cattributes=>'summary=""');

  -- If you can edit the defaults then allow them to set the admin user
  -- and the Web Agent
  if (edit_defaults = 'Y') THEN

     -- admin role title
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WF_ADMIN'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     if (admin_role <> '*') then 

        wf_directory.GetRoleInfo(admin_role, realname, s0, s0, s0, s0);

     else
  
        realname := '*';

     end if;

     htp.tabledata('<B>'||realname||'</B>');

     htp.tableRowClose;

     -- web agent
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFA_WEB_AGENT_DESC'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||web_agent||'</B>');

     htp.tableRowClose;

     /*
     ** Bug 2307342
     ** JInitiator Info will no longer be displayed on the
     ** Global Preferences page

     --jinitiator
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFA_CLASSID_DESC'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||classid||'</B>');

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFA_PLUGIN_DOWNLOAD_DESC'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||plugin_loc||'</B>');

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFA_PLUGIN_VERSION_DESC'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||plugin_ver||'</B>');

     htp.tableRowClose;
     
     */

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('LOCAL_SYSTEM'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_sdname||'</B>');

     htp.tableRowClose;

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('SYSTEM_STATUS'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_sstatus||'</B>');

     htp.tableRowClose;

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_LDAP_HOST_PROMPT'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_ldap_host||'</B>');

     htp.tableRowClose;

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_LDAP_PORT_PROMPT'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_ldap_port||'</B>');

     htp.tableRowClose;

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_LDAP_USER_PROMPT'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_ldap_user||'</B>');

     htp.tableRowClose;

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_LDAP_PASSWORD_PROMPT'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_ldap_pwd||'</B>');

     htp.tableRowClose;

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate(
                                         'WFPREF_LDAP_CHNGLOGDIR_PROMPT'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_ldap_log_base||'</B>');

     htp.tableRowClose;

     htp.tableRowClose;
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_LDAP_USERDIR_PROMPT'),
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData('<B>'||l_ldap_user_base||'</B>');

     htp.tableRowClose;

  end if;

  -- Only show language/territory/date format if this is standalone install
  IF (install_type = 'STANDALONE') THEN

     -- Language
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_LANGUAGE_PROMPT'), 
                   calign=>'right');

     htp.tableData('<B>'||language||'</B>');

     htp.tableRowClose;

     -- Territory
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_TERRITORY_PROMPT'), 
                   calign=>'right');

     htp.tableData('<B>'||territory||'</B>');


     htp.tableRowClose;

     -- Date Format
     htp.tableRowOpen;
     htp.tableData(cvalue=>wf_core.translate('WFPREF_DATE_FORMAT'), 
                   calign=>'right');

     htp.tableData('<B>'||date_format||'</B>');


     htp.tableRowClose;

  END IF;

  -- Document Management Home Node
  htp.tableRowOpen;
  htp.tableData(cvalue=>wf_core.translate('WFPREF_DMHOME_PROMPT'), 
         calign=>'right');

  htp.tableData('<B>'||dm_node_name||'</B>');

  htp.tableRowClose;
  
  htp.tablerowopen;

  htp.tableData(cvalue=>wf_core.translate('WFPREF_SENDEMAIL_PROMPT'),
                calign=>'RIGHT');
  
  -- Mail Type field
  IF (mail_type = 'MAILHTML') THEN

      htp.tableData('<B>'||wf_core.translate('WFPREF_SENDHTML_PROMPT')||'</B>');

  ELSIF (mail_type = 'MAILTEXT') THEN

     htp.tableData('<B>'||wf_core.translate('WFPREF_SENDPLAIN_PROMPT')||'</B>');

  ELSIF (mail_type = 'MAILATTH') THEN

    htp.tableData('<B>'||wf_core.translate('WFPREF_SENDATTACH_PROMPT')||'</B>');

  ELSIF (mail_type = 'MAILTEXT') THEN

     htp.tableData('<B>'||wf_core.translate('WFPREF_SENDPLAIN_PROMPT')||'</B>');

  ELSIF (mail_type = 'SUMMARY') THEN

     htp.tableData('<B>'||wf_core.translate('WFPREF_SENDSUMMARY_PROMPT')||'</B>');

  ELSIF (mail_type = 'SUMHTML') THEN

     htp.tableData('<B>'||wf_core.translate('WFPREF_SENDSUMHTML_PROMPT')||'</B>');

  ELSIF (mail_type = 'QUERY' or mail_type IS NULL) THEN

     htp.tableData('<B>'||wf_core.translate('WFPREF_QUERYONLY_PROMPT')||'</B>');

  ELSIF (mail_type = 'MAILHTM2' or mail_type IS NULL) THEN

     htp.tableData('<B>'||wf_core.translate('WFPREF_SENDHTM2_PROMPT')||'</B>');

  ELSIF (mail_type = 'DISABLED' or mail_type IS NULL) THEN

     htp.tableData('<B>'||wf_core.translate('WFPREF_DISABLED_PROMPT')||'</B>');

  END IF;

  htp.tablerowclose;
 
  if (install_type = 'STANDALONE' and edit_defaults = 'Y') then 
     htp.tablerowopen;

     htp.tableData(cvalue=>wf_core.translate('WFPREF_TEXT_SIGNON'),
                   calign=>'RIGHT');

     IF (text_signon = 'Y') THEN
        htp.tableData('<B>'||wf_core.translate('YES')||'</B>');
     ELSE
        htp.tableData('<B>'||wf_core.translate('NO')||'</B>');
     END IF;
     htp.tablerowclose;
  end if;

  htp.tableclose;
  htp.br;
  htp.tableopen(calign=>'CENTER');

  --Submit Button

  htp.tableRowOpen;

  l_url         := owa_util.get_owa_service_path||
                   'wf_pref.edit_form?edit_defaults='||edit_defaults;
  l_icon        := 'FNDJLFOK.gif';
  l_text        := wf_core.translate ('UPDATE');
  l_onmouseover := wf_core.translate ('UPDATE');

  htp.p('<TD>');

  wf_pref.create_reg_button (l_url, l_onmouseover, l_media, l_icon, l_text);

  htp.p('</TD>');

  htp.tableRowClose;

  htp.tableclose;

  htp.formClose;

  wfa_sec.Footer;
  htp.htmlClose;

exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'Edit', edit_defaults);
    wf_pref.Error;
end edit;

--
-- Edit
--   Edit user preferences
--
procedure edit_form (edit_defaults in varchar2)
is
  username      varchar2(320);   -- Username to query
  realname      varchar2(360);   -- Display name of username
  admin_role    varchar2(320);   -- Role for admin mode
  admin_mode    varchar2(1);    -- Does user have admin privledges
  s0            varchar2(2000);
  language      varchar2(30);   -- Language preference
  territory     varchar2(30);   -- Territory preference
  mail_type     varchar2(30);   -- Email preference
  text_signon   varchar2(10);   -- Test only signon
  dm_node_id    number;         -- Document Management Home preference
  dm_node_name  varchar2(240);
  install_type  varchar2(30);   -- Embedded install vs standalone
  date_format   varchar2(40);   -- date format preference
  l_checked      varchar2(1);
  l_media       varchar2(240) := wfa_html.image_loc;
  l_icon        varchar2(30) := 'FNDILOV.gif';
  l_text        varchar2(30) := '';
  l_onmouseover varchar2(240);
  l_url         varchar2(1000);
  l_mail_pref             varchar2(20);
  l_error_msg varchar2(2000) := null;
  web_agent     varchar2(2000);  -- Web agent
  /* 
  ** Bug 2307342
  ** Global preferences page will no longer display
  ** Jinitiator Info

  classid       varchar2(2000);  -- Jinitiator Class id
  plugin_loc    varchar2(2000);  -- Java Plugin (Jinitiator) Download Location
  plugin_ver    varchar2(2000);  -- Java Plugin Version
  */

  l_ldap_host      varchar2(240); -- LDAP host name
  l_ldap_port      varchar2(240); -- LDAP port number
  l_ldap_user      varchar2(240); -- LDAP username
  l_ldap_pwd       varchar2(240); -- LDAP password
  l_ldap_log_base  varchar2(240); -- LDAP directory containing change logs
  l_ldap_user_base varchar2(240); -- LDAP directory containing user records

  l_sguid       raw(16);         -- Local System GUID
  l_sname       varchar2(30);    -- Local System Name
  l_sdname      varchar2(80);    -- Local System Display Name
  l_sstatus     varchar2(240);   -- Local System Status
  template      varchar2(4000);
  l_message     varchar2(240)   := wfa_html.replace_onMouseOver_quotes(wf_core.translate('WFPREF_LOV'));
  selected      boolean := FALSE;

  cursor get_lang is
        SELECT CODE,
               NLS_LANGUAGE,
               NLS_TERRITORY
        FROM   wf_languages
        WHERE  installed_flag = 'Y'
        ORDER BY NLS_LANGUAGE;

  cursor get_mail is
        select NAME, TEXT
        from WF_RESOURCES
        where TYPE = 'WFTKN'
        and NAME LIKE 'WFPREF_MAILP%'
        and LANGUAGE = userenv('LANG')
        ORDER BY NAME;

  CURSOR get_dm is
   SELECT  node_id, node_name
   FROM   fnd_dm_nodes
   ORDER  BY node_name;

begin

  -- Check session and current user
  wfa_sec.GetSession(username);
  username := upper(username);
  wf_directory.GetRoleInfo(username, realname, s0, s0, s0, s0);

  IF (edit_defaults = 'Y') THEN 

     admin_mode := 'N';
     admin_role := wf_core.translate('WF_ADMIN_ROLE');
     if (admin_role = '*' or 
         Wf_Directory.IsPerformer(username, admin_role)) then
         admin_mode := 'Y';
         username := '-WF_DEFAULT-';
     else
         -- cannot edit defaults unless you're the administrator
         l_error_msg := wf_core.translate('WFPREF_INVALID_ADMIN');

     end if;

     -- get the default web agent
     web_agent := wf_core.translate('WF_WEB_AGENT');

     /*
     ** Bug 2307342
     ** Jinitiator Info will no longer be displayed
     ** on the Global Preferences Page

     --get the Java Plugin (Jinitiator) related info
     classid    := wf_core.translate ('WF_CLASSID');
     plugin_loc := wf_core.translate ('WF_PLUGIN_DOWNLOAD');
     plugin_ver := wf_core.translate ('WF_PLUGIN_VERSION');
     */

     -- get the local system info
     if wf_core.translate('WF_SYSTEM_GUID') <> '[WF_SYSTEM_GUID]' then
       l_sguid := hextoraw(wf_core.translate('WF_SYSTEM_GUID'));

       begin
         select NAME
           into l_sname
           from WF_SYSTEMS
          where GUID = l_sguid;

         l_sdname := l_sname;

       exception
         when NO_DATA_FOUND then
           wf_core.token('GUID', rawtohex(l_sguid));
           l_sdname := wf_core.translate('WFE_SYSTEM_NOGUID');
       end;

     end if;

     -- find out the system status
     l_sstatus := substr(wf_core.translate('WF_SYSTEM_STATUS'), 1, 8);

  END IF;

  -- Get the language preference
  language := wf_pref.get_pref (username, 'LANGUAGE');

  -- Get the language preference
  territory := wf_pref.get_pref (username, 'TERRITORY');

  -- get the mail preference
  mail_type := wf_pref.get_pref (username, 'MAILTYPE');

  -- get text only mail preference
  text_signon := wf_pref.get_pref (username, 'WF_SIG_TEXT_ONLY');

  -- get the date format preference
  date_format := wf_pref.get_pref (username, 'DATEFORMAT');

  -- get the installation type (Embedded vs Standalone)
  install_type := wf_core.translate ('WF_INSTALL');

  -- get the document management home node information
  fnd_document_management.get_dm_home (username, dm_node_id, dm_node_name);


  -- get the LDAP related information
  l_ldap_host := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'HOST');
  l_ldap_port := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'PORT');
  l_ldap_user := fnd_preference.get('#INTERNAL', 'LDAP_SYNCH', 'USERNAME');

  -- commented ldap password retrieval for Bug 2127392
  --l_ldap_pwd  := fnd_preference.eget('#INTERNAL','LDAP_SYNCH', 'EPWD', 
  --                                   'LDAP_PWD');
  l_ldap_pwd := NULL;

  l_ldap_log_base  := fnd_preference.get('#INTERNAL','LDAP_SYNCH',
                                         'CHANGELOG_DIR');
  l_ldap_user_base := fnd_preference.get('#INTERNAL','LDAP_SYNCH','USER_DIR');


  -- Set page title
  htp.htmlOpen;
  htp.headOpen;
  if (edit_defaults = 'Y') THEN
     htp.title(wf_core.translate('WFPREF_EDIT_DEF_PREFS_TITLE')|| ' - '||realname);
     wfa_html.create_help_function('wf/links/gpr.htm?GPREF');
  else
     htp.title(wf_core.translate('WFPREF_EDIT_PREFS_TITLE')|| ' - '||realname);
     wfa_html.create_help_function('wf/links/upr.htm?UPREF');
  end if;
  
  fnd_document_management.get_open_dm_display_window;
  wf_pref.get_open_lov_window_html;
  wf_lov.OpenLovWinHtml;
  wf_pref.validate_password;  -- Bug# 2127392

  htp.headClose;

  -- Page header
  if (edit_defaults = 'Y') THEN
     wfa_sec.Header(FALSE, '', wf_core.translate('WFPREF_EDIT_DEF_PREFS_TITLE'), TRUE);
  else
     wfa_sec.Header(FALSE, '', wf_core.translate('WFPREF_EDIT_PREFS_TITLE'), TRUE);
  end if;

  IF (l_error_msg IS NOT NULL) THEN

     htp.center(htf.bold(l_error_msg));
     return;

  END IF;

  htp.tableopen(calign=>'CENTER', cattributes=>'summary=""');

  htp.p('<FORM NAME="WF_PREF" ACTION="'||wfa_html.base_url||
         '/wf_pref.update_pref" METHOD="POST">');

  htp.formHidden(cname=>'p_edit_defaults', cvalue=>edit_defaults);

  -- If you can edit the defaults then allow them to set the admin user
  -- and the Web Agent
  if (edit_defaults = 'Y') THEN

     htp.formHidden('p_admin_role', admin_role);

     if (admin_role <> '*') then 

        wf_directory.GetRoleInfo(admin_role, realname, s0, s0, s0, s0);

     else
  
        realname := '*';

     end if;

     -- admin role title
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_admin">' ||
                           wf_core.translate('WF_ADMIN') || '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

    -- add LOV here: Note:bottom is name of frame.
    -- Note: The REPLACE function replaces all the space characters with
    -- the proper escape sequence.
    l_url := 'javascript:fnd_open_dm_display_window('||''''||
              REPLACE('wf_lov.display_lov?p_lov_name='||'owner'||
              '&p_display_name='||'WFA_FIND_USER'||
              '&p_validation_callback=wfa_html.wf_user_val'||
              '&p_dest_hidden_field=top.opener.parent.document.WF_PREF.p_admin_role.value'||
              '&p_current_value=top.opener.parent.document.WF_PREF.p_display_admin_role.value'||
              '&p_display_key='||'Y'||
              '&p_dest_display_field=top.opener.parent.document.WF_PREF.p_display_admin_role.value',
                ' ', '%20')||''''||',500,500)';

     htp.tabledata(htf.formText(cname=>'p_display_admin_role', csize=>30, 
                        cmaxlength=>360,             
                        cvalue=>realname,
                        cattributes=>'id="i_admin"')||
                        '<A href='||l_url|| '>'||                         
                        '<IMG src="'||l_media||l_icon|| '" border=0 alt="'||
                           l_message||'" onmouseover="window.status='||''''||
                           l_message||''''||';return true"></A>', 
                        cattributes=>'id=""');


     htp.tableRowClose;

     -- web agent
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_webagent">' ||
                           wf_core.translate('WFA_WEB_AGENT_DESC') || 
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle, id="' ||
                   WF_CORE.Translate('WFA_WEB_AGENT_DESC') || '"');

     htp.tableData(cvalue=>htf.formText(cname=>'p_web_agent',
                                     csize=>'40',
                                     cvalue=>web_agent,
                                     cmaxlength=>'240',
                                     cattributes=>'id="i_webagent"'),
                   calign=>'left',
                   cattributes=>'id=""');
     htp.tableRowClose;

     /*
     ** Bug 2307342
     ** JInitiator Details will no longer be displayed on the
     ** Global Preferences page

     --jinitiator
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_classid">' ||
                   wf_core.translate('WFA_CLASSID_DESC') || '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle, id=""');

     htp.tableData(cvalue=>htf.formText(cname=>'p_classid',
                                     csize=>'40',
                                     cvalue=>classid,
                                     cmaxlength=>'240',
                                     cattributes=>'id="i_classid"'),
                   calign=>'left',
                   cattributes=>'id=""');
     htp.tableRowClose;

     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_plugin_loc">' ||
                           wf_core.translate('WFA_PLUGIN_DOWNLOAD_DESC') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle, id=""');

     htp.tableData(cvalue=>htf.formText(cname=>'p_plugin_loc',
                                     csize=>'40',
                                     cvalue=>plugin_loc,
                                     cmaxlength=>'240',
                                     cattributes=>'id="i_plugin_loc"'),
                   calign=>'left',
                   cattributes=>'id=""');
     htp.tableRowClose;

     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_plugin_ver">' ||
                           wf_core.translate('WFA_PLUGIN_VERSION_DESC') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

     htp.tableData(cvalue=>htf.formText(cname=>'p_plugin_ver',
                                     csize=>'40',
                                     cvalue=>plugin_ver,
                                     cmaxlength=>'240',
                                     cattributes=>'id="i_plugin_ver"'),
                   calign=>'left');
     htp.tableRowClose;
     */

     -- Local System
     htp.tableRowOpen;
     htp.formHidden('p_system_guid', rawtohex(l_sguid));
     htp.tableData(cvalue=>'<LABEL FOR="i_system_name">' || 
                           wf_core.translate('LOCAL_SYSTEM') || '</LABEL>', 
                   calign=>'right');
     -- add LOV here:
     -- Note: The REPLACE function replaces all the space characters with
     -- the proper escape sequence.
     l_url := 'javascript:fnd_open_dm_display_window('||''''||
              REPLACE('wf_lov.display_lov?p_lov_name='||'p_system_guid'||
              '&p_display_name='||'SYSTEM'||
              '&p_validation_callback=wf_event_html.wf_system_val'||
              '&p_dest_hidden_field=top.opener.parent.document.WF_PREF.p_system_guid.value'||
              '&p_current_value=top.opener.parent.document.WF_PREF.p_system_name.value'||
               '&p_display_key='||'Y'||
              '&p_dest_display_field=top.opener.parent.document.WF_PREF.p_system_name.value',
              ' ', '%20')||''''||',500,500)';

     -- print everything together so there is no gap.
     htp.tabledata(htf.formText(cname=>'p_system_name',
                cvalue=>l_sdname, csize=>32, cmaxlength=>240,
                cattributes=>'id="i_system_name"')||
                '<A href='||l_url||'>'||
                '<IMG src="'||l_media||l_icon||'" border=0 alt="'||
                     l_message||'" onmouseover="window.status='||''''||
                     l_message||''''||';return true"></A>',
                   cattributes=>'id=""');

     htp.tableRowClose;

     -- System Status
     template := htf.formSelectOpen('p_system_status', 
                                    cattributes=>'id="i_system_status"') || wf_core.newline;
     if (l_sstatus = 'LOCAL') then
       template := template||htf.formSelectOption(
                                 wf_core.translate('LOCAL_ONLY'),
                   'SELECTED', 'VALUE="'||l_sstatus||'"')||wf_core.newline;
       selected := TRUE;
     else
       template := template||htf.formSelectOption(
                                 wf_core.translate('LOCAL_ONLY'),
                   NULL, 'VALUE="LOCAL"')||wf_core.newline;
     end if;
     if (l_sstatus = 'EXTERNAL') then
       template := template||htf.formSelectOption(
                                 wf_core.translate('EXTERNAL_ONLY'),
                   'SELECTED', 'VALUE="'||l_sstatus||'"')||wf_core.newline;
       selected := TRUE;
     else
       template := template||htf.formSelectOption(
                                 wf_core.translate('EXTERNAL_ONLY'),
                   NULL, 'VALUE="EXTERNAL"')||wf_core.newline;
     end if;
     if (l_sstatus = 'ENABLED') then
       template := template||htf.formSelectOption(wf_core.translate(l_sstatus),
                   'SELECTED', 'VALUE="'||l_sstatus||'"')||wf_core.newline;
       selected := TRUE;
     else
       template := template||htf.formSelectOption(wf_core.translate('ENABLED'),
                   NULL, 'VALUE="ENABLED"')||wf_core.newline;
     end if;
     -- Default to DISABLED if nothing has been set.
     if (not selected) then
       template := template||htf.formSelectOption(wf_core.translate('DISABLED'),
                   'SELECTED', 'VALUE="DISABLED"')||wf_core.newline;
       selected := TRUE;
     else
       template := template||htf.formSelectOption(wf_core.translate('DISABLED'),
                   NULL, 'VALUE="DISABLED"')||wf_core.newline;
     end if;
     template := template||htf.formSelectClose;

     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_system_status">' || 
                           wf_core.translate('SYSTEM_STATUS') ||
                           '</LABEL>', 
                   calign=>'Right');
     htp.tableData(cvalue=>template, calign=>'Left', cattributes=>'id=""');
     htp.tableRowClose;

     -- LDAP host
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_host">' || 
                           wf_core.translate('WFPREF_LDAP_HOST_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

     htp.tableData(cvalue=>htf.formText(cname=>'p_ldap_host',
                                        csize=>'40',
                                        cvalue=>l_ldap_host,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_host"'),
                                        calign=>'left');
     htp.tableRowClose;

     -- LDAP port
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_port">' ||
                           wf_core.translate('WFPREF_LDAP_PORT_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

     htp.tableData(cvalue=>htf.formText(cname=>'p_ldap_port',
                                        csize=>'10',
                                        cvalue=>l_ldap_port,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_port"'),
                                        calign=>'left');
     htp.tableRowClose;

     -- LDAP user
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_user">' || 
                           wf_core.translate('WFPREF_LDAP_USER_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

     htp.tableData(cvalue=>htf.formText(cname=>'p_ldap_user',
                                        csize=>'20',
                                        cvalue=>l_ldap_user,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_user"'),
                                        calign=>'left');
     htp.tableRowClose;

/* Bug 2127392 */

     -- Added Old LDAP password field to capture old LDAP password
     -- to check authenticity before changing the LDAP password
     -- New LDAP passwrods are captured twice to ensure the password is
     -- corrent and checked in the PL/SQL procedure 

     -- LDAP password
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_opwd">' ||
                           wf_core.translate('WFPREF_OLD_LDAP_PWD_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

     -- changed htf.formText to htf.formPassword for Bug 2127392
     htp.tableData(cvalue=>htf.formPassword(cname=>'p_ldap_opwd',
                                        csize=>'20',
                                        cvalue=>l_ldap_pwd,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_opwd"'),
                                        calign=>'left');
     htp.tableRowClose;

     -- New LDAP password Bug 2127392
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_npwd">' ||
                           wf_core.translate('WFPREF_NEW_LDAP_PWD_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

    -- changed htf.formText to htf.formPassword for Bug 2127392
    htp.tableData(cvalue=>htf.formPassword(cname=>'p_ldap_npwd',
                                        csize=>'20',
                                        cvalue=>l_ldap_pwd,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_npwd"'),
                                        calign=>'left');
     htp.tableRowClose;

     -- confirm LDAP password added for Bug 2127392
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_rpwd">' ||
                           wf_core.translate('WFPREF_REP_LDAP_PWD_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle id=""');

    -- changed htf.formText to htf.formPassword for Bug 2127392
    htp.tableData(cvalue=>htf.formPassword(cname=>'p_ldap_rpwd',
                                        csize=>'20',
                                        cvalue=>l_ldap_pwd,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_rpwd"'),
                                        calign=>'left');
     htp.tableRowClose;

     -- LDAP Change Log base directory
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_log_base">' ||
                           wf_core.translate('WFPREF_LDAP_CHNGLOGDIR_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData(cvalue=>htf.formText(cname=>'p_ldap_log_base',
                                        csize=>'40',
                                        cvalue=>l_ldap_log_base,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_log_base"'),
                                        calign=>'left');
     htp.tableRowClose;

     -- LDAP user base directory
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_ldap_user_base">' ||
                           wf_core.translate('WFPREF_LDAP_USERDIR_PROMPT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData(cvalue=>htf.formText(cname=>'p_ldap_user_base',
                                        csize=>'40',
                                        cvalue=>l_ldap_user_base,
                                        cmaxlength=>'240',
                                        cattributes=>'id="i_ldap_user_base"'),
                                        calign=>'left');
     htp.tableRowClose;

  end if;

  -- Only show language/territory/date format if this is standalone install
  IF (install_type = 'STANDALONE') THEN

     -- Language
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_language">' ||
                            wf_core.translate('WFPREF_LANGUAGE_PROMPT') ||
                           '</LABEL>', 
                   calign=>'right');

     htp.p('<TD ALIGN="LEFT">');

     htp.p('<SELECT NAME="p_language" SIZE="1" id="i_language">');

     for prec in get_lang loop

        if (prec.NLS_LANGUAGE = language) then

          htp.p('<OPTION VALUE="' || prec.NLS_LANGUAGE ||
                       '" SELECTED> ' || prec.NLS_LANGUAGE || ' [' ||
                       prec.NLS_LANGUAGE || '-' || prec.NLS_TERRITORY || ']');
        else

          htp.p('<OPTION VALUE="' || prec.NLS_LANGUAGE ||
                       '"> ' || prec.NLS_LANGUAGE || ' [' ||
                       prec.NLS_LANGUAGE || '-' || prec.NLS_TERRITORY || ']');

        end if;

     end loop;

     htp.p('</SELECT>');
     htp.p('</TD>');

     htp.tableRowClose;

     -- Territory
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_territory">' ||
                           wf_core.translate('WFPREF_TERRITORY_PROMPT') ||
                           '</LABEL>', 
                   calign=>'right');

     htp.p ('<TD id="">');
     htp.p('<SELECT NAME="p_territory" SIZE="1" id="i_territory">');

     for prec in get_lang loop

        if (prec.nls_territory = territory) then

          htp.p('<OPTION VALUE="' || prec.NLS_TERRITORY ||
                       '" SELECTED> ' || prec.NLS_TERRITORY || ' [' ||
                       prec.NLS_TERRITORY || '-' || prec.NLS_LANGUAGE || ']');
        else

          htp.p('<OPTION VALUE="' || prec.NLS_TERRITORY ||
                       '"> ' || prec.NLS_TERRITORY || ' [' ||
                       prec.NLS_TERRITORY || '-' || prec.NLS_LANGUAGE || ']');

        end if;

     end loop;

     htp.p('</SELECT>');
     htp.p('</TD>');

     htp.tableRowClose;

     -- date format
     htp.tableRowOpen;
     htp.tableData(cvalue=>'<LABEL FOR="i_date_format">' ||
                           wf_core.translate('WFPREF_DATE_FORMAT') ||
                           '</LABEL>',
                   calign=>'right',
                   cattributes=>'valign=middle');

     htp.tableData(cvalue=>htf.formText(cname=>'p_date_format',
                                     csize=>'20',
                                     cvalue=>date_format,
                                     cmaxlength=>'40',
                                     cattributes=>'id="i_date_format"'),
                   calign=>'left');

     htp.tableRowClose;

  END IF;

  -- Document Management Home Node
  htp.tableRowOpen;

  htp.formHidden(cname=>'p_dm_home', cvalue=>null);

  htp.tableData('<LABEL FOR="i_dm_node_id">' ||
                wf_core.translate('WFPREF_DMHOME_PROMPT') ||
                '</LABEL>', calign=>'RIGHT');

  htp.p('<TD ALIGN="LEFT" id="">');
  htp.p('<SELECT NAME="p_dm_node_id" SIZE="1" id="i_dm_node_id">');
  
  for dm in get_dm loop
  
    if (dm.node_id = dm_node_id) then
  
      htp.p('<OPTION VALUE="' || dm.node_id ||
            '" SELECTED> ' || dm.node_name);
  
    else
  
      htp.p('<OPTION VALUE="' || dm.node_id ||
           '"> ' || dm.node_name );
  
     end if;
  
  end loop;
  
  htp.p('</SELECT>');
  htp.p('</TD>');

  htp.tableRowClose;

  htp.tablerowopen;
  htp.tableData(cvalue=>'<LABEL FOR="i_mailtype">' ||
                        wf_core.translate('WFPREF_SENDEMAIL_PROMPT') ||
                        '</LABEL>', 
                calign=>'RIGHT');
  
  htp.p('<TD ALIGN="LEFT" id="">');
  htp.p('<SELECT NAME="p_mailtype" SIZE="1" id="i_mailtype">');
  
  /*
  ** The get_mail cursor is used to fetch the codes and display names
  ** used for the mail preference values.
  ** I've named the prompts for the mail options appropriately so
  ** they can be uniquely fetched in a list and dropped easily into
  ** a poplist.  The codes for mail preferences are 
  ** MAILHTML, MAILATTH, MAILTEXT, etc. The corresponding prompts for
  ** these options are  WFPREF_MAILP1-MAILHTML, WFPREF_MAILP2-MAILATTH,
  ** WFPREF_MAILP3-MAILTEXT etc.  I drop  WFPREF_MAILP#- part and leave
  ** the code that we'll save in the database for this preference.
  ** The WFPREF_MAILP# portion allows me to sort these as I wish.  
  */
  for mail in get_mail loop

      l_mail_pref := SUBSTR(mail.name, INSTR(mail.name, '-') + 1);
  
      if (l_mail_pref = mail_type) then
         htp.p('<OPTION VALUE="' || l_mail_pref || '" SELECTED> ' || mail.text);
      else
        htp.p('<OPTION VALUE="' || l_mail_pref ||'"> ' || mail.text );
      end if;
  end loop;
  
  htp.p('</SELECT>');
  htp.p('</TD>');

  htp.tablerowclose;

  -- Get value for preference WF_SIG_TEXT_ONLY through Global
  -- User preference screen if it is a Standalone install
  if (install_type = 'STANDALONE' and edit_defaults = 'Y') then  

     -- Send Text Notifications only    
     htp.tableRowOpen;

     htp.tableData('<LABEL FOR="i_text_signon">' ||
                  wf_core.translate('WFPREF_TEXT_SIGNON') ||
                  '</LABEL>', calign=>'RIGHT');

     htp.p('<TD ALIGN="LEFT" id="">');
     htp.p('<SELECT NAME="p_text_signon" SIZE="1" id="i_text_signon">');

     if (text_signon = 'Y') then 
        htp.p('<OPTION VALUE="Y" SELECTED>' || wf_core.translate('YES'));
        htp.p('<OPTION VALUE="N">' || wf_core.translate('NO'));
     else
        htp.p('<OPTION VALUE="Y">' || wf_core.translate('YES'));
        htp.p('<OPTION VALUE="N" SELECTED>' || wf_core.translate('NO'));
     end if;
 
     htp.p('</SELECT>');
     htp.p('</TD>');

     htp.tableRowClose;
  end if;

  htp.tableclose;

  htp.br;

  htp.tableopen(calign=>'CENTER', cattributes=>'summary=""');

  --Submit Button

  htp.tableRowOpen;
  -- Bug# 2411267 URL for user preference and Global preference should
  -- be different.
  if (edit_defaults = 'Y') then
     l_url      := 'javascript:form_submit()';
  else
     l_url	:= 'javascript:document.WF_PREF.submit()';
  end if;

  l_icon        := 'FNDJLFOK.gif';
  l_text        := wf_core.translate ('WFMON_OK');
  l_onmouseover := wf_core.translate ('WFMON_OK');

  htp.p('<TD id="">');

  wf_pref.create_reg_button (l_url, l_onmouseover, l_media, l_icon, l_text);

  htp.p('</TD>');

  l_url         := wfa_html.base_url||
                   '/wf_pref.edit?edit_defaults='||edit_defaults;
  l_icon        := 'FNDJLFCN.gif';
  l_text        := wf_core.translate ('CANCEL');
  l_onmouseover := wf_core.translate ('CANCEL');

  htp.p('<TD id="">');

  wf_pref.create_reg_button (l_url, l_onmouseover, l_media, l_icon, l_text);

  htp.p('</TD>');

  htp.tableRowClose;

  htp.tableclose;

  htp.formClose;

  wfa_sec.Footer;
  htp.htmlClose;

exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'Edit_Form', edit_defaults);
    wf_pref.Error;
end edit_form;

--
-- Lang_LOV
--   Create the data for the Language List of Values
--
procedure Lang_LOV (p_titles_only   IN VARCHAR2,
                    p_find_criteria IN VARCHAR2)

IS

l_username VARCHAR2(320);
l_code      VARCHAR2(4);
l_language  VARCHAR2(30);
l_territory VARCHAR2(30);
l_row_count NUMBER := 0;

CURSOR c_lang_lov (c_find_criteria IN VARCHAR2) IS
SELECT nls_language, nls_territory, code
FROM   wf_languages
WHERE  nls_language like c_find_criteria
AND    installed_flag = 'Y'
ORDER  BY nls_language;

BEGIN
   -- Authenticate user
   wfa_sec.GetSession(l_username);

   IF (p_titles_only = 'N') THEN 

      SELECT COUNT(*)
      INTO   l_row_count
      FROM   wf_languages
      WHERE  nls_language like p_find_criteria||'%'
      AND    installed_flag = 'Y';

   END IF;
     
   htp.p(wf_core.translate('WFPREF_LANGUAGE_PROMPT'));
   htp.p('3');
   htp.p(TO_CHAR(l_row_count));
   htp.p(wf_core.translate('WFPREF_LANGUAGE_PROMPT'));
   htp.p('50');
   htp.p(wf_core.translate('WFPREF_TERRITORY_PROMPT'));
   htp.p('50');
   htp.p('CODE');
   htp.p('0');

   IF (p_titles_only = 'N') THEN 

      OPEN c_lang_lov (p_find_criteria||'%');
   
      /*
      ** Loop through all the language rows for the given find_criteria
      ** and write them out to the web page
      */
      LOOP 
   
         FETCH c_lang_lov INTO 
             l_language, l_territory, l_code;
   
         EXIT WHEN c_lang_lov%NOTFOUND;
   
         htp.p (l_language);
         htp.p (l_territory);
         htp.p (l_code);
   
      END LOOP;

   END IF;

exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'lang_lov',p_titles_only, p_find_criteria);
    wf_pref.Error;
END lang_lov;

--
-- Terr_LOV
--   Create the data for the Territories List of Values
--
procedure Terr_LOV (p_titles_only   IN VARCHAR2,
                    p_find_criteria IN VARCHAR2)

IS

l_code      VARCHAR2(4);
l_territory VARCHAR2(30);
l_language  VARCHAR2(30);
l_row_count NUMBER := 0;
l_username  VARCHAR2(320);

CURSOR c_Terr_lov (c_find_criteria IN VARCHAR2) IS
SELECT  
 nls_territory,
 nls_language,
 code
FROM   wf_languages
WHERE  nls_territory like c_find_criteria
AND    installed_flag = 'Y'
ORDER  BY nls_language;

BEGIN

   -- Authenticate user
   wfa_sec.GetSession(l_username);

   IF (p_titles_only = 'N') THEN 

      SELECT COUNT(*)
      INTO   l_row_count
      FROM   wf_languages
      WHERE  nls_territory like p_find_criteria||'%'
      AND    installed_flag = 'Y';

   END IF;
     
   htp.p(wf_core.translate('WFPREF_TERRITORY_PROMPT'));
   htp.p('3');
   htp.p(TO_CHAR(l_row_count));
   htp.p(wf_core.translate('WFPREF_TERRITORY_PROMPT'));
   htp.p('50');
   htp.p(wf_core.translate('WFPREF_LANGUAGE_PROMPT'));
   htp.p('50');
   htp.p('Code');
   htp.p('0');

   IF (p_titles_only = 'N') THEN 

      OPEN c_Terr_lov (p_find_criteria||'%');
   
      /*
      ** Loop through all the language rows for the given find_criteria
      ** and write them out to the web page
      */
      LOOP 
   
         FETCH c_Terr_lov INTO 
             l_territory, l_language, l_code;
   
         EXIT WHEN c_Terr_lov%NOTFOUND;
   
         htp.p (l_territory);
         htp.p (l_language);
         htp.p (l_code);
   
      END LOOP;

   END IF;

exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'Terr_lov',p_titles_only, p_find_criteria);
    wf_pref.Error;
END terr_lov;

--
-- DM_LOV
--   Create the data for the Territories List of Values
--
procedure DM_LOV (p_titles_only   IN VARCHAR2,
                  p_find_criteria IN VARCHAR2)

IS

l_username  VARCHAR2(320);
l_node_id   NUMBER;
l_node_name VARCHAR2(80);
l_node_desc VARCHAR2(240);
l_row_count NUMBER := 0;

CURSOR c_dm_lov (c_find_criteria IN VARCHAR2) IS
SELECT  
node_id,
node_name,
node_description
FROM   fnd_dm_nodes
WHERE  node_name like p_find_criteria||'%'
ORDER  BY node_name;

BEGIN

   -- Authenticate user
   wfa_sec.GetSession(l_username);

   IF (p_titles_only = 'N') THEN 

      SELECT COUNT(*)
      INTO   l_row_count
      FROM   fnd_dm_nodes
      WHERE  node_name like p_find_criteria||'%';

   END IF;
     
   htp.p(wf_core.translate('WFPREF_DMHOME_PROMPT'));
   htp.p('3');
   htp.p(TO_CHAR(l_row_count));
   htp.p(wf_core.translate('WFPREF_DMHOME_PROMPT'));
   htp.p('40');
   htp.p(wf_core.translate('DESCRIPTION'));
   htp.p('60');
   htp.p('NODE_ID');
   htp.p('0');

   IF (p_titles_only = 'N') THEN 

      OPEN c_dm_lov (p_find_criteria||'%');
   
      /*
      ** Loop through all the language rows for the given find_criteria
      ** and write them out to the web page
      */
      LOOP 
   
         FETCH c_dm_lov INTO 
             l_node_id, l_node_name,l_node_desc;
   
         EXIT WHEN c_dm_lov%NOTFOUND;
   
         htp.p (l_node_name);
         htp.p (l_node_desc);
         htp.p (TO_CHAR(l_node_id));
   
      END LOOP;

   END IF;

exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'DM_lov',p_titles_only, p_find_criteria);
    wf_pref.Error;
END DM_LOV;


PROCEDURE update_pref (
p_admin_role            IN VARCHAR2,
p_display_admin_role    IN VARCHAR2,
p_web_agent             IN VARCHAR2,
p_edit_defaults         IN VARCHAR2,
p_language              IN VARCHAR2,
p_territory             IN VARCHAR2,
p_date_format           IN VARCHAR2,
p_dm_node_id            IN VARCHAR2,
p_dm_home               IN VARCHAR2,
p_mailtype              IN VARCHAR2,
p_classid               IN VARCHAR2,
p_plugin_loc            IN VARCHAR2,
p_plugin_ver            IN VARCHAR2,
p_system_guid           IN VARCHAR2,
p_system_name           IN VARCHAR2,
p_system_status         IN VARCHAR2,
p_ldap_host             IN VARCHAR2,
p_ldap_port             IN VARCHAR2,
p_ldap_user             IN VARCHAR2,
p_ldap_opwd             IN VARCHAR2,
p_ldap_npwd             IN VARCHAR2,
p_ldap_rpwd             IN VARCHAR2,
p_ldap_log_base         IN VARCHAR2,
p_ldap_user_base        IN VARCHAR2,
p_text_signon           IN VARCHAR2
) IS

  l_row_count   number := 0;
  l_combo_count number := 0;
  l_dm_node_id  number;
  l_name        varchar2(320);   -- Username to query
  username      varchar2(320);   -- Username to query
  realname      varchar2(360);  -- Display name of username
  admin_role    varchar2(320);   -- Role for admin mode
  admin_mode    varchar2(1);    -- Does user have admin privledges
  s0            varchar2(2000);
  l_url         varchar2(240);
  l_test_date   varchar2(40);
  l_media       varchar2(240) := wfa_html.image_loc;
  l_icon        varchar2(30) := 'FNDILOV.gif';
  l_text        varchar2(30) := '';
  l_onmouseover varchar2(240)  := wf_core.translate ('WFPREF_LOV');
  l_error_msg   varchar2(2000) := NULL;
  l_sguid       raw(16);
  rowid         varchar2(30);

  /* Bug 2127392 */
  l_ldap_error  varchar2(2000) := NULL;
  l_ldap_pwd    varchar2(30);
  l_ldap_opwd   varchar2(30);
BEGIN
  l_ldap_opwd := p_ldap_opwd;

  -- Check session and current user
  wfa_sec.GetSession(username);
  username := upper(username);
  wf_directory.GetRoleInfo(username, realname, s0, s0, s0, s0);

  IF (p_edit_defaults = 'Y') THEN 

     admin_mode := 'N';
     admin_role := wf_core.translate('WF_ADMIN_ROLE');
     if (admin_role = '*' or 
         Wf_Directory.IsPerformer(username, admin_role)) then
         admin_mode := 'Y';
         username := '-WF_DEFAULT-';
     else
         -- cannot edit defaults unless you're the administrator
         l_error_msg := wf_core.translate('WFPREF_INVALID_ADMIN');

     end if;

  END IF;

  -- Validate the language preference
  IF (p_language IS NOT NULL) THEN

     SELECT count(*)
     INTO   l_row_count
     FROM   wf_languages
     WHERE  nls_language = p_language
     AND    installed_flag = 'Y';

  ELSE

    -- If there is no value then set it to null
    l_row_count := 1;

  END IF;

  -- Validate the combination of language/territory preferences are valid
  IF (p_language IS NOT NULL AND l_row_count <> 0 
       AND p_territory IS NOT NULL) THEN

     SELECT count(*)
     INTO   l_combo_count
     FROM   wf_languages
     WHERE  nls_language = p_language
     AND    nls_territory = p_territory
     AND    installed_flag = 'Y';

     IF (l_combo_count = 0) THEN

         l_error_msg := wf_core.translate ('WFPREF_INVALID_COMBO');

     END IF;


  END IF;

  IF (l_row_count > 0) THEN

     IF (l_combo_count > 0) THEN
     
       -- put the language preference
       fnd_preference.put (username, 'WF', 'LANGUAGE', p_language);

     END IF;

  ELSE

     l_error_msg := wf_core.translate ('WFPREF_INVALID_LANGUAGE');

  END IF;

  -- Validate the territory preference
  IF (p_territory IS NOT NULL) THEN

     SELECT count(*)
     INTO   l_row_count
     FROM   wf_languages
     WHERE  nls_territory = p_territory
     AND    installed_flag = 'Y';

  ELSE

    -- If there is no value then set it to null
    l_row_count := 1;

  END IF;
     
  IF (l_row_count > 0) THEN

     IF (l_combo_count > 0) THEN

        -- put the territory preference
        fnd_preference.put (username, 'WF', 'TERRITORY', p_territory);

     END IF;

  ELSE

     l_error_msg := wf_core.translate ('WFPREF_INVALID_TERRITORY');

  END IF;

  -- Validate the date format
  BEGIN

     SELECT TO_CHAR(sysdate, RTRIM(p_date_format))
     INTO   l_test_date
     FROM   dual;

     EXCEPTION
     WHEN OTHERS THEN
          l_error_msg :=  wf_core.translate ('WFPREF_INVALID_DATE_FORMAT') ||
                ': ' || p_date_format;

  END;

  IF (l_error_msg IS NULL) THEN 

     -- put the date format preference
     -- The rtrim is required if the user adds a blank space at the end
     -- of the format and we concatenate on a time format with a space then
     -- the double space will cause an ora-1830 errror.
     fnd_preference.put (username, 'WF', 'DATEFORMAT', RTRIM(p_date_format));

  END IF;

  -- Bug 2589782 Update LDAP info only if Global preference values are 
  -- updated by an Admin

  IF (p_edit_defaults = 'Y' AND admin_mode = 'Y') THEN
     -- put the LDAP preferences
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'HOST',     p_ldap_host);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'PORT',     p_ldap_port);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'USERNAME', p_ldap_user);

     -- Bug 2127392 Validating LDAP password

     l_ldap_pwd  := fnd_preference.eget('#INTERNAL','LDAP_SYNCH', 'EPWD', 'LDAP_PWD');

     IF (l_ldap_opwd is NULL) THEN
        l_ldap_opwd := 'x';
     END IF;
     IF (l_ldap_pwd is NULL) THEN
        l_ldap_pwd := 'x';
     END IF;

     IF (l_ldap_opwd <> 'x' OR length(p_ldap_rpwd) > 0) THEN
        IF (l_ldap_pwd <> l_ldap_opwd) THEN
           l_ldap_error := wf_core.translate ('WFPREF_INVALID_LDAP_PASSWORD');
        END IF;

        -- New password updated only if the Old password is valid
        IF (l_ldap_error IS NULL) THEN
            fnd_preference.eput('#INTERNAL','LDAP_SYNCH', 'EPWD', p_ldap_rpwd,
                                'LDAP_PWD');
        ELSE
            l_error_msg := l_ldap_error;
        END IF;
     END IF;

     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'CHANGELOG_DIR', p_ldap_log_base);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'USER_DIR', p_ldap_user_base);

  END IF;

  -- put the mail preference
  fnd_preference.put (username, 'WF', 'MAILTYPE', p_mailtype);

  -- put the text only mail preference
  fnd_preference.put (username, 'WF', 'WF_SIG_TEXT_ONLY', p_text_signon);

  -- put the dm home node preference
  fnd_document_management.set_dm_home (username, l_dm_node_id);

   IF (admin_mode = 'Y') THEN
  
      -- Check the admin role
      IF (p_display_admin_role <> '*') THEN 
 
         admin_role := p_admin_role;
         -- Get all the username find criteria resolved
         wfa_html.validate_display_name (p_display_admin_role, admin_role);
 
         BEGIN 
    
            wf_directory.GetRoleInfo(UPPER(admin_role), realname, s0, s0, s0, s0);
            if (realname IS NULL) then

               l_name := NULL;

            else
 
               l_name := UPPER(admin_role);
               
            end if;
   
         END;

      ELSE

         l_name := '*';

      END IF;

      IF (l_name IS NOT NULL) THEN

         -- Update the admin role
         UPDATE wf_resources
         SET    text = UPPER(l_name)
         WHERE  type = 'WFTKN'
         AND    name = 'WF_ADMIN_ROLE';

      ELSE

        l_error_msg := wf_core.translate ('WFPREF_INVALID_ROLE_NAME')||
                 ': ' || UPPER(p_display_admin_role);

      END IF;

      -- Update the web agent
      UPDATE wf_resources
      SET    text = p_web_agent
      WHERE  type = 'WFTKN'
      AND    name = 'WF_WEB_AGENT';

      /*
       ** Bug 2307342
       ** It is no longer possible to update jinitiator info
       ** from the Global Preferences page
 
      -- Update the jinitiator info
      UPDATE wf_resources
      SET    text = p_classid
      WHERE  type = 'WFTKN'
      AND    name = 'WF_CLASSID';

      UPDATE wf_resources
      SET    text = p_plugin_loc
      WHERE  type = 'WFTKN'
      AND    name = 'WF_PLUGIN_DOWNLOAD';

      UPDATE wf_resources
      SET    text = p_plugin_ver
      WHERE  type = 'WFTKN'
      AND    name = 'WF_PLUGIN_VERSION';

      */

      -- Update/Insert the Local System Info
      -- validate the system name
      if p_system_guid is not null then
        l_sguid := hextoraw(p_system_guid);
        Wf_Event_Html.Validate_System_Name(p_system_name, l_sguid);

        -- update the local system guid
        begin
          Wf_Resources_Pkg.Update_Row(
          x_type=>'WFTKN',
          x_name=>'WF_SYSTEM_GUID',
          x_protect_level=>0,
          x_custom_level=>0,
          x_id=>0,
          x_text=>rawtohex(l_sguid)
          );
        exception
          when NO_DATA_FOUND then
            Wf_Resources_Pkg.Insert_Row(
            x_rowid=>rowid,
            x_type=>'WFTKN',
            x_name=>'WF_SYSTEM_GUID',
            x_protect_level=>0,
            x_custom_level=>0,
            x_id=>0,
            x_text=>rawtohex(l_sguid)
            );
        end;
      end if;

      -- update the local system status
      begin
          Wf_Resources_Pkg.Update_Row(
          x_type=>'WFTKN',
          x_name=>'WF_SYSTEM_STATUS',
          x_protect_level=>0,
          x_custom_level=>0,
          x_id=>0,
          x_text=>p_system_status
        );
      exception
        when NO_DATA_FOUND then
          Wf_Resources_Pkg.Insert_Row(
            x_rowid=>rowid,
            x_type=>'WFTKN',
            x_name=>'WF_SYSTEM_STATUS',
            x_protect_level=>0,
            x_custom_level=>0,
            x_id=>0,
            x_text=>p_system_status
          );
      end;

   END IF;

   IF (l_error_msg IS NULL) THEN 

      -- use owa_util.redirect_url to redirect the URL to the home page
      owa_util.redirect_url(curl=>wfa_html.base_url || 
                            '/wf_pref.edit?edit_defaults='||p_edit_defaults,
                            bclose_header=>TRUE);

   ELSE

      -- show error message

      -- Set page title
      htp.htmlOpen;
      htp.headOpen;

      wfa_html.create_help_function('wf/notif16.htm');

      if (p_edit_defaults = 'Y') then

         htp.title(wf_core.translate('WFPREF_EDIT_DEF_PREFS_TITLE'));
         wfa_sec.Header(FALSE, '', wf_core.translate('WFPREF_EDIT_DEF_PREFS_TITLE'), TRUE);


      else

         htp.title(wf_core.translate('WFPREF_EDIT_PREFS_TITLE'));
         wfa_sec.Header(FALSE, '', wf_core.translate('WFPREF_EDIT_PREFS_TITLE'), TRUE);

      end if;  


      htp.br;
      htp.br;
      htp.tableopen(calign=>'CENTER', cattributes=>'summary="' ||
                                      WF_CORE.Translate('WFMON_ERROR_MESSAGE')
                                      || '"');

      -- Error message
      htp.tableRowOpen;
      htp.tableData(cvalue=>l_error_msg, calign=>'right', 
                    cattributes=>'id="' || 
                                 WF_CORE.Translate('WFMON_ERROR_MESSAGE') ||
                                 '"');
      htp.tableRowClose;

      htp.tableclose;
 
      htp.br;

      htp.tableopen(calign=>'CENTER', cattributes=>'summary=""');

      --Retry Button

      htp.tableRowOpen;

      l_url         := wfa_html.base_url||'/wf_pref.edit_form'||
                       '?edit_defaults='||p_edit_defaults;
      l_icon        := 'FNDJLFOK.gif';
      l_text        := wf_core.translate ('WFMON_RETRY');
      l_onmouseover := wf_core.translate ('WFMON_RETRY');

      htp.p('<TD id="">');

      wf_pref.create_reg_button (l_url, l_onmouseover, l_media, l_icon, l_text);

      htp.p('</TD>');

      l_url         := wfa_html.base_url||'/wf_pref.edit?edit_defaults='||p_edit_defaults;
      l_icon        := 'FNDJLFCN.gif';
      l_text        := wf_core.translate ('CANCEL');
      l_onmouseover := wf_core.translate ('CANCEL');

      htp.p('<TD id="">');

      wf_pref.create_reg_button (l_url, l_onmouseover, l_media, l_icon, l_text);

      htp.p('</TD>');

      htp.tableRowClose;

      htp.tableclose;
 
   END IF;


exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'update_pref',
                    p_language ,
                    p_territory   ,
                    p_admin_role,
                    p_display_admin_role   );
    wf_pref.Error;

END update_pref;

--update_pref for OA FWK UI. This is Framework specific API that gives
--validation errors using out parameter p_err_msg. Exceptions are
--wrapped in OAF.

PROCEDURE update_pref_fwk (
p_admin_role            IN VARCHAR2,
p_display_admin_role    IN VARCHAR2,
p_web_agent             IN VARCHAR2,
p_edit_defaults         IN VARCHAR2,
p_language              IN VARCHAR2,
p_territory             IN VARCHAR2,
p_date_format           IN VARCHAR2,
p_dm_node_id            IN VARCHAR2,
p_dm_home               IN VARCHAR2,
p_mailtype              IN VARCHAR2,
p_classid               IN VARCHAR2,
p_plugin_loc            IN VARCHAR2,
p_plugin_ver            IN VARCHAR2,
p_system_guid           IN VARCHAR2,
p_system_name           IN VARCHAR2,
p_system_status         IN VARCHAR2,
p_ldap_host             IN VARCHAR2,
p_ldap_port             IN VARCHAR2,
p_ldap_user             IN VARCHAR2,
p_ldap_opwd             IN VARCHAR2,
p_ldap_npwd             IN VARCHAR2,
p_ldap_rpwd             IN VARCHAR2,
p_ldap_log_base         IN VARCHAR2,
p_ldap_user_base        IN VARCHAR2,
p_text_signon           IN VARCHAR2,
p_num_format            IN VARCHAR2,
p_browser_dll_loc       IN VARCHAR2,  
p_err_msg               OUT NOCOPY VARCHAR2
) IS

  l_row_count   number := 0;
  l_combo_count number := 0;
  l_dm_node_id  number;
  l_name        varchar2(320);   -- Username to query
  username      varchar2(320);   -- Username to query
  realname      varchar2(360);  -- Display name of username
  admin_role    varchar2(320);   -- Role for admin mode
  admin_mode    varchar2(1);    -- Does user have admin privledges
  s0            varchar2(2000);
  l_url         varchar2(240);
  l_test_date   varchar2(40);
  l_media       varchar2(240) := wfa_html.image_loc;
  l_icon        varchar2(30) := 'FNDILOV.gif';
  l_text        varchar2(30) := '';
  l_onmouseover varchar2(240)  := wf_core.translate ('WFPREF_LOV');
  l_error_msg   varchar2(2000) := NULL;
  l_sguid       raw(16);
  rowid         varchar2(30);

  /* Bug 2127392 */
  l_ldap_error  varchar2(2000) := NULL;
  l_ldap_pwd    varchar2(30);
  l_ldap_opwd   varchar2(30);
BEGIN
  l_ldap_opwd := p_ldap_opwd;
 
  -- wfa_sec.GetSession(username) cannot be used from Framework, Use GetFWKUserName instead
  username := wfa_sec.GetFWKUserName;
  username := upper(username);
  wf_directory.GetRoleInfo(username, realname, s0, s0, s0, s0);
  IF (p_edit_defaults = 'Y') THEN 
     admin_mode := 'N';
     admin_role := wf_core.translate('WF_ADMIN_ROLE');             
     if (admin_role = '*' or 
         Wf_Directory.IsPerformer(username, admin_role)) then
         admin_mode := 'Y';
         username := '-WF_DEFAULT-'; 
     else
         -- cannot edit defaults unless you're the administrator
         l_error_msg := wf_core.translate('WFPREF_INVALID_ADMIN');

     end if;

  END IF;

  -- Validate the language preference
  IF (p_language IS NOT NULL) THEN

     SELECT count(*)
     INTO   l_row_count
     FROM   wf_languages
     WHERE  nls_language = p_language
     AND    installed_flag = 'Y';

  ELSE

    -- If there is no value then set it to null
    l_row_count := 1;

  END IF;

  -- Validate the combination of language/territory preferences are valid
  IF (p_language IS NOT NULL AND l_row_count <> 0 
       AND p_territory IS NOT NULL) THEN

     SELECT count(*)
     INTO   l_combo_count
     FROM   wf_languages
     WHERE  nls_language = p_language
     AND    nls_territory = p_territory
     AND    installed_flag = 'Y';

     IF (l_combo_count = 0) THEN

         l_error_msg := wf_core.translate ('WFPREF_INVALID_COMBO');

     END IF;


  END IF;

  IF (l_row_count > 0) THEN

     IF (l_combo_count > 0) THEN
     
       -- put the language preference
       fnd_preference.put (username, 'WF', 'LANGUAGE', p_language);

     END IF;

  ELSE

     l_error_msg := wf_core.translate ('WFPREF_INVALID_LANGUAGE');

  END IF;

  -- Validate the territory preference
  IF (p_territory IS NOT NULL) THEN

     SELECT count(*)
     INTO   l_row_count
     FROM   wf_languages
     WHERE  nls_territory = p_territory
     AND    installed_flag = 'Y';

  ELSE

    -- If there is no value then set it to null
    l_row_count := 1;

  END IF;
     
  IF (l_row_count > 0) THEN

     IF (l_combo_count > 0) THEN

        -- put the territory preference
        fnd_preference.put (username, 'WF', 'TERRITORY', p_territory);

     END IF;

  ELSE

     l_error_msg := wf_core.translate ('WFPREF_INVALID_TERRITORY');

  END IF;

  -- Validate the date format
  BEGIN

     SELECT TO_CHAR(sysdate, RTRIM(p_date_format))
     INTO   l_test_date
     FROM   dual;

     EXCEPTION
     WHEN OTHERS THEN
          l_error_msg :=  wf_core.translate ('WFPREF_INVALID_DATE_FORMAT') ||
                ': ' || p_date_format;

  END;

  IF (l_error_msg IS NULL) THEN 

     -- put the date format preference
     -- The rtrim is required if the user adds a blank space at the end
     -- of the format and we concatenate on a time format with a space then
     -- the double space will cause an ora-1830 errror.
     fnd_preference.put (username, 'WF', 'DATEFORMAT', RTRIM(p_date_format));

  END IF;

  -- put the number format preference  - Added new parameter for Global preference OAF page

  IF(p_num_format IS NOT NULL) THEN
       fnd_preference.put (username, 'WF', 'NUMBERFORMAT', p_num_format);
  END IF;

  -- Bug 2589782 Update LDAP info only if Global preference values are 
  -- updated by an Admin

  IF (p_edit_defaults = 'Y' AND admin_mode = 'Y') THEN
     -- put the LDAP preferences
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'HOST',     p_ldap_host);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'PORT',     p_ldap_port);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'USERNAME', p_ldap_user);

     -- Bug 2127392 Validating LDAP password

     l_ldap_pwd  := fnd_preference.eget('#INTERNAL','LDAP_SYNCH', 'EPWD', 'LDAP_PWD');

     IF (l_ldap_opwd is NULL) THEN
        l_ldap_opwd := 'x';
     END IF;
     IF (l_ldap_pwd is NULL) THEN
        l_ldap_pwd := 'x';
     END IF;

     IF (l_ldap_opwd <> 'x' OR length(p_ldap_rpwd) > 0) THEN
        IF (l_ldap_pwd <> l_ldap_opwd) THEN
           l_ldap_error := wf_core.translate ('WFPREF_INVALID_LDAP_PASSWORD');
        END IF;

        -- New password updated only if the Old password is valid
        IF (l_ldap_error IS NULL) THEN
            fnd_preference.eput('#INTERNAL','LDAP_SYNCH', 'EPWD', p_ldap_rpwd,
                                'LDAP_PWD');
        ELSE
            l_error_msg := l_ldap_error;
        END IF;
     END IF;

     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'CHANGELOG_DIR', p_ldap_log_base);
     fnd_preference.put('#INTERNAL', 'LDAP_SYNCH', 'USER_DIR', p_ldap_user_base);

  END IF;

  -- put the mail preference
  fnd_preference.put (username, 'WF', 'MAILTYPE', p_mailtype);
 
  -- put the text only mail preference
  fnd_preference.put (username, 'WF', 'WF_SIG_TEXT_ONLY', p_text_signon);

  -- put the browser signing DLL location preference  - Added new parameter for Global preference OAF page
  --IF (p_browser_dll_loc IS NOT NULL) THEN // not required
   fnd_preference.put (username, 'WF', 'WF_SIG_IE_DLL', p_browser_dll_loc);	
  --END IF;
  
  -- put the dm home node preference
  fnd_document_management.set_dm_home (username, l_dm_node_id);


   IF (admin_mode = 'Y') THEN
  
      -- Check the admin role
      IF (p_display_admin_role <> '*') THEN 
 
         admin_role := p_admin_role;
         -- Get all the username find criteria resolved
         wfa_html.validate_display_name (p_display_admin_role, admin_role);
        
         BEGIN 
    
            wf_directory.GetRoleInfo(UPPER(admin_role), realname, s0, s0, s0, s0);
            if (realname IS NULL) then

               l_name := NULL;

            else
 
               l_name := UPPER(admin_role);
               
            end if;
   
         END;

      ELSE

         l_name := '*';

      END IF;

      IF (l_name IS NOT NULL) THEN

         -- Update the admin role
         UPDATE wf_resources
         SET    text = UPPER(l_name)
         WHERE  type = 'WFTKN'
         AND    name = 'WF_ADMIN_ROLE';

      ELSE        
        l_error_msg := wf_core.translate ('WFPREF_INVALID_ROLE_NAME')||
                 ': ' || UPPER(p_display_admin_role);

      END IF;

      -- Update the web agent
      UPDATE wf_resources
      SET    text = p_web_agent
      WHERE  type = 'WFTKN'
      AND    name = 'WF_WEB_AGENT';

      /*
       ** Bug 2307342
       ** It is no longer possible to update jinitiator info
       ** from the Global Preferences page
 
      -- Update the jinitiator info
      UPDATE wf_resources
      SET    text = p_classid
      WHERE  type = 'WFTKN'
      AND    name = 'WF_CLASSID';

      UPDATE wf_resources
      SET    text = p_plugin_loc
      WHERE  type = 'WFTKN'
      AND    name = 'WF_PLUGIN_DOWNLOAD';

      UPDATE wf_resources
      SET    text = p_plugin_ver
      WHERE  type = 'WFTKN'
      AND    name = 'WF_PLUGIN_VERSION';

      */

      -- Update/Insert the Local System Info
      -- validate the system name
      if p_system_guid is not null then
        l_sguid := hextoraw(p_system_guid);
        Wf_Event_Html.Validate_System_Name(p_system_name, l_sguid);

        -- update the local system guid
        begin
          Wf_Resources_Pkg.Update_Row(
          x_type=>'WFTKN',
          x_name=>'WF_SYSTEM_GUID',
          x_protect_level=>0,
          x_custom_level=>0,
          x_id=>0,
          x_text=>rawtohex(l_sguid)
          );
        exception
          when NO_DATA_FOUND then
            Wf_Resources_Pkg.Insert_Row(
            x_rowid=>rowid,
            x_type=>'WFTKN',
            x_name=>'WF_SYSTEM_GUID',
            x_protect_level=>0,
            x_custom_level=>0,
            x_id=>0,
            x_text=>rawtohex(l_sguid)
            );
        end;
      end if;

      -- update the local system status
      begin
          Wf_Resources_Pkg.Update_Row(
          x_type=>'WFTKN',
          x_name=>'WF_SYSTEM_STATUS',
          x_protect_level=>0,
          x_custom_level=>0,
          x_id=>0,
          x_text=>p_system_status
        );
      exception
        when NO_DATA_FOUND then
          Wf_Resources_Pkg.Insert_Row(
            x_rowid=>rowid,
            x_type=>'WFTKN',
            x_name=>'WF_SYSTEM_STATUS',
            x_protect_level=>0,
            x_custom_level=>0,
            x_id=>0,
            x_text=>p_system_status
          );
      end;

   END IF;

   IF (l_error_msg IS NULL) THEN 

      p_err_msg := NULL;

   ELSE
      -- to be returned back to OAF page
      p_err_msg := l_error_msg; 

   END IF;  
exception
  when others then
    rollback;
    wf_core.context('Wf_Pref', 'update_pref',
                    p_language ,
                    p_territory   ,
                    p_admin_role,
                    p_display_admin_role   );
   --Since Error procedure cannot be called here, raise the exception so that it can be wrapped in Framework
   raise;
END update_pref_fwk;

FUNCTION get_pref
(
p_user_name        IN  VARCHAR2,
p_preference_name  IN  VARCHAR2
)  RETURN VARCHAR2 IS

l_preference_value    VARCHAR2(240) := NULL;

BEGIN

   -- Check if there is a preference for this user
   SELECT MAX(PREFERENCE_VALUE)
   INTO   l_preference_value
   FROM   FND_USER_PREFERENCES
   WHERE  USER_NAME = p_user_name
   AND    PREFERENCE_NAME = p_preference_name
   AND    MODULE_NAME = 'WF';

   -- If there is no preference for this user then try to
   -- get the default
   IF (l_preference_value IS NULL) THEN

      SELECT MAX(PREFERENCE_VALUE)
      INTO   l_preference_value
      FROM   FND_USER_PREFERENCES
      WHERE  USER_NAME = '-WF_DEFAULT-'
      AND    PREFERENCE_NAME = p_preference_name
      AND    MODULE_NAME = 'WF';

   END IF;

   /* 
   ** The following hard code is for the mailer.  The wf_roles view
   ** defaults the language to the session value if it doesn't find a
   ** preference.  If the global is not set and one user is set and another
   ** one isn't then it could cause the next user to receive a message in
   ** a random laguage.  At least if it's in american we can detect the bug
   ** and set it to 32.  Yes it's a narrow case but it may prevent a bug
   */
  
   if (l_preference_value IS NULL AND p_preference_name = 'LANGUAGE') THEN

      l_preference_value := 'AMERICAN';

   elsif (l_preference_value IS NULL AND p_preference_name = 'TERRITORY') THEN

      l_preference_value := 'AMERICA';

   end if;

   return l_preference_value;

END get_pref;
   
end WF_PREF;
/
commit;
exit;
