REM $Header: wfquec2.sql 26.4 2004/12/08 04:09:35 kma ship $
REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=tbm+1 \
REM dbdrv: checkfile:~PROD:~PATH:~FILE \
REM dbdrv: &un_apps &un_fnd &pw_fnd
REM ***********************************************************************
REM   NAME
REM       wfquec2.sql - 
REM   DESCRIPTION
REM       Creates all Advanced Queues with payload structures.
REM       NOTE: storage clause removed so as to use defaults.
REM	  NOTE: sort list changed to priority, enq_time
REM   USAGE
REM       sqlplus <APPSusr>/<APPSpwd> @wfquec2.sql <APPSusr> <FNDusr> <FNDpwd>
REM       sqlplus <WFusr>/<WFpwd> @wfquec2.sql <WFusr> <WFusr> <WFpwd>
REM   MODIFICATION LOG:
REM       JWSMITH BUG 2308366 - This file is a new file and is a copy
REM               of wfquec.sql.  wfquec.sql was changed to be a stub file.
REM               This corrected the problem of paramter additions causing
REM               problems with adpatch.
REM ********************************************************************/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;


REM Queues require storage and consequently must be run in the base account
REM (autopatch will run all scripts in apps account)
connect &2/&3;

REM Continue in case of error where constraints aready exist
REM WHENEVER SQLERROR CONTINUE;

REM============================================================
REM
REM Create New Queue Table
REM
REM============================================================

declare
  queue_table_exists exception;
  pragma EXCEPTION_INIT(queue_table_exists, -24001);
begin

--  dbms_output.put_line('===================================');
--  dbms_output.put_line('Creating all Workflow Queue Tables ');
--  dbms_output.put_line('===================================');
 
  begin 
   dbms_aqadm.create_queue_table
     (
	queue_table          => 'WF_DEFERRED_TABLE_M',
	queue_payload_type   => '&2..WF_PAYLOAD_T',
	sort_list	     => 'PRIORITY,ENQ_TIME',
        multiple_consumers   => TRUE,
	comment	             => 'Workflow Deferred Queue',
        compatible           => '8.1'
     );

  exception
    when queue_table_exists then 
      null;
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr1= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
  end;
  begin
   dbms_aqadm.create_queue_table
     (
	queue_table          => 'WF_INBOUND_TABLE',
	queue_payload_type   => '&2..WF_PAYLOAD_T',
	sort_list	     => 'PRIORITY,ENQ_TIME',
	comment	             => 'Workflow Inbound Queue',
        compatible           => '8.1'
     );

  exception
    when queue_table_exists then 
      null;
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr2= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
 end;
 begin
   dbms_aqadm.create_queue_table
     (
	queue_table          => 'WF_OUTBOUND_TABLE',
	queue_payload_type   => '&2..WF_PAYLOAD_T',
	sort_list	     => 'PRIORITY,ENQ_TIME',
	comment	             => 'Workflow Outbound Queue ',
        compatible           => '8.1'
     );

  exception
    when queue_table_exists then 
      null;
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr3= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
  end;
end;
/

REM====================================================================
REM
REM Create New Queue
REM
REM====================================================================

declare
  queue_exists exception;
  pragma EXCEPTION_INIT(queue_exists, -24006);
BEGIN

--  dbms_output.put_line('=================================');
--  dbms_output.put_line('Creating all Workflow Queues');
--  dbms_output.put_line('=================================');

 begin
  dbms_aqadm.create_queue
	(
	  queue_name		=> 'WF_DEFERRED_QUEUE_M',
	  queue_table		=> 'WF_DEFERRED_TABLE_M',
	  comment		=> 'Workflow Deferred Queue'
	);

  exception
    when queue_exists then 
      null;
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr4= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
 end;
 begin 
  dbms_aqadm.create_queue
	(
	  queue_name		=> 'WF_INBOUND_QUEUE',
	  queue_table		=> 'WF_INBOUND_TABLE',
	  comment		=> 'Workflow Inbound Queue'
	);

  exception
    when queue_exists then 
      null;
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr5= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
 end;
 begin 
  dbms_aqadm.create_queue
	(
	  queue_name		=> 'WF_OUTBOUND_QUEUE',
	  queue_table		=> 'WF_OUTBOUND_TABLE',
	  comment		=> 'Workflow Outbound Queue'
	);

  exception
    when queue_exists then 
      null;
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr6= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
 end;
END;
/

REM===================================================================
REM
REM Start Queue
REM
REM===================================================================

declare
begin

--  dbms_output.put_line('============================');
--  dbms_output.put_line('Starting all Workflow Queues ');
--  dbms_output.put_line('============================');

  dbms_aqadm.start_queue(queue_name => 'WF_DEFERRED_QUEUE_M');

  exception
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr7= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
end;
/
begin
  dbms_aqadm.start_queue(queue_name => 'WF_INBOUND_QUEUE');

  exception
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr8= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
end;
/
begin 
  dbms_aqadm.start_queue(queue_name => 'WF_OUTBOUND_QUEUE');

  exception
    when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Oracle Server Message = '||sqlerrm);
        raise_application_error(-20000, 'Oracle Error Mkr9= '
                                ||to_char(sqlcode)||' - '||sqlerrm);
end;
/


REM===================================================================
REM
REM Add Subscriber
REM
REM===================================================================
declare
   subscriber_exist exception;
   pragma EXCEPTION_INIT(subscriber_exist, -24034);

   l_agent sys.aq$_agent;

begin
   l_agent := sys.aq$_agent('&1','',0);
   begin
     dbms_aqadm.add_subscriber(queue_name=>'WF_DEFERRED_QUEUE_M',
                               subscriber=>l_agent,
                               rule=>'CORRID like '''||'&1'||'%''');
   exception
     when subscriber_exist then
       null;  -- ignore if we already added this subscriber.
   end;
end;
/
commit;
exit;

