REM dbdrv: none 
REM $Header: wfqued.sql 26.2 2001/09/11 02:11:22 dlam ship $
REM ***********************************************************************
REM   NAME
REM       wfqued.sql - 
REM   DESCRIPTION
REM       Drop all Workflow Advanced Queues 
REM   USAGE
REM       Workflow Advanced Queues are created in SYSTEM account so 
REM       they must be dropped from there
REM       sqlplus un/pw @wfqued SYSTEM system_PW 
REM ********************************************************************
REM connect to SYSTEM account
connect &1/&2;

REM Continue in case of errors 
WHENEVER SQLERROR CONTINUE;

set serveroutput on 

REM====================================================================
REM
REM Stop Queues
REM
REM====================================================================

declare
  no_queue exception;
  pragma EXCEPTION_INIT(no_queue, -24010);
begin
  begin
--   dbms_output.put_line('==============================');
--   dbms_output.put_line('Stopping all Workflow Queues');
--   dbms_output.put_line('==============================');

   dbms_aqadm.stop_queue
	 ( queue_name => 'WF_DEFERRED_QUEUE_M', wait => FALSE);
   exception
     when no_queue then null;
     when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Stop Deferred Queue '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Stop Deferred Queue = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
  end;

  begin
   dbms_aqadm.stop_queue
	 ( queue_name => 'WF_OUTBOUND_QUEUE', wait => FALSE);
   exception
     when no_queue then null;
     when others then 
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Stop Outbound Queue '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Stop Outbound Queue = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
  end;

  begin
   dbms_aqadm.stop_queue
	 ( queue_name => 'WF_INBOUND_QUEUE', wait => FALSE);
   exception
     when no_queue then null;
     when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Stop Inbound Queue '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Stop Inbound Queue = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
  end;
end;
/

REM====================================================================
REM
REM Drop Queues
REM
REM====================================================================

declare
  no_queue exception;
  pragma EXCEPTION_INIT(no_queue, -24010);
begin
 begin
--    dbms_output.put_line('=========================');
--    dbms_output.put_line('Drop all Workflow Queues');
--    dbms_output.put_line('=========================');

    dbms_aqadm.drop_queue(  queue_name => 'WF_DEFERRED_QUEUE_M');
    exception
      when no_queue then null;
      when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Drop Deferred Queue '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Drop Deferred Queue = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
 end;
 begin
    dbms_aqadm.drop_queue(  queue_name => 'WF_OUTBOUND_QUEUE');
    exception
      when no_queue then null;
      when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Drop Outbound Queue '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Drop Outbound Queue = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
 end;
 begin
    dbms_aqadm.drop_queue(  queue_name => 'WF_INBOUND_QUEUE');
    exception
      when no_queue then null;
      when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Drop Inbound Queue '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Drop Inbound Queue = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
 end;
end;
/
REM============================================================
REM
REM Drop Queue Tables
REM
REM============================================================

declare
  no_queue_table exception;
  pragma EXCEPTION_INIT(no_queue_table, -24002);
begin
  begin

--    dbms_output.put_line('===============================');
--    dbms_output.put_line('Drop all Workflow Queue tables ');
--    dbms_output.put_line('===============================');
    dbms_aqadm.drop_queue_table( queue_table => 'WF_DEFERRED_TABLE_M', force => TRUE);
    exception
      when no_queue_table then null;
      when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Drop Deferred Queue Table '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Drop Deferred Queue Table = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
  end;
  begin
    dbms_aqadm.drop_queue_table( queue_table => 'WF_OUTBOUND_TABLE', force => TRUE);
    exception
      when no_queue_table then null;
      when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Drop Outbound Queue Table '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Drop Outbound Queue Table = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
  end;
  begin
    dbms_aqadm.drop_queue_table( queue_table => 'WF_INBOUND_TABLE', force => TRUE);
    exception
      when no_queue_table then null;
      when others then
--        dbms_output.put_line('Oracle Server Error = '||to_char(sqlcode));
--        dbms_output.put_line('Drop Inbound Queue Table '||substr(SQLERRM,1,256));
        raise_application_error(-20000, 'Oracle Server Error '
                            ||'at Drop Inbound Queue Table = '
                            ||to_char(sqlcode)||' - '||substr(sqlerrm,1,256));
  end;
end;
/

commit;
exit;
