REM dbdrv: none
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 |   wfquhndos.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_EVENT_OMB_QH (Single Consumer)
 *=======================================================================*/
whenever sqlerror exit failure rollback;
/*
**  FUNCTION  SetOMBAQProp
**  FUNCTION  Serialize
**  FUNCTION  Unserialize
**  PROCEDURE Dequeue
**  PROCEDURE Enqueue
**  FUNCTION  xgetValueForParameter
**  FUNCTION  xgetNameForParameter
*/
create or replace package WF_EVENT_OMB_QH as
/* $Header: wfquhndos.pls 26.7 2001/09/14 19:07:53 dlam ship $ */
-------------------------------------------------------------------------
FUNCTION  SetOMBAQProp(id     in varchar2,
                       str    in varchar2)
                    return aq.ombaq_property; 
-------------------------------------------------------------------------
FUNCTION  Serialize(p_event          in  wf_event_t)
                    return aq.ombaq_properties;
-------------------------------------------------------------------------
FUNCTION  Unserialize(inProp in  aq.ombaq_properties)
                      return wf_event_t;
-------------------------------------------------------------------------
PROCEDURE Dequeue(p_agent_guid in  raw,
                  p_event      out wf_event_t);
-------------------------------------------------------------------------
PROCEDURE Enqueue(p_event              in wf_event_t,
                  p_out_agent_override in wf_agent_t default null);
-------------------------------------------------------------------------
FUNCTION  xgetValueForParameter(inProp in  aq.ombaq_properties,
                                pName in varchar2)
                      return varchar2;
-------------------------------------------------------------------------
FUNCTION  xgetNameForParameter(inProp in  aq.ombaq_properties,
                                pName in varchar2)
                      return varchar2;
-------------------------------------------------------------------------
end WF_EVENT_OMB_QH;
/
-- show error;
commit;
exit;
