REM dbdrv: none
REM $Header: wfsed.sql 26.0 2005/03/22 06:19:01 hgandiko noship $
rem **************************************************************
rem NAME:
rem      wfsed.sql
rem DESCRIPTION:
rem This script is run by the installer as the last step of the 
rem workflow seed data install.
rem 
rem USAGE:
rem sqlplus username/pwd @wfsed.sql 
rem **************************************************************

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

/* INSERT ROW IN WF_DIRECTORY_PARTITIONS */
REM/*
REM ** Bug 3938785
REM ** WF_DIRECTORY_PARTITIONS
REM */

Begin
 insert into WF_DIRECTORY_PARTITIONS (
      PARTITION_ID,
      ORIG_SYSTEM
    ) values (
      0,
      'WF_LOCAL_ROLES');
exception
when dup_val_on_index then
        null;
end;
/

insert into WF_DIRECTORY_PARTITIONS_TL (
    ORIG_SYSTEM,
    DISPLAY_NAME,
    LANGUAGE,
    SOURCE_LANG
  ) select
    'WF_LOCAL_ROLES',
    'Ad Hoc Roles',
    L.CODE,
    userenv('LANG')
  from WF_LANGUAGES L
  where L.INSTALLED_FLAG = 'Y'
  and not exists
    (select NULL
    from WF_DIRECTORY_PARTITIONS_TL T
    where T.ORIG_SYSTEM =  'WF_LOCAL_ROLES'
    and T.LANGUAGE = L.CODE)
/


/* INSERT ROW IN WF_DIRECTORY_PARTITIONS */
REM/*
REM ** Bug 4029035
REM ** WF_DIRECTORY_PARTITIONS
REM */

Begin
 insert into WF_DIRECTORY_PARTITIONS (
      PARTITION_ID,
      ORIG_SYSTEM
    ) values (
      0,
      'WF_LOCAL_USERS');
exception
when dup_val_on_index then
      null;
end;
/

insert into WF_DIRECTORY_PARTITIONS_TL (
    ORIG_SYSTEM,
    DISPLAY_NAME,
    LANGUAGE,
    SOURCE_LANG
  ) select
    'WF_LOCAL_USERS',
    'Adhoc Users',
    L.CODE,
    userenv('LANG')
  from WF_LANGUAGES L
  where L.INSTALLED_FLAG = 'Y'
  and not exists
    (select NULL
    from WF_DIRECTORY_PARTITIONS_TL T
    where T.ORIG_SYSTEM =  'WF_LOCAL_USERS'
    and T.LANGUAGE = L.CODE)
/

/* INSERT ROW IN WF_DIRECTORY_PARTITIONS */
REM/*
REM ** Bug 4029035
REM ** WF_DIRECTORY_PARTITIONS
REM */

Begin
 insert into WF_DIRECTORY_PARTITIONS (
      PARTITION_ID,
      ORIG_SYSTEM
    ) values (
      0,
      'ORACLE');
exception
when dup_val_on_index then
     null;
end;
/

insert into WF_DIRECTORY_PARTITIONS_TL (
    ORIG_SYSTEM,
    DISPLAY_NAME,
    LANGUAGE,
    SOURCE_LANG
  ) select
    'ORACLE',
    'DBA Users/Roles',
    L.CODE,
    userenv('LANG')
  from WF_LANGUAGES L
  where L.INSTALLED_FLAG = 'Y'
  and not exists
    (select NULL
    from WF_DIRECTORY_PARTITIONS_TL T
    where T.ORIG_SYSTEM =  'ORACLE'
    and T.LANGUAGE = L.CODE)
/

commit;
exit;
