REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=dat \
REM dbdrv: checkfile:~PROD:~PATH:~FILE\
REM dbdrv: &un_fnd &pw_fnd EMBEDDED
REM $Header: wfsedupg.sql 26.6 2004/10/18 06:47:06 hgandiko ship $
rem **************************************************************
rem NAME:
rem      wfsedupg.sql
rem DESCRIPTION:
rem This script is run by the installer as the last step of the 
rem workflow seed data install. Its purpose is to seed and record in 
rem WF_RESOURCE the account name of the workflow schema and the 
rem the style of workflow install 
rem NOTE: 
rem      ** THESE TOKENS MUST NOT BE TRANSLATED
rem      ** Should be run at end of install, but can be rerun if needed
rem USAGE:
rem sqlplus APPS/pw @wfsedupg.sql APPLSYS APPLSYSPW [STANDALONE|EMBEDDED]
rem **************************************************************

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

rem Connect as apps itself

declare
  l_error  number := 0;
begin 

  WF_CORE.UPLOAD_MODE   := 'FORCE';
  WF_CORE.SESSION_LEVEL := 0;

  if wf_core.translate('WF_SCHEMA') = '[WF_SCHEMA]' then
    wf_core.session_level := 0;
    wf_load.upload_resource(
                                x_type          => 'WFTKN',
                                x_name          => 'WF_SCHEMA',
                                x_protect_level => 0,
                                x_custom_level  => 0,
                                x_id            => 0,
                                x_text          => '&1',
                                x_level_error   => l_error);

    -- Raise Error if any error level not returned equal to zero
    if l_error <> 0 then
      raise_application_error(-20000, 'Error : Uploading WF_SCHEMA  -:Oracle Error = '||to_char(sqlcode)||' -'||sqlerrm);
    end if;
  end if;
 
  --Upload WF_INSTALL TOKEN
  if wf_core.translate('WF_INSTALL') = '[WF_INSTALL]' then
    wf_load.upload_resource(
                                x_type           => 'WFTKN',
                                x_name           => 'WF_INSTALL',
                                x_protect_level  => 0,
                                x_custom_level   => 0,
                                x_id             => 0,
                                x_text           => UPPER('&3'),
                                x_level_error    => l_error);

    -- Raise Error if any error level not returned equal to zero
    if l_error <> 0 then
     raise_application_error(-20000, 'Error :Uploading WF_INSTALL -:Oracle Error = '||to_char(sqlcode)||' -'||sqlerrm);

    end if;
  end if;
exception
  when others then
    raise;
end;
/

CONNECT &1/&2

rem Extra update here to prevent incorrect values
rem introduces by pseudo translation or by incorrect 
rem translation.

update wf_resources 
set text   = user 
where name = 'WF_SCHEMA' 
and type   = 'WFTKN'; 

update wf_resources 
set text   = upper('&&3') 
where name = 'WF_INSTALL' 
and type   = 'WFTKN';

  
commit;
exit;


