/*=======================================================================+
 |  Copyright (c) 2001 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME                                                              |
 |   wfssos.pls                                                          |
 | DESCRIPTION                                                           |
 |   WorkFlow Single Sign-On interface                                   |
 |   PL/SQL spec for package: WF_SSO                                     |
 |                                                                       |
 |   FUNCTION user_change                                                |
 |   FUNCTION user_create_rf                                             |
 |                                                                       |
 *=======================================================================*/

whenever sqlerror exit failure rollback;
create or replace package WF_SSO as
/* $Header: wfssos.pls 26.1 2002/10/15 00:13:13 kma ship $ */

-----------------------------------------------------------------------------

/* 
 * FUNCTION: USER_CHANGE
 * DESCRIPTION: The rule function for WF's subscription on the
 *   oracle.apps.wf.public.user.change event.  This function retrieves 
 *   the user's information and updates the workflow user table as needed.
 *   (Model after FND_USER_PKG.USER_CHANGE)
 */
FUNCTION USER_CHANGE (
  p_subscription_guid in     raw,
  p_event             in out wf_event_t
) return varchar2;

-----------------------------------------------------------------------------

/*
 * FUNCTION: USER_CREATE_RF
 * DESCRIPTION: The rule function for WF's 2nd subscription on the
 *   oracle.apps.wf.public.user.change event.  This function
 *   retrieves the user's information and creates the
 *   corresponding workflow if the user does not already exist.
 *   (Model after FND_USER_PKG.USER_CREATE_RF)
 */
FUNCTION USER_CREATE_RF(
  p_subscription_guid in            raw,
  p_event             in out nocopy wf_event_t
) return varchar2;

-----------------------------------------------------------------------------

end WF_SSO;
/
-- show errors package WF_SSO;
commit;
exit;
