REM $Header: wfsvcdat.sql 26.28 2005/03/03 10:18:29 smayze ship $
REM +======================================================================+
REM | Copyright (c) 2002 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wfsvcdat.sql - Service Components Seed Data
REM   DESCRIPTION
REM       Load seed data for Service Components
REM   USAGE
REM       sqlplus apps/apps @wfsvcdat.sql
REM   NOTES
REM       This script populates columns in:
REM         FND_SVC_COMP_TYPES_B
REM         FND_SVC_COMP_TYPES_TL
REM         FND_SVC_COMP_PARAMS_B
REM         FND_SVC_COMP_PARAMS_TL
REM         FND_SVC_COMPONENTS
REM         FND_SVC_COMP_PARAM_VALS
REM
--
REM   dbdrv: none
--
SET VERIFY OFF
WHENEVER OSERROR EXIT FAILURE ROLLBACK 
WHENEVER SQLERROR EXIT FAILURE ROLLBACK


DECLARE
BEGIN

    WF_EVENTS_PKG.LOADERSETMODE
    (
        X_MODE => 'UPGRADE'
    );

--
-- ****************************************************************************
-- Component Types
-- ****************************************************************************
--
FND_SVC_COMP_TYPES_PKG.LOAD_ROW
(
    X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
  , X_COMPONENT_CLASS_NAME => 'oracle.apps.fnd.wf.bes.AgentListener'
  , X_CONFIG_UI_REGION => 'NONE'
  , X_CUSTOMIZATION_LEVEL => 'C'
  , X_DISPLAY_NAME => 'Workflow Agent Listener'
  , X_DESCRIPTION => 'Component Type used to create a Workflow Agent Listener Service Component'
  , X_OBJECT_VERSION_NUMBER => -1
  , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_TYPES_PKG.LOAD_ROW
(
    X_COMPONENT_TYPE => 'WF_MAILER'
  , X_COMPONENT_CLASS_NAME => 'oracle.apps.fnd.wf.mailer.Mailer'
  , X_CONFIG_UI_REGION => 'NONE'
  , X_CUSTOMIZATION_LEVEL => 'C'
  , X_DISPLAY_NAME => 'Workflow Mailer'
  , X_DESCRIPTION => 'Component Type used to create a Workflow Mailer Service Component'
  , X_OBJECT_VERSION_NUMBER => -1
  , X_OWNER => 'ORACLE'
);


-- ****************************************************************************
-- Component Type Definitions
-- (Java Agent Listener)
-- ****************************************************************************
--
FND_SVC_COMP_TYPES_PKG.LOAD_ROW
(
    X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
  , X_COMPONENT_CLASS_NAME => 'oracle.apps.fnd.wf.bes.AgentListenerNew'
  , X_CONFIG_UI_REGION => 'NONE'
  , X_CUSTOMIZATION_LEVEL => 'C'
  , X_DISPLAY_NAME => 'Workflow Java Agent Listener'
  , X_DESCRIPTION => 'Component Type used to create a Workflow Java Agent Listener Service Component'
  , X_OBJECT_VERSION_NUMBER => -1
  , X_OWNER => 'ORACLE'
);


--
-- ****************************************************************************
-- Component Type Parameter Definitions
-- (for WF_AGENT_LISTENER)
-- ****************************************************************************
--
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'COMPONENT_LOG_LEVEL'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '5'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Log Level'
    , X_DESCRIPTION => 'Log level'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_MAX_ERROR_COUNT'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '10'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Max Error Count'
    , X_DESCRIPTION => 'Maximum number of times processing fails before the Service Component stops with error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_IN_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '1'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inbound Thread Count'
    , X_DESCRIPTION => 'Number of inbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_OUT_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '0'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Thread Count'
    , X_DESCRIPTION => 'Number of outbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '120'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Min Loop Sleep'
    , X_DESCRIPTION => 'Minimum amount of time in seconds the processing thread(s) will sleep when nothing has been read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_MAX_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '0'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Max Loop Sleep'
    , X_DESCRIPTION => 'Maximum amount of time in seconds the processing thread(s) will sleep when nothing has been read.  If this is set to 0, the back-off algorithm will not occur and Processor Min Loop Sleep will always be used'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '0'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Read Wait Timeout'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will wait while deqeueing'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_ERROR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '60'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Error Loop Sleep'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will sleep after there has been an error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT_CLOSE'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Close on Read Timeout'
    , X_DESCRIPTION => 'Whether or not to close if nothing was read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'LISTENER_PROCESS_EVT_COUNT'             
    , X_COMPONENT_TYPE => 'WF_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '500'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Maximum Process Event Count'
    , X_DESCRIPTION => 'Maximum number of events to be processed in one iteration'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

--
-- ****************************************************************************
-- Component Type Parameter Definitions
-- (for WF_MAILER)
-- ****************************************************************************
--

--
-- Required GSC Parameters
--
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'COMPONENT_LOG_LEVEL'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '5'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Log Level'
    , X_DESCRIPTION => 'Log level'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_MAX_ERROR_COUNT'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '10'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Max Error Count'
    , X_DESCRIPTION => 'Maximum number of times processing fails before the Service Component stops with error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_IN_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '1'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inbound Thread Count'
    , X_DESCRIPTION => 'Number of inbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_OUT_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '1'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Thread Count'
    , X_DESCRIPTION => 'Number of outbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '5'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Min Loop Sleep'
    , X_DESCRIPTION => 'Minimum amount of time in seconds the processing thread(s) will sleep when nothing has been read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_MAX_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '60'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Max Loop Sleep'
    , X_DESCRIPTION => 'Maximum amount of time in seconds the processing thread(s) will sleep when nothing has been read.  If this is set to 0, the back-off algorithm will not occur and Processor Min Loop Sleep will always be used'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '10'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Read Wait Timeout'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will wait while dequeueing'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_ERROR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '60'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Error Loop Sleep'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will sleep after there has been an error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT_CLOSE'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Close on Read Timeout'
    , X_DESCRIPTION => 'Whether or not to close if nothing was read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_DEFER_EVTDATA_READ'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor defer reading event data'
    , X_DESCRIPTION => 'Whether or not the event data should be access directly or through a stream'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

--
-- WF_MAILER-specific Parameters
--
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INBOX'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'INBOX'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inbox Folder'
    , X_DESCRIPTION => 'Folder name for the incoming response emails'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESS'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'PROCESS'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processed Folder'
    , X_DESCRIPTION => 'Folder name for the successfully processed responses'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'DISCARD'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'DISCARD'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Discard Folder'
    , X_DESCRIPTION => 'Folder name for the responses that failed to be processed'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);


FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'EMAIL_PARSER'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'oracle.apps.fnd.wf.mailer.TemplatedEmailParser'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Email Parser'
    , X_DESCRIPTION => 'Name of the class to be used to parse the incoming email'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'EXPUNGE_ON_CLOSE'             
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Expunge Inbox on Close'
    , X_DESCRIPTION => 'Purge deleted emails from inbox on close. This does not affect the Processed or Discard folders'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'RESET_NLS'          
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'N'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Reset NLS'
    , X_DESCRIPTION => 'Sets the language information for each notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'MAX_INVALID_ADDR_LIST_SIZE'         
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '100'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Invalid address list size'
    , X_DESCRIPTION => 'The maximum size of the list for holding invalid email addresses'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'MESSAGE_FORMATTER'         
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'oracle.apps.fnd.wf.mailer.NotificationFormatter'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Message Formatter'
    , X_DESCRIPTION => 'Name of the class to be used to format the oubound notifications'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'TEST_ADDRESS'        
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'NONE'
    , X_REQUIRED_FLAG => 'N'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Test Address'
    , X_DESCRIPTION => 'The address where all notifications will be sent for development testing purposes'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'FROM'        
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Workflow Mailer'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'From'
    , X_DESCRIPTION => 'The From name for the outbound notifications'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'AUTOCLOSE_FYI'     
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Autoclose FYI'
    , X_DESCRIPTION => 'Automatically closes notifications when successfully sent'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'NODENAME'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Mailer Node Name'
    , X_DESCRIPTION => 'The name for the mailer instance'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'ACCOUNT'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => NULL
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Username'
    , X_DESCRIPTION => 'Mail account user name'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INBOUND_CONNECTION_TIMEOUT'     
    , X_COMPONENT_TYPE => 'WF_MAILER' 
    , X_DEFAULT_PARAMETER_VALUE => '120' 
    , X_REQUIRED_FLAG => 'Y' 
    , X_ALLOW_RELOAD_FLAG => 'N' 
    , X_ENCRYPTED_FLAG => 'N' 
    , X_CUSTOMIZATION_LEVEL => 'C' 
    , X_DISPLAY_NAME => 'Inbound connection time out' 
    , X_DESCRIPTION => 'The maximum time, in seconds, that the mailer will wait to establish a connection to the inbound server' 
    , X_OBJECT_VERSION_NUMBER => -1 
    , X_OWNER => 'ORACLE' 
); 

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INBOUND_FETCH_SIZE'     
    , X_COMPONENT_TYPE => 'WF_MAILER' 
    , X_DEFAULT_PARAMETER_VALUE => '100' 
    , X_REQUIRED_FLAG => 'Y' 
    , X_ALLOW_RELOAD_FLAG => 'N' 
    , X_ENCRYPTED_FLAG => 'N' 
    , X_CUSTOMIZATION_LEVEL => 'C' 
    , X_DISPLAY_NAME => 'Inbound message fetch size' 
    , X_DESCRIPTION => 'Maximum number of messages to fetch from the inbox at any one time' 
    , X_OBJECT_VERSION_NUMBER => -1 
    , X_OWNER => 'ORACLE' 
); 
    
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW  
( 
    X_PARAMETER_NAME => 'INBOUND_MAX_IGNORE_SIZE'     
    , X_COMPONENT_TYPE => 'WF_MAILER' 
    , X_DEFAULT_PARAMETER_VALUE => '1000' 
    , X_REQUIRED_FLAG => 'Y' 
    , X_ALLOW_RELOAD_FLAG => 'Y' 
    , X_ENCRYPTED_FLAG => 'N' 
    , X_CUSTOMIZATION_LEVEL => 'C' 
    , X_DISPLAY_NAME => 'Maximum Ignore List size' 
    , X_DESCRIPTION => 'Maximum size that the ignore list can attain' 
    , X_OBJECT_VERSION_NUMBER => -1 
    , X_OWNER => 'ORACLE' 
); 
    
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW  
( 
    X_PARAMETER_NAME => 'INBOUND_MAX_LOOKUP_CACHE_SIZE'     
    , X_COMPONENT_TYPE => 'WF_MAILER' 
    , X_DEFAULT_PARAMETER_VALUE => '100' 
    , X_REQUIRED_FLAG => 'Y' 
    , X_ALLOW_RELOAD_FLAG => 'Y' 
    , X_ENCRYPTED_FLAG => 'N' 
    , X_CUSTOMIZATION_LEVEL => 'C' 
    , X_DISPLAY_NAME => 'Maximum Response lookup code cache size' 
    , X_DESCRIPTION => 'Maximum size that the cache for the response lookup codes can attain' 
    , X_OBJECT_VERSION_NUMBER => -1 
    , X_OWNER => 'ORACLE' 
); 
    
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW  
( 
    X_PARAMETER_NAME => 'INBOUND_SERVER'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => NULL
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inbound Server Name'
    , X_DESCRIPTION => 'Name of the inbound mail server'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OUTBOUND_CONNECTION_TIMEOUT'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '120'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound connection time out'
    , X_DESCRIPTION => 'The maximum time, in seconds, that the mailer will wait when esablishing a connection to the oubound server'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OUTBOUND_SERVER'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => NULL
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Server Name'
    , X_DESCRIPTION => 'Name of the outbound mail server'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INBOUND_MAX_RET_EMAIL_SIZE'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '100'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Maximum returned email list size'
    , X_DESCRIPTION => 'Maximum size that the registry of returned emails can attain'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INBOUND_UNSOLICITED_THRESHOLD'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '2'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Unsolicited event threshold'
    , X_DESCRIPTION => 'The number of unsolicited emails from a particular sender that will result in the raising of a business event'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INBOUND_PASSWORD'    
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => NULL
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'Y'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Password'
    , X_DESCRIPTION => 'Password for accessing the inbound mail server'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'DEBUG_MAIL_SESSION'  
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'N'
    , X_REQUIRED_FLAG => 'N'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Debug Mail Session'
    , X_DESCRIPTION => 'Enable the debug on the java mail API'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'DIRECT_RESPONSE'  
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'N'
    , X_REQUIRED_FLAG => 'N'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Direct response'
    , X_DESCRIPTION => 'Enable the Direct Response template for text notifications'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'REPLYTO' 
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => NULL
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Reply-to Address'
    , X_DESCRIPTION => 'The reply to address for the outbound notifications'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'ALLOW_FORWARDED_RESPONSE' 
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'N'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Allow Forwarded Response'
    , X_DESCRIPTION => 'Allow notifications to be forwarded for response'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'ALTERNATE_EMAIL_PARSER' 
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'oracle.apps.fnd.wf.mailer.DirectEmailParser'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Alternate email parser'
    , X_DESCRIPTION => 'Name of the alternate class to be used to parse the incoming email'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'ATTACH_IMAGES' 
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Attach images to outbound emails'
    , X_DESCRIPTION => 'The flag to indicate whether or not image data should be attached to the outbound email'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'ATTACH_STYLESHEET' 
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Attach stylesheet to outbound email'
    , X_DESCRIPTION => 'The flag to indicate whether or not the stylesheet, if used, should be attattched to the outbound email'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'ATTACHED_URLS' 
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:ATTACHED_URLS'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Attached URLs'
    , X_DESCRIPTION => 'The name of the message template to contain the list of attached URL references'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'CANCELED'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:CANCELED'
    , X_REQUIRED_FLAG => 'N'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Cancelled Notification'
    , X_DESCRIPTION => 'The name of the message template to define a canceled notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'CLOSED'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:CLOSED'
    , X_REQUIRED_FLAG => 'N'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Closed Notification'
    , X_DESCRIPTION => 'The name of the message template to define a closed notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'HTMLAGENT'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => NULL
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'HTML Agent'
    , X_DESCRIPTION => 'The base URL to be used for URL message attributes'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'HTTP_USER_AGENT'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Mozilla/4.76'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'HTTP User Agent'
    , X_DESCRIPTION => 'The value of the User-Agent HTTP header that the mailer will use when requesting notifications with framework regions.'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OPEN_INVALID'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:OPEN_INVALID'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Invalid Response Notification'
    , X_DESCRIPTION => 'The message template that defines an invalid response to a notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OPEN_INVALID_MORE_INFO'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:OPEN_INVALID_MORE_INFO'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Invalid More Information Response Notification'
    , X_DESCRIPTION => 'The message template that defines an invalid response to a request for more information'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OPEN_MAIL'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:OPEN_MAIL'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Open Notification'
    , X_DESCRIPTION => 'The message template that defines a response notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OPEN_MAIL_DIRECT'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:OPEN_MAIL_DIRECT'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Open Notification (Direct Response Parsing)'
    , X_DESCRIPTION => 'The message template that defines a Direct Response notificaiton'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OPEN_MORE_INFO'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:OPEN_MORE_INFO'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Open Notification (More Information Request)'
    , X_DESCRIPTION => 'The message template that defines a request for more information'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OPEN_MAIL_FYI'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:OPEN_MAIL_FYI'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Open FYI Notification'
    , X_DESCRIPTION => 'The message template that defines a FYI notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'OUTBOUND_PROTOCOL'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'smtp'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Protocol'
    , X_DESCRIPTION => 'The name of the protocol to be used for outbound notifications'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INBOUND_PROTOCOL'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'imap'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inbound Protocol'
    , X_DESCRIPTION => 'The name of the protocol to be used for inbound response emails'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'SEND_ACCESS_KEY'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Send Access Key'
    , X_DESCRIPTION => 'Attach the access key to the notification details attachment'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'ENABLE_STYLESHEET' 
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'N'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Enable stylesheet references'
    , X_DESCRIPTION => 'The flag to indicate whether or not the stylesheet reference is to be enabled on the email HTML'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'SUMHTML'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:SUMHTML'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound HTML Summary Notification'
    , X_DESCRIPTION => 'The message template that defines a HTML summary notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'SUMMARY'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:SUMMARY'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Summary Notification'
    , X_DESCRIPTION => 'The message template that defines a summary notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'WARNING'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'WFMAIL:WARNING'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Warning Notification'
    , X_DESCRIPTION => 'The message template that defines the unsolicited email warning notification'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'INLINE_ATTACHMENT'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => 'N'
    , X_REQUIRED_FLAG => 'N'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inline Attachments'
    , X_DESCRIPTION => 'Enable attachments to have a content-disposition of inline'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'FRAMEWORK_USER'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '0'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Framework User'
    , X_DESCRIPTION => 'The ID of the user who will be used to obtain the framework UI content for email'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'FRAMEWORK_RESP'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '20420'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Framework Responsibility'
    , X_DESCRIPTION => 'The ID of the responsibility for the Framework User'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'FRAMEWORK_APP'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '1'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Framework Application ID'
    , X_DESCRIPTION => 'The ID of the application for the Framework User'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'FRAMEWORK_URL_TIMEOUT'
    , X_COMPONENT_TYPE => 'WF_MAILER'
    , X_DEFAULT_PARAMETER_VALUE => '30'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Framework URL timeout'
    , X_DESCRIPTION => 'The timeout to apply when accessing Applications Framework URLs'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

--
-- ****************************************************************************
-- Component Type Parameter Definitions
-- (for WF_JAVA_AGENT_LISTENER)
-- ****************************************************************************
--
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'COMPONENT_LOG_LEVEL'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '5'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Log Level'
    , X_DESCRIPTION => 'Log level'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_MAX_ERROR_COUNT'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '10'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Max Error Count'
    , X_DESCRIPTION => 'Maximum number of times processing fails before the Service Component stops with error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_IN_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '1'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inbound Thread Count'
    , X_DESCRIPTION => 'Number of inbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_OUT_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '0'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Thread Count'
    , X_DESCRIPTION => 'Number of outbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '5'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Min Loop Sleep'
    , X_DESCRIPTION => 'Minimum amount of time in seconds the processing thread(s) will sleep when nothing has been read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_MAX_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '60'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Max Loop Sleep'
    , X_DESCRIPTION => 'Maximum amount of time in seconds the processing thread(s) will sleep when nothing has been read.  If this is set to 0, the back-off algorithm will not occur and Processor Min Loop Sleep will always be used'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '10'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Read Wait Timeout'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will wait while deqeueing'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_ERROR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => '60'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Error Loop Sleep'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will sleep after there has been an error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
    X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT_CLOSE'             
    , X_COMPONENT_TYPE => 'WF_JAVA_AGENT_LISTENER'
    , X_DEFAULT_PARAMETER_VALUE => 'N'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Close on Read Timeout'
    , X_DESCRIPTION => 'Whether or not to close if nothing was read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

--
-- ****************************************************************************
-- Components
-- (for WF_AGENT_LISTENER)
-- ****************************************************************************
--
FND_SVC_COMPONENTS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_component_status => 'STOPPED'
        , x_component_type => 'WF_AGENT_LISTENER'
        , x_startup_mode => 'AUTOMATIC'
        , x_container_type => 'SERV'
        , x_customization_level => 'L'
        , x_application_short_name => NULL
        , x_concurrent_queue_name => NULL
        , x_standalone_container_name => 'WFALSNRSVC'
        , x_inbound_agent_name => 'WF_DEFERRED'
        , x_outbound_agent_name => NULL
        , x_correlation_id => NULL
        , x_max_idle_time => NULL
        , x_component_status_info => NULL
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMPONENTS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_component_status => 'STOPPED'
        , x_component_type => 'WF_AGENT_LISTENER'
        , x_startup_mode => 'AUTOMATIC'
        , x_container_type => 'SERV'
        , x_customization_level => 'L'
        , x_application_short_name => NULL
        , x_concurrent_queue_name => NULL
        , x_standalone_container_name => 'WFALSNRSVC'
        , x_inbound_agent_name => 'WF_DEFERRED'
        , x_outbound_agent_name => NULL
        , x_correlation_id => 'oracle.apps.wf.notification.%'
        , x_max_idle_time => NULL
        , x_component_status_info => NULL
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMPONENTS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_component_status => 'STOPPED'
        , x_component_type => 'WF_AGENT_LISTENER'
        , x_startup_mode => 'AUTOMATIC'
        , x_container_type => 'SERV'
        , x_customization_level => 'L'
        , x_application_short_name => NULL
        , x_concurrent_queue_name => NULL
        , x_standalone_container_name => 'WFALSNRSVC'
        , x_inbound_agent_name => 'WF_ERROR'
        , x_outbound_agent_name => NULL
        , x_correlation_id => NULL
        , x_max_idle_time => NULL
        , x_component_status_info => NULL
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMPONENTS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_component_status => 'STOPPED'
        , x_component_type => 'WF_AGENT_LISTENER'
        , x_startup_mode => 'AUTOMATIC'
        , x_container_type => 'SERV'
        , x_customization_level => 'L'
        , x_application_short_name => NULL
        , x_concurrent_queue_name => NULL
        , x_standalone_container_name => 'WFALSNRSVC'
        , x_inbound_agent_name => 'WF_NOTIFICATION_IN'
        , x_outbound_agent_name => NULL
        , x_correlation_id => NULL
        , x_max_idle_time => NULL
        , x_component_status_info => NULL
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

--
-- ****************************************************************************
-- Components
-- (for WF_MAILER)
-- ****************************************************************************
--
FND_SVC_COMPONENTS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_component_status => 'NOT_CONFIGURED'
        , x_component_type => 'WF_MAILER'
        , x_startup_mode => 'AUTOMATIC'
        , x_container_type => 'SERV'
        , x_customization_level => 'L'
        , x_application_short_name => NULL
        , x_concurrent_queue_name => NULL
        , x_standalone_container_name => 'WFMLRSVC'
        , x_inbound_agent_name => 'WF_NOTIFICATION_IN'
        , x_outbound_agent_name => 'WF_NOTIFICATION_OUT' 
        , x_correlation_id => NULL
        , x_max_idle_time => NULL
        , x_component_status_info => NULL
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

--
-- ****************************************************************************
-- Components
-- (for WF_JAVA_AGENT_LISTENER)
-- ****************************************************************************
--
FND_SVC_COMPONENTS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_component_status => 'STOPPED'
        , x_component_type => 'WF_JAVA_AGENT_LISTENER'
        , x_startup_mode => 'AUTOMATIC'
        , x_container_type => 'SERV'
        , x_customization_level => 'L'
        , x_application_short_name => NULL
        , x_concurrent_queue_name => NULL
        , x_standalone_container_name => 'WFALSNRSVC'
        , x_inbound_agent_name => 'WF_JAVA_DEFERRED'
        , x_outbound_agent_name => NULL
        , x_correlation_id => NULL
        , x_max_idle_time => NULL
        , x_component_status_info => NULL
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMPONENTS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_component_status => 'STOPPED'
        , x_component_type => 'WF_JAVA_AGENT_LISTENER'
        , x_startup_mode => 'AUTOMATIC'
        , x_container_type => 'SERV'
        , x_customization_level => 'L'
        , x_application_short_name => NULL
        , x_concurrent_queue_name => NULL
        , x_standalone_container_name => 'WFALSNRSVC'
        , x_inbound_agent_name => 'WF_JAVA_ERROR'
        , x_outbound_agent_name => NULL
        , x_correlation_id => NULL
        , x_max_idle_time => NULL
        , x_component_status_info => NULL
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

--
-- ****************************************************************************
-- Component Parameter Values 
-- for 'Workflow Deferred Agent Listener'
-- ****************************************************************************
--
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'COMPONENT_LOG_LEVEL'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_ERROR_COUNT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_IN_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_OUT_THREAD_COUNT'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_LOOP_SLEEP'
        , x_parameter_value => '120'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_LOOP_SLEEP'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT'
        , x_parameter_value => '0'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_ERROR_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT_CLOSE'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Agent Listener'
        , x_parameter_name => 'LISTENER_PROCESS_EVT_COUNT'
        , x_parameter_value => '500'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


--
-- ****************************************************************************
-- Component Parameter Values 
-- for 'Workflow Deferred Notification Agent Listener'
-- ****************************************************************************
--
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'COMPONENT_LOG_LEVEL'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_ERROR_COUNT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_IN_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_OUT_THREAD_COUNT'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_LOOP_SLEEP'
        , x_parameter_value => '120'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_LOOP_SLEEP'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT'
        , x_parameter_value => '0'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_ERROR_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT_CLOSE'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Deferred Notification Agent Listener'
        , x_parameter_name => 'LISTENER_PROCESS_EVT_COUNT'
        , x_parameter_value => '500'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

--
-- ****************************************************************************
-- Component Parameter Values 
-- for 'Workflow Error Agent Listener'
-- ****************************************************************************
--

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'COMPONENT_LOG_LEVEL'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_ERROR_COUNT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_IN_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_OUT_THREAD_COUNT'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_LOOP_SLEEP'
        , x_parameter_value => '120'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_LOOP_SLEEP'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT'
        , x_parameter_value => '0'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_ERROR_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT_CLOSE'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Error Agent Listener'
        , x_parameter_name => 'LISTENER_PROCESS_EVT_COUNT'
        , x_parameter_value => '500'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);
--
-- ****************************************************************************
-- Component Parameter Values 
-- for 'Workflow Inbound Notifications Agent Listener'
-- ****************************************************************************
--
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'COMPONENT_LOG_LEVEL'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_ERROR_COUNT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_IN_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_OUT_THREAD_COUNT'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_LOOP_SLEEP'
        , x_parameter_value => '120'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_LOOP_SLEEP'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT'
        , x_parameter_value => '0'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_ERROR_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT_CLOSE'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Inbound Notifications Agent Listener'
        , x_parameter_name => 'LISTENER_PROCESS_EVT_COUNT'
        , x_parameter_value => '500'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);
--
-- ****************************************************************************
-- Component Parameter Values 
-- for 'Workflow Notification Mailer'
-- ****************************************************************************
--

--
-- Required GSC Parameter Values
-- 
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'COMPONENT_LOG_LEVEL'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_MAX_ERROR_COUNT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_IN_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_OUT_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_LOOP_SLEEP'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_MAX_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_ERROR_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT_CLOSE'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESSOR_DEFER_EVTDATA_READ'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
  );

--
-- 'Workflow Notification Mailer'-specific Parameter Values
-- 
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'ACCOUNT'
        , x_parameter_value => NULL
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'ALLOW_FORWARDED_RESPONSE'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'ALTERNATE_EMAIL_PARSER'
        , x_parameter_value => 'oracle.apps.fnd.wf.mailer.DirectEmailParser'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'ATTACH_IMAGES'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'ATTACH_STYLESHEET'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'ATTACHED_URLS'
        , x_parameter_value => 'WFMAIL:ATTACHED_URLS'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'AUTOCLOSE_FYI'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'CANCELED'
        , x_parameter_value => 'WFMAIL:CANCELED'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'CLOSED'
        , x_parameter_value => 'WFMAIL:CLOSED'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'DEBUG_MAIL_SESSION'
        , x_parameter_value => 'N'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'DIRECT_RESPONSE'
        , x_parameter_value => 'N'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'DISCARD'
        , x_parameter_value => 'DISCARD'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'EMAIL_PARSER'
        , x_parameter_value => 'oracle.apps.fnd.wf.mailer.TemplatedEmailParser'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'EXPUNGE_ON_CLOSE'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'FRAMEWORK_USER'
        , x_parameter_value => '0'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'FRAMEWORK_RESP'
        , x_parameter_value => '20420'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'FRAMEWORK_APP'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'FRAMEWORK_URL_TIMEOUT'
        , x_parameter_value => '30'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'FROM'
        , x_parameter_value => 'Workflow Mailer'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'HTMLAGENT'
        , x_parameter_value => NULL
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'HTTP_USER_AGENT'
        , x_parameter_value => 'Mozilla/4.76'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
        x_component_name => 'Workflow Notification Mailer' 
        , x_parameter_name => 'INBOUND_CONNECTION_TIMEOUT' 
        , x_parameter_value => '120' 
        , x_customization_level => 'L' 
        , x_object_version_number => -1 
        , x_owner => 'ORACLE' 
); 

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
        x_component_name => 'Workflow Notification Mailer' 
        , x_parameter_name => 'INBOUND_FETCH_SIZE' 
        , x_parameter_value => 100 
        , x_customization_level => 'L' 
        , x_object_version_number => -1 
        , x_owner => 'ORACLE' 
); 

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row  
( 
        x_component_name => 'Workflow Notification Mailer' 
        , x_parameter_name => 'INBOUND_MAX_IGNORE_SIZE' 
        , x_parameter_value => 1000 
        , x_customization_level => 'L' 
        , x_object_version_number => -1 
        , x_owner => 'ORACLE' 
);
    
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row  
( 
        x_component_name => 'Workflow Notification Mailer' 
        , x_parameter_name => 'INBOUND_MAX_LOOKUP_CACHE_SIZE'
        , x_parameter_value => 100
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row  
( 
        x_component_name => 'Workflow Notification Mailer' 
        , x_parameter_name => 'INBOUND_PASSWORD'
        , x_parameter_value => NULL
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'INBOUND_PROTOCOL'
        , x_parameter_value => 'imap'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'INBOUND_SERVER'
        , x_parameter_value => NULL
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'INBOUND_MAX_RET_EMAIL_SIZE'
        , x_parameter_value => '100'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'INBOUND_UNSOLICITED_THRESHOLD'
        , x_parameter_value => '2'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'INBOX'
        , x_parameter_value => 'INBOX'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'INLINE_ATTACHMENT'
        , x_parameter_value => 'N'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'MAX_INVALID_ADDR_LIST_SIZE'
        , x_parameter_value => '100'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'MESSAGE_FORMATTER'
        , x_parameter_value => 'oracle.apps.fnd.wf.mailer.NotificationFormatter'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'NODENAME'
        , x_parameter_value => 'WFMAIL'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'NODENAME'
        , x_parameter_value => 'WFMAIL'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OPEN_INVALID'
        , x_parameter_value => 'WFMAIL:OPEN_INVALID'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OPEN_INVALID_MORE_INFO'
        , x_parameter_value => 'WFMAIL:OPEN_INVALID_MORE_INFO'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OPEN_MAIL'
        , x_parameter_value => 'WFMAIL:OPEN_MAIL'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OPEN_MORE_INFO'
        , x_parameter_value => 'WFMAIL:OPEN_MORE_INFO'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OPEN_MAIL_DIRECT'
        , x_parameter_value => 'WFMAIL:OPEN_MAIL_DIRECT'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OPEN_MAIL_FYI'
        , x_parameter_value => 'WFMAIL:OPEN_MAIL_FYI'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OUTBOUND_CONNECTION_TIMEOUT'
        , x_parameter_value => '120'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OUTBOUND_PROTOCOL'
        , x_parameter_value => 'smtp'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'OUTBOUND_SERVER'
        , x_parameter_value => NULL
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'PROCESS'
        , x_parameter_value => 'PROCESS'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'REPLYTO'
        , x_parameter_value => NULL
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'RESET_NLS'
        , x_parameter_value => 'N'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'SEND_ACCESS_KEY'
        , x_parameter_value => 'Y'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'ENABLE_STYLESHEET'
        , x_parameter_value => 'N'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'SUMHTML'
        , x_parameter_value => 'WFMAIL:SUMHTML'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'SUMMARY'
        , x_parameter_value => 'WFMAIL:SUMMARY'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'TEST_ADDRESS'
        , x_parameter_value => 'NONE'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Notification Mailer'
        , x_parameter_name => 'WARNING'
        , x_parameter_value => 'WFMAIL:WARNING'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


--
-- ****************************************************************************
-- Component Parameter Values 
-- for Workflow Java Deferred Agent Listener
-- ********************************
--
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'COMPONENT_LOG_LEVEL'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_ERROR_COUNT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_IN_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_OUT_THREAD_COUNT'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_LOOP_SLEEP'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_ERROR_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Deferred Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT_CLOSE'
        , x_parameter_value => 'N'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

--
-- ****************************************************************************
-- Component Parameter Values 
-- for Workflow Java Error Agent Listener
-- ********************************
--
FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'COMPONENT_LOG_LEVEL'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_ERROR_COUNT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_IN_THREAD_COUNT'
        , x_parameter_value => '1'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_OUT_THREAD_COUNT'
        , x_parameter_value => '0'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_LOOP_SLEEP'
        , x_parameter_value => '5'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_MAX_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'C'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);

FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT'
        , x_parameter_value => '10'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_ERROR_LOOP_SLEEP'
        , x_parameter_value => '60'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


FND_SVC_COMP_PARAM_VALS_PKG.Load_Row 
(
          x_component_name => 'Workflow Java Error Agent Listener'
        , x_parameter_name => 'PROCESSOR_READ_TIMEOUT_CLOSE'
        , x_parameter_value => 'N'
        , x_customization_level => 'L'
        , x_object_version_number => -1
        , x_owner => 'ORACLE'
);


END;

/

commit;
exit;
