REM $Header: wfsvcttl.sql 26.0 2005/04/25 18:54:32 sacsharm noship $
REM dbdrv: none
REM +======================================================================+
REM |       Copyright (c) 2003, 2005. Oracle. All rights reserved.         |
REM +======================================================================+
REM   NAME
REM       wfsvcttl.sql - Service Components Seed Data TransLations
REM
REM   DESCRIPTION
REM       Load translated display name and descriptions for Service 
REM       Components seed dataA
REM
REM   USAGE
REM       - Load the translated wfsvcmsg.msg for the given non-base language
REM       - Set the nls langauge to that of the non-base language
REM       - Run script wfsvcttl.sql
REM       - This script will now update the display_name, description with the
REM         non-base language translation
REM       - PLEASE NOTE this script should NOT be run under base language
REM
REM   NOTES
REM       This script populates columns in:
REM         FND_SVC_COMP_TYPES_TL
REM         FND_SVC_COMP_PARAMS_TL
REM
REM +======================================================================+

SET VERIFY OFF
WHENEVER OSERROR EXIT FAILURE ROLLBACK
WHENEVER SQLERROR EXIT FAILURE ROLLBACK

declare
  l_display_name  varchar2(80);
  l_desription    varchar2(1996);

  CURSOR c_params is
  SELECT parameter_id, parameter_name
  FROM   fnd_svc_comp_params_b;

  CURSOR c_comp_types is
  SELECT component_type
  FROM   fnd_svc_comp_types_b;
begin

  -- In standalone US is always the base language
  if (userenv('LANG') <> 'US') then
    -- Translate component parameter display name, descriptions
    for c_param_rec in c_params loop
      l_display_name := wf_core.translate('N'||c_param_rec.parameter_name);
      l_desription :=  wf_core.translate('D'||c_param_rec.parameter_name);
      fnd_svc_comp_params_pkg.Translate_Row(x_parameter_id => c_param_rec.parameter_id,
                                            x_display_name => l_display_name,
                                            x_description => l_desription,
                                            x_owner => 'ORACLE');
    end loop;

    -- Translate component type display name, descriptions
    for c_cmp_type_rec in c_comp_types loop
      l_display_name := wf_core.translate('N'||c_cmp_type_rec.component_type);
      l_desription :=  wf_core.translate('D'||c_cmp_type_rec.component_type);
      fnd_svc_comp_types_pkg.Translate_Row(x_component_type => c_cmp_type_rec.component_type,
                                           x_display_name => l_display_name,
                                           x_description => l_desription,
                                           x_owner => 'ORACLE');
    end loop;
  end if;
end;
/
commit;
exit;
