REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=pda \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
rem *************************************************************
rem $Header: wfsysupl.sql 26.15 2003/08/25 09:17:54 rosthoma ship $
rem NAME:
rem      wfsysupl.sql
rem DESCRIPTION:
rem This script is run by the installer to seed the Local System 
rem into the WF_SYSTEMS table, and to update the Local System 
rem Global Preference to point at this system. 
rem
rem NOTE:
rem      ** Should be run at end of install, but can be rerun if needed
rem USAGE:
rem sqlplus un/pw @wfsysupl.sql 
rem MODIFICATION LOG:
rem   01/2002 JWSMITH BUG 2001012 - Increased l_qowner to varchar2(320)
rem   08/2003 ROSTHOMA            - Removed connect to apps 
rem **************************************************************

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;


declare
  l_guid	raw(16);
  l_sid		varchar2(1000);
  l_description varchar2(240);
  l_error	number;
  l_exists	varchar2(10);
  l_qowner      varchar2(320); 

begin

  -- Set the NLS_LANGUAGE
  dbms_session.set_nls('NLS_LANGUAGE','AMERICAN');

  -- Get the Globally Unique Identifier
  l_guid := sys_guid();

  -- Get the Local SID
  l_sid := substr(wf_event_synchronize_pkg.GetSID,1,30); 

  -- Get the Description
  l_description := 'Local system Created by Oracle Workflow Configuration Assistant';

  -- Update the Global Preferences WF_SYSTEM_GUID
  if wf_core.translate('WF_SYSTEM_GUID') = '[WF_SYSTEM_GUID]' then
    -- never uploaded before
    wf_core.session_level := 0;
    wf_load.upload_resource(x_type => 'WFTKN',
				x_name => 'WF_SYSTEM_GUID',
				x_protect_level => 0,
				x_custom_level => 0,
				x_id => 0,
				x_text => l_guid,
				x_level_error => l_error);

    -- Raise Error if any error level not returned equal to zero
    if l_error <> 0 then
      wf_core.raise('WFE_SYSTEM_GUID');
    end if;

    -- Update the Global Preferences WF_SYSTEMS_STATUS
    -- As per GB, to minimize post install steps, set status to enabled
    -- and submit local propagation
    wf_core.session_level := 0;
    wf_load.upload_resource(x_type => 'WFTKN',
                                x_name => 'WF_SYSTEM_STATUS',
                                x_protect_level => 0,
                                x_custom_level => 0,
                                x_id => 0,
                                --x_text => 'LOCAL',
                                x_text => 'ENABLED',
                                x_level_error => l_error);

    -- Raise Error if any error level not returned equal to zero
    if l_error <> 0 then
      wf_core.raise('WFE_SYSTEM_STATUS');
    end if;
  
    -- Upload using Table Handler that does not require XML Parser
    wf_systems_pkg.load_row(x_guid => l_guid,
				x_name => l_sid,
				x_master_guid => null,
				x_display_name => l_sid,
				x_description => l_description);
  end if;

  -- ### Took this set up out and this will be a manual step
  -- ### if people need to use the event system
  -- Schedule Local Propagation
  -- 1. Derive Owner
  -- 2. Check is Schedule Exists
  --   If no schedule, then create
  --   else do nothing
  -- We know the queue will be APPLSYS.WF_OUT if the queue is not in
  -- the current schema, the destination will be null
  -- Duration is 10 secs, run every 60 secs, messages wait for max of 60 
  -- before being propagated
  --  begin
  --    select 'exists' into l_exists
  --    from user_queues
  --    where name = 'WF_OUT';
  --    
  --    l_qowner :=  << here is user connected to as >>
  --  exception
  --    when no_data_found then
  --      l_qowner := 'APPLSYS';
  --  end;
  -- 
  --  begin
  --    select 'exists' into l_exists
  --    from dba_queue_schedules
  --    where schema = l_qowner
  --    and qname = 'WF_OUT';
  --  exception
  --    when no_data_found then
  --      DBMS_AQADM.Schedule_Propagation(
  --        queue_name =>l_qowner||'.WF_OUT',
  --        destination => null,
  --        start_time => sysdate,
  --        duration => 10,
  --        next_time => 'SYSDATE + 1/24/60',
  --        latency => 60
  --       );
  --  end;
  --
  -- ### end of commented section
end;
/
commit;
exit;
