REM $Header: wftoken.sql 26.0 2003/02/20 07:33:57 rosthoma ship $
REM +======================================================================+
REM | Copyright (c) 2003 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM     wftoken.sql  -  Upload workflow token WF_ADMIN_ROLE
REM                     and WF_WEB_AGENT 
REM NOTE 
REM     The tokens WF_ADMIN_ROLE and WF_WEB_AGENT are loaded.
REM     The parameters name and values are passes as "WF_ADMIN_ROLE"
REM     "SYSADMIN" etc. 
REM          
REM
REM MODIFICATION LOG:
REM     20/2/2003       ROSTHOMA      Created
REM =======================================================================
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE;
SET VERIFY OFF;

declare
  param_name   varchar2(30)   := '&1';
  value        VARCHAR2(2000) := '&2';
  level_error number;
begin
  begin
    update WF_RESOURCES
    set    SOURCE_LANG = 'US'
    where  name        = param_name;
  exception
    when others then
     --This is to take care of condition when this
     --row does not exist in the database
     null;
  end;

  WF_CORE.SESSION_LEVEL := 0; 
  WF_CORE.UPLOAD_MODE   := 'FORCE'; 
  WF_LOAD.UPLOAD_RESOURCE('WFTKN',param_name,0,0,0,value,level_error);
end;
/
commit;
exit;

