REM dbdrv: sql ~PROD ~PATH ~FILE none none none sql_single &phase=tbm \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
REM *=======================================================================+
REM |  Copyright (c) 2001 Oracle Corporation Redwood Shores, California, USA|
REM |                            All rights reserved.                       |
REM +=======================================================================+
REM | FILENAME
REM |   wftypes2.pls - Created from wftypes.sql
REM | DESCRIPTION
REM |   Creates the TYPEs for the Business Event System
REM |     wf_agent_t
REM |     wf_event_t
REM |     wf_parameter_list_t
REM |     wf_parameter_t
REM *=======================================================================*/
REM $Header: wftype2s.sql 26.0 2003/07/14 17:42:23 rosthoma noship $
REM ad_error_handling: add 955


SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

WHENEVER SQLERROR CONTINUE;

WHENEVER SQLERROR EXIT;
create type WF_AGENT_T as object
(
  NAME             VARCHAR2(30),
  SYSTEM           VARCHAR2(30),

  MEMBER FUNCTION  getName   return varchar2,
  MEMBER FUNCTION  getSystem return varchar2,

  MEMBER PROCEDURE setName  (pName   in varchar2),
  MEMBER PROCEDURE setSystem(pSystem in varchar2)
)
/
REM +---------------------------------------------------------------------+
create type WF_PARAMETER_T as object
(
  NAME   VARCHAR2(30),
  VALUE  VARCHAR2(2000),

  MEMBER FUNCTION  getName  return varchar2,
  MEMBER FUNCTION  getValue return varchar2,

  MEMBER PROCEDURE setName (pName  in varchar2),
  MEMBER PROCEDURE setValue(pValue in varchar2)
)
/
REM +---------------------------------------------------------------------+
create type WF_PARAMETER_LIST_T is VARRAY(100) OF WF_PARAMETER_T
/
REM +---------------------------------------------------------------------+
create type WF_EVENT_T as object
(
  PRIORITY           NUMBER,
  SEND_DATE          DATE,
  RECEIVE_DATE       DATE,
  CORRELATION_ID     VARCHAR2(240),
  PARAMETER_LIST     WF_PARAMETER_LIST_T,
  EVENT_NAME         VARCHAR2(240),
  EVENT_KEY          VARCHAR2(240),
  EVENT_DATA         CLOB,
  FROM_AGENT         WF_AGENT_T,
  TO_AGENT           WF_AGENT_T,
  ERROR_SUBSCRIPTION RAW(16),
  ERROR_MESSAGE      VARCHAR2(4000),
  ERROR_STACK        VARCHAR2(4000),

  STATIC PROCEDURE initialize(new_wf_event_t IN OUT wf_event_t), 

  MEMBER FUNCTION  getFromAgent         return wf_agent_t,
  MEMBER FUNCTION  getToAgent           return wf_agent_t,
  MEMBER FUNCTION  getPriority          return number,
  MEMBER FUNCTION  getSendDate          return date,
  MEMBER FUNCTION  getReceiveDate       return date,
  MEMBER FUNCTION  getCorrelationID     return varchar2,
  MEMBER FUNCTION  getParameterList     return wf_parameter_list_t,
  MEMBER FUNCTION  getEventName         return varchar2,
  MEMBER FUNCTION  getEventKey          return varchar2,
  MEMBER FUNCTION  getEventData         return clob,
  MEMBER FUNCTION  getErrorSubscription return raw,
  MEMBER FUNCTION  getErrorMessage      return varchar2,
  MEMBER FUNCTION  getErrorStack        return varchar2,

  MEMBER PROCEDURE setFromAgent        (pFromAgent in wf_agent_t),
  MEMBER PROCEDURE setToAgent          (pToAgent in wf_agent_t),
  MEMBER PROCEDURE setPriority         (pPriority in number),
  MEMBER PROCEDURE setSendDate         (pSendDate in date default sysdate),
  MEMBER PROCEDURE setReceiveDate      (pReceiveDate in date default sysdate),
  MEMBER PROCEDURE setCorrelationID    (pCorrelationID in varchar2),
  MEMBER PROCEDURE setParameterList    (pParameterList in wf_parameter_list_t),
  MEMBER PROCEDURE setEventName        (pEventName in varchar2),
  MEMBER PROCEDURE setEventKey         (pEventKey in varchar2),
  MEMBER PROCEDURE setEventData        (pEventData in clob),
  MEMBER PROCEDURE setErrorSubscription(pErrorSubscription in raw),
  MEMBER PROCEDURE setErrorMessage     (pErrorMessage in varchar2),
  MEMBER PROCEDURE setErrorStack       (pErrorStack in varchar2),

  MEMBER PROCEDURE Content(pName in varchar2,
                           pKey  in varchar2,
                           pData in clob),
  
  MEMBER PROCEDURE Address(pOutAgent in wf_agent_t,
                           pToAgent  in wf_agent_t,
                           pPriority in number,
                           pSendDate in date),

  MEMBER PROCEDURE AddParameterToList(pName  in varchar2,
                                      pValue in varchar2),

  MEMBER FUNCTION GetValueForParameter(pName in varchar2) return varchar2
)
/

REM +---------------------------------------------------------------------+
commit;
exit;
