REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=tbm+1 \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
REM *=======================================================================+
REM |  Copyright (c) 2001 Oracle Corporation Redwood Shores, California, USA|
REM |                            All rights reserved.                       |
REM +=======================================================================+
REM | FILENAME
REM |   wftypeb.pls
REM | DESCRIPTION
REM |   Creates the TYPEs body for the Business Event System
REM |     wf_agent_t
REM |     wf_event_t
REM |     wf_parameter_list_t
REM |     wf_parameter_t
REM *=======================================================================*/
REM $Header: wftypeb.sql 26.6 2004/05/14 08:32:26 rosthoma ship $

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

whenever sqlerror continue;

WHENEVER SQLERROR EXIT ;

create or replace type body WF_AGENT_T as
  MEMBER FUNCTION getName return varchar2 is
  begin
    return name;
  end getName;

  MEMBER FUNCTION getSystem return varchar2 is
  begin
    return system;
  end getSystem;

  MEMBER PROCEDURE setName(pName in varchar2) is
  begin
    name := upper(pName);
  end setName;

  MEMBER PROCEDURE setSystem(pSystem in varchar2) is
  begin
    system := upper(pSystem);
  end setSystem;
end;
/
REM +----------------------------------------------------------------------+
create or replace type body WF_PARAMETER_T as
  MEMBER FUNCTION getName return varchar2 is
  begin
    return name;
  end getName;

  MEMBER FUNCTION getValue return varchar2 is
  begin
    return value;
  end getValue;

  MEMBER PROCEDURE setName(pName in varchar2) is
  begin
    name := pName;
  end setName;

  MEMBER PROCEDURE setValue(pValue in varchar2) is
  begin
    value := pValue;
  end setValue;
end;
/
REM +----------------------------------------------------------------------+
create or replace type body WF_EVENT_T as
  STATIC PROCEDURE initialize(new_wf_event_t IN OUT wf_event_t) is
  begin
    new_wf_event_t := wf_event_t(0,              -- priority
                                 null,           -- send_date
                                 null,           -- receive_date
                                 null,           -- correlation_id
                                 null,           -- parameter_list
                                 null,           -- event_name
                                 null,           -- event_key
                                 empty_clob(),   -- event_data
                                 null,           -- from_agent
                                 null,           -- to_agent
                                 null,           -- error_subscription
                                 null,           -- error_message
                                 null);          -- error_stack
  end initialize;

  MEMBER FUNCTION getFromAgent return wf_agent_t is
  begin
    return From_Agent;
  end getFromAgent;

  MEMBER FUNCTION getToAgent return wf_agent_t is
  begin
    return To_Agent;
  end getToAgent;

  MEMBER FUNCTION getPriority return number is
  begin
    return Priority;
  end getPriority;

  MEMBER FUNCTION getSendDate return date is
  begin
    return Send_Date;
  end getSendDate;

  MEMBER FUNCTION getReceiveDate return date is
  begin
    return Receive_Date;
  end getReceiveDate;

  MEMBER FUNCTION getCorrelationID return varchar2 is
  begin
    return Correlation_ID;
  end getCorrelationID;

  MEMBER FUNCTION getParameterList return wf_parameter_list_t is
  begin
    return Parameter_List;
  end getParameterList;

  MEMBER FUNCTION getEventName return varchar2 is
  begin
    return Event_Name;
  end getEventName;

  MEMBER FUNCTION getEventKey return varchar2 is
  begin
    return Event_Key;
  end getEventKey;

  MEMBER FUNCTION getEventData return clob is
  begin
    return Event_Data;
  end getEventData;

  MEMBER FUNCTION getErrorSubscription return raw is
  begin
    return error_subscription;
  end getErrorSubscription;

  MEMBER FUNCTION getErrorMessage return varchar2 is
  begin
    return error_message;
  end getErrorMessage;

  MEMBER FUNCTION getErrorStack return varchar2 is
  begin
    return error_stack;
  end getErrorStack;

  MEMBER PROCEDURE setFromAgent(pFromAgent in wf_agent_t) is
  begin
    From_Agent := pFromAgent;
  end setFromAgent;

  MEMBER PROCEDURE setToAgent(pToAgent in wf_agent_t) is
  begin
    To_Agent := pToAgent;
  end setToAgent;

  MEMBER PROCEDURE setPriority(pPriority in number) is
  begin
    Priority := pPriority;
  end setPriority;

  MEMBER PROCEDURE setSendDate(pSendDate in date default sysdate) is
  begin
    Send_Date := pSendDate;
  end setSendDate;

  MEMBER PROCEDURE setReceiveDate(pReceiveDate in date default sysdate) is
  begin
    Receive_Date := pReceiveDate;
  end setReceiveDate;

  MEMBER PROCEDURE setCorrelationID(pCorrelationID in varchar2) is
  begin
    Correlation_ID := pCorrelationID;
  end setCorrelationID;

  MEMBER PROCEDURE setParameterList(pParameterList in wf_parameter_list_t) is
  begin
    Parameter_List := pParameterList;
  end setParameterList;

  MEMBER PROCEDURE setEventName(pEventName in varchar2) is
  begin
    Event_Name := pEventName;
  end setEventName;

  MEMBER PROCEDURE setEventKey(pEventKey in varchar2) is
  begin
    Event_Key := pEventKey;
  end setEventKey;

  MEMBER PROCEDURE setEventData(pEventData in clob) is
  begin
    Event_Data := pEventData;
  end setEventData;

  MEMBER PROCEDURE setErrorSubscription(pErrorSubscription in raw) is
  begin
    error_subscription := pErrorSubscription;
  end setErrorSubscription;

  MEMBER PROCEDURE setErrorMessage(pErrorMessage in varchar2) is
  begin
    error_message := pErrorMessage;
  end setErrorMessage;

  MEMBER PROCEDURE setErrorStack(pErrorStack in varchar2) is
  begin
    error_stack := pErrorStack;
  end setErrorStack;

  MEMBER PROCEDURE Content(pName in varchar2,
                           pKey  in varchar2,
                           pData in clob) is
  begin
    self.setEventName(pName);
    self.setEventKey(pKey);
    self.setEventData(pData);
  end Content;
 
  MEMBER PROCEDURE Address(pOutAgent in wf_agent_t,
                           pToAgent  in wf_agent_t,
                           pPriority in number,
                           pSendDate in date) is
  begin
    self.setFromAgent(pOutAgent);
    self.setToAgent(pToAgent);
    self.setPriority(pPriority);
    self.setSendDate(pSendDate);
  end Address;
  
  -- This method shares the same logic as WF_EVENT.AddParameterToList
  -- Before we consolidate this method to single place, any change to 
  -- this method has to be replicated to WF_EVENT.AddParameterToList.
  MEMBER PROCEDURE AddParameterToList(pName  in varchar2,
                                      pValue in varchar2) is
    myList  wf_parameter_list_t;
    j       number;
    found   boolean := FALSE;
    
  begin
    myList := self.getParameterList();

    if (myList is null) then
      myList := wf_parameter_list_t(null);
      myList(1) := wf_parameter_t(pName, pValue);
    else
      -- parameter list exists --
      -- if parameter already exists in the list, just reset its value --

      j := 1;
      while (NOT found AND j <= myList.COUNT ) LOOP
        -- YOHUANG 3566991, make sure myList(j) is not null
        -- to avoid 36025 ora error
        IF (myList(j) IS NOT NULL) THEN
          if (myList(j).getName() = pName) then
             found := TRUE;
             myList(j).setValue(pValue);
          END if;
        END IF;
        j := j+1;
      end loop;

      -- otherwise, add new parameter to list --

      if (NOT found) then
        myList.EXTEND;
        j := myList.COUNT;
        myList(j) := wf_parameter_t(pName, pValue);
      end if;
    end if;

    self.setParameterList(myList);
  end AddParameterToList;

  MEMBER FUNCTION getValueForParameter(pName in varchar2) return varchar2 is
    myList  wf_parameter_list_t;
    pos     number := 1;
  begin
    myList := self.getParameterList();
    if (myList is null) then
      return NULL;
    end if;

    pos := myList.LAST;
    --while(pos <= myList.COUNT) loop
    while(pos is not null) loop
      if (myList(pos).getName() = pName) then
        return myList(pos).getValue();
      end if;
      --pos := pos + 1;
      pos := myList.PRIOR(pos);
    end loop;
    return NULL;
  end getValueForParameter;
end;
/
REM +----------------------------------------------------------------------+
grant execute on wf_event_t to public
/
grant execute on wf_parameter_t to public
/
grant execute on wf_agent_t to public
/
grant execute on wf_parameter_list_t to public
/

commit;
exit;


