REM dbdrv: none
REM +========================================================================+
REM |        Copyright (c) 1996, 2004, Oracle. All rights reserved.          |
REM +========================================================================+
REM | FILENAME
REM |   wfwbcfgb.pls
REM |
REM | DESCRIPTION
REM |   PL/SQL body for package:  WF_WEB_CONFIG
REM |
REM |   This package validates access to Workflow PL/SQL procedures that are 
REM |   executed through mod_plsql.
REM +========================================================================+

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package body WF_WEB_CONFIG as
/* $Header: wfwbcfgb.pls 26.0 2004/09/15 05:43:44 vshanmug noship $ */

type g_pkg_table_t is table of varchar2(80); 

-- List of valid Web PLSQL packages. Please add new packages to the following
-- list if required. Please add new packages in UPPER case.
g_packages g_pkg_table_t := g_pkg_table_t(
   'FND_DOCUMENT_MANAGEMENT', 
   'WFA_HTML', 
   'WFA_SEC',
   'WF_ACTIVITIES_VL_PUB', 
   'WF_CORE', 
   'WF_DEMO', 
   'WF_EVENTDEMO', 
   'WF_EVENT_HTML',
   'WF_INITIATE', 
   'WF_ITEM_DEFINITION', 
   'WF_LOV', 
   'WF_MONITOR', 
   'WF_PREF',
   'WF_REQDEMO',
   'WF_ROUTE',
   'WF_SETUP'
);

--
-- Check_Enabled
--   Validates from a list of valid PLSQL packages to see if it is valid
--   to execute a procedure from this package
-- IN
--   p_proc_name - Name of the proedure executed by the mod_plsql

function Check_Enabled(p_proc_name in varchar2)
return boolean
is
  l_package varchar2(30);
begin
  l_package := upper(substr(p_proc_name, 1, instr(p_proc_name, '.', 1)-1));

  -- check if the package is valid 
  for i in 1..g_packages.last loop
    if (l_package = g_packages(i)) then
      return true;
    end if; 
  end loop;

  -- If we reached here, the procedure is invalid
  return false;
exception
  when others then
    return false;
end Check_Enabled;

end WF_WEB_CONFIG;
/

-- show errors;
commit;
exit;
