REM +========================================================================+
REM |        Copyright (c) 1996, 2004, Oracle. All rights reserved.          |
REM +========================================================================+
REM | FILENAME
REM |   wfwbcfgs.pls
REM |
REM | DESCRIPTION
REM |   PL/SQL spec for package:  WF_WEB_CONFIG
REM |
REM |   This package validates access to Workflow PL/SQL procedures that are
REM |   executed through mod_plsql.
REM +========================================================================+

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_WEB_CONFIG as
/* $Header: wfwbcfgs.pls 26.0 2004/09/15 05:43:36 vshanmug noship $ */

--
-- Check_Enabled
--   Validates from a list of valid PLSQL packages to see if it is valid
--   to execute a procedure from this package
-- IN
--   p_proc_name - Name of the procedure executed by the PLSQL Agent

Function Check_Enabled(p_proc_name in varchar2) 
return boolean;

end WF_WEB_CONFIG;
/

-- show errors;
commit;
exit;
