begin 

declare
	l_id number := 0;

	procedure exec(p_stmt in varchar2)
	is
	begin
		execute immediate p_stmt;
	exception
		when others then
      	dbms_output.put_line('===>' ||sqlcode || ' ' || sqlerrm);
      	dbms_output.put_line('    ' || substr(p_stmt, 1, 250));
	end;
begin
	-- Public View Version set to 11.1 for Tokyo (10.1 for Paris)
	--|repository
	exec('insert into owbb_repos_types values (
	  ''OWB RUNTIME''
	  ,''11.1''
	  ,''select public_view_version from ALL_RT_INSTALLATIONS@''
	  ,''Oracle Warehouse Builder Runtime''
	  ,''admin_runtime_repos''
	  ,''OWB_RUNTIME.gif''
	  )
	');

	exec('insert into owbb_repos_types values (
	  ''OWB DESIGN''
	  ,''11.1''
	  ,''select public_view_version from ALL_IV_INSTALLATIONS@''
	  ,''Oracle Warehouse Builder Design''
	  ,''admin_design_repos''
	  ,''OWB_DESIGN.gif''
	  )
	');

/*
	--|roles
	exec('insert into owbb_roles values (
		''QA''
		,''QA User''
		,''role_qa_user''
		)
	');
  
	exec('insert into owbb_roles values (
		''USER''
		,''Warehouse User''
		,''role_wh_user''
		)
	');
  
	exec('insert into owbb_roles values (
		''ENGINEER''
		,''Warehouse Engineer''
		,''role_wh_engineer''
		)
	');

	exec('insert into owbb_roles values (
		''ADMINISTRATOR''
		,''Warehouse Administrator''
		,''role_wh_administrator''
		)
	');
*/

	exec('insert into owbb_roles values (
		''*''
		,''All''
		,''role_all''
		)
	');

	exec('insert into owbb_user_roles values (
		owbb_api_administration.user_id(''PORTAL''),
		''QA''
		)
	');

	exec('insert into owbb_user_roles values (
		owbb_api_administration.user_id(''PORTAL''),
		''USER''
		)
	');

	exec('insert into owbb_user_roles values (
		owbb_api_administration.user_id(''PORTAL''),
		''ENGINEER''
		)
	');


	exec('insert into owbb_user_roles values (
		owbb_api_administration.user_id(''PORTAL''),
		''ADMINISTRATOR''
		)
	');

	--|apps
	exec('insert into owbb_applications values (
  		1
		,''OWB 11.1''
		,''01-JUL-03''
		,''Warehouse Builder Runtime Audit Browser''
		,''gen_owbb_rab''
		,''OWB RUNTIME''
		)
	');

	exec('insert into owbb_applications values (
  		2
		,''OWB 11.1''
		,''01-JUL-03''
		,''Warehouse Builder Design Browser''
		,''gen_owbb_design''
		,''OWB DESIGN''
		)
	');

	exec('insert into owbb_app_repos_versions values (
  		1
		,''OWB RUNTIME''
		,''11.1''
		)
	');

	exec('insert into owbb_app_repos_versions values (
  		1
		,''OWB DESIGN''
		,''11.1''
		)
	');

	exec('insert into owbb_app_renderers values (
		1
		,''OWB RUNTIME''
		,''*''
		,''UIX''
		,''RABRepository.uix''
		,''rts.owbb_rab''
		)
	');

	exec('insert into owbb_app_renderers values (
		2
		,''OWB DESIGN''
		,''*''
		,''UIX''
		,''DesignNavMain.uix''
		,''rts.owbb_rab''
		)
	');

	--|Admin
	exec('insert into owbb_administrators values (
		owbb_api_administration.user_id(''PORTAL''),
		''USER''
		)
	');


	--|DAS
	exec('insert into owbb_preferences (PATH, LEVEL_TYPE, LEVEL_ID, NAME, VALUE) values 
		(
		''owbb.das'', ''S'', 0, 
		''protocol'', ''http''
		)
	');
  
	exec('insert into owbb_preferences (PATH, LEVEL_TYPE, LEVEL_ID, NAME, VALUE) values 
		(
		''owbb.das'', ''S'', 0, 
		''dad'', ''oiddas''
		)
	');

	exec('insert into owbb_preferences (PATH, LEVEL_TYPE, LEVEL_ID, NAME, VALUE) values 
		(
		''owbb.das'', ''S'', 0, 
		''host'', ''~ssoHost''
		)
	');

	exec('insert into owbb_preferences (PATH, LEVEL_TYPE, LEVEL_ID, NAME, VALUE) values 
		(
		''owbb.das'', ''S'', 0, 
		''port'', ''~ssoPort''
		)
	');

	exec('insert into owbb_preferences (PATH, LEVEL_TYPE, LEVEL_ID, NAME, VALUE) values 
		(
		''owbb.property'', ''S'', 0, 
		''gen_build'', ''11.2.0.1.0''
		)
	');

	if owbb_mode.ISCLIENT = true then
		l_id := owbb_api_administration.register_repository(
			p_name=>owbb_api_administration.schema,
			p_dblink_name=>'%host', 	--owbb_api_administration.localhost,
			p_description=>null
			); 
	end if;
end;

end;
