create or replace package owbb_api_administration is

	TNSNAME varchar2(10) := 'TNSNAME';
	SUCCESS varchar2(10) := 'SUCCESS';
	ERROR varchar2(10) := 'ERROR';
	USERTYPE varchar2(10) := 'USER';
	GROUPTYPE varchar2(10) := 'GROUP';
	PORTALUSER varchar2(10) := 'PORTAL';
	PORTALADMINGROUP varchar2(128) := 'PORTAL_ADMINISTRATORS';
 
	function repository_version(p_dblink in varchar2  := null) return varchar2;

      function localhost return varchar2;
      function is_client return varchar2;

	function register_repository
	(
		p_name in varchar2,
		p_dblink_name in varchar2 := null,
		p_description in varchar2 := null,
		p_commit in boolean := true
	) 
	return number;
  		
	function modify_repository
	(
		p_repository_id in number,
		p_name in varchar2,
		p_dblink_name in varchar2,
		p_description in varchar2,
		p_commit in boolean := true
	)
	return varchar2;
  
	procedure unregister_repository
	(
		p_repository_id in number,
		p_commit in boolean := true
	);
	
	procedure grant_repository_to_user
	(
		p_repository_id in number,
		p_user_name in varchar2,
		p_commit in boolean := true
	);

	procedure revoke_repository_from_user
	(
		p_repository_id in number,
		p_user_id in number,
		p_commit in boolean := true
	);

	procedure grant_repository_to_group
	(
		p_repository_id in number,
		p_group_name in varchar2,
		p_commit in boolean := true
	);

	procedure revoke_repository_from_group
	(
		p_repository_id in number,
		p_group_id in number,
		p_commit in boolean := true
	);
	
	procedure grant_role_to_user
	(
		p_role_name in varchar2,
		p_user_name in varchar2,
		p_commit in boolean := true
	);

	procedure revoke_role_from_user
	(
		p_role_name in varchar2,
		p_user_id in number,
		p_commit in boolean := true
	);
	
	procedure grant_portlet_to_user
	(
		p_portlet_name in varchar2,
		p_user_name in varchar2,
		p_commit in boolean := true
	);
	
	procedure revoke_portlet_from_user
	(
		p_portlet_name in varchar2,
		p_user_id in number,
		p_commit in boolean := true
	);
	
	procedure grant_role_to_group
	(
		p_role_name in varchar2,
		p_group_name in varchar2,
		p_commit in boolean := true
	);	

	procedure revoke_role_from_group
	(
		p_role_name in varchar2,
		p_group_id in number,
		p_commit in boolean := true
	);
	
	procedure grant_portlet_to_group
	(
		p_portlet_name in varchar2,
		p_group_name in varchar2,
		p_commit in boolean := true
	);
	
	procedure revoke_portlet_from_group
	(
		p_portlet_name in varchar2,
		p_group_id in number,
		p_commit in boolean := true
	);

	function application_type(
		p_dblink in varchar2 := null, 
		p_log_error in boolean := false, 
		p_source in varchar2 := null
	) 
	return varchar2;

	function application_type_nls_id(
		p_dblink in varchar2 := null, 
		p_log_error in boolean := false, 
		p_source in varchar2 := null
	) 
	return varchar2;

	function view_version(
		p_dblink in varchar2 := null, 
		p_log_error in boolean := false, 
		p_source in varchar2 := null
	) 
	return varchar2;

	function status(
		p_dblink in varchar2 := null, 
		p_log_error in boolean := true, 
		p_source in varchar2 := null
	) 
	return varchar2;

	function sql_error(
		p_dblink in varchar2 := null
	) 
	return varchar2;

	function is_existing_dblink(
		p_dblink in varchar2
	)
	return number;

	function create_dblink(
		p_dblink in varchar2, 
		p_username in varchar2, 
		p_password in varchar2, 
		p_host in varchar2, 
		p_service in varchar2,
		p_port in varchar2,
		p_protocol in varchar2
	)
	return varchar2;

	function create_dblink(
		p_dblink in varchar2, 
		p_username in varchar2, 
		p_password in varchar2, 
		p_service in varchar2
	)
	return varchar2;

	function update_dblink(
		p_dblink in varchar2 := null, 
		p_username in varchar2 := null, 
		p_password in varchar2 := null, 
		p_connect in varchar2
	)
	return varchar2;

	function drop_dblink(p_dblink in varchar2)
		return varchar2;

	function is_registered(p_dblink in varchar2) 
		return boolean;

	function is_registered2(p_dblink in varchar2) 
		return number;
    
	function is_supported(
		p_repos_type in varchar2,
		p_repos_version in varchar2
	) 
	return boolean;

	function schema 
		return varchar2;

	function is_administrator(p_user in varchar2) 
		return number;

	function can_access_repository(
		p_repository_id in number,
		p_user in varchar2
	) 
	return number;

	function can_assume_role(
		p_role in varchar2,
		p_user in varchar2
	) 
	return number;

	function get_jdbc_url(
		p_repository_id in number,
		p_jdbc_driver in varchar2 := 'thin'
    	) 
	return varchar2;

	procedure add_admin_user	(
		p_name in varchar2,
		p_commit in boolean := true
	);

	procedure add_admin_group	(
		p_name in varchar2,
		p_commit in boolean := true
	);

	procedure revoke_admin_user	(
		p_id in number,
		p_commit in boolean := true
	);

	procedure revoke_admin_group (
		p_id in number,
		p_commit in boolean := true
	);

	function user_name (p_id in number)
	return varchar2;

	function user_id (p_name in varchar2)
	return number;

	function group_name (p_id in number)
	return varchar2;

	function group_id (p_name in varchar2)
	return number;

	function das_url
	return varchar2;
  
	function is_valid_session(p_session_id in varchar2)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
  	return number;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
	function is_valid_session(p_session_id in varchar2, p_user in varchar2)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
 	return number;          

	function is_valid_name(p_name in varchar2 default null)
  	return number;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        

end owbb_api_administration;