CREATE OR REPLACE PACKAGE owbb_uix AS

  NAVIGATION  varchar2(20) :=  '10268';
  REPORT    varchar2(20) := '10295';

  TYPE OWBB_CURTYPE IS REF CURSOR;

  FUNCTION content (
    p_user in varchar2,
    p_role in varchar2 default null,
    p_repository_id in varchar2,
    p_object_id  in varchar2,
    p_object_type in varchar2,
    p_usage in varchar2 default 'CO',
    p_base_lang in varchar2 default null,
    p_mls_lang in varchar2 default null
    )
  RETURN OWBB_CURTYPE;

  FUNCTION can_access_repository (
    p_user in varchar2,
    p_repository_id in varchar2
    )
  RETURN boolean;
  
  FUNCTION get_query (
    p_role in varchar2,
    p_repository_id in varchar2,
    p_object_id  in varchar2,
    p_object_type in varchar2,
    p_usage in varchar2 default 'CO',
    p_base_lang in varchar2 default null,
    p_mls_lang in varchar2 default null
    )
  RETURN varchar2;

  function image(p_image_name in varchar2,
    p_size_category in varchar2) return varchar2;

  function image_of_location(p_location_type in varchar2,
    p_size_category in varchar2) return varchar2;

  function image_of_functionlibrary(p_functionlib_type in varchar2,
    p_size_category in varchar2) return varchar2;

  function image_of_function(p_function_type in varchar2,
    p_size_category in varchar2) return varchar2;

  function image_of_activity(p_activity_type in varchar2,
    p_size_category in varchar2) return varchar2;

  function get_string_of_location (p_location_type in varchar2)
    return varchar2;

  function get_string_of_operator (p_operator_type in varchar2)
    return varchar2;

  function get_string_of_functionlibrary (p_functionlib_type in varchar2)
    return varchar2;

  function get_string_of_function (p_function_type in varchar2)
    return varchar2;

  function get_string_of_activity (p_activity_type in varchar2)
    return varchar2;

  function get_string_of_key (p_is_primary in varchar2)
    return varchar2;

  function type_name_for(p_alias in varchar2) return varchar2;
  function type_nls_name_for(p_alias in varchar2) return varchar2;
  function get_nls_name_for(p_type in varchar2) return varchar2;
  function n(p_alias in varchar2) return varchar2;
  function l(p_alias in varchar2) return varchar2;

  --|
  --|The following APIs not yet tested
  --|
  FUNCTION MLS_DESCRIPTION(
    p_dblink in varchar2, 
    theEltId IN NUMBER, 
    theLangId IN VARCHAR2 DEFAULT NULL
    )
  RETURN VARCHAR2;

  FUNCTION MLS_NAME(
    p_dblink in varchar2, 
    theEltId IN NUMBER, 
    theLangId IN VARCHAR2 DEFAULT NULL
    )
  RETURN VARCHAR2;

/* lmm
  procedure add_navigation_favorite (
    p_repository_id in number
    ,p_role in varchar2
    ,p_user in varchar2
    ,p_type_name in varchar2
    ,p_id in number
  );
  
  procedure add_report_favorite (
    p_repository_id number
    ,p_role varchar2
    ,p_user in varchar2
    ,p_report_id number
    ,p_id number
  );

  procedure delete_navigation_favorite (
    p_favorite_id in number
    ,p_user in varchar2
  );

  procedure delete_report_favorite (
    p_favorite_id number
    ,p_user in varchar2
  );

  procedure edit_favorite (
    p_favorite_id in number
    ,p_user in varchar2
    ,p_request in varchar2
    ,p_desc in varchar2
  );
*/
--  function get_object_name(p_repository_id in number, p_role in varchar2, p_type_name in varchar2, p_id in number) return varchar2;
--  function get_favorite_type(p_favorite_id in number) return varchar2;
  
  function get_nls_language (p_vendor in varchar2 default null) return varchar2;
  function get_string (p_nls_key in varchar2) return varchar2;

  function report_type (p_object_type in varchar2) return varchar2;
  function report_category (p_object_type in varchar2) return varchar2;
    
END;

