Rem
Rem $Header: whdev/2.0/owb/shiphome/owb/misc/unregister_location.sql /main/2 2009/03/30 10:31:59 jscapicc Exp $
Rem
Rem unregister_location.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      unregister_location.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
REM----------------------------------------------------------------------------------
REM This script will unregister a location.
REM This script should be used ONLY when a location  cannot be unregistered by using
REM OWB UI or Scripting. This can happen when the Control Center/Runtime Repository
REM where this location was registered is crashed or deleted or just cannot be
REM reached any more.
REM
REM This script must be run in a Repository Owner account.
REM The name of a location will be prompted when running a script.
REM 
REM----------------------------------------------------------------------------------

set serveroutput on;
set verify off

--whenever sqlerror exit failure;


PROMPT ===========================================================================;
PROMPT WARNING:;
PROMPT This script should be used ONLY when a location cannot be unregistered by using;
PROMPT OWB UI or Scripting. This can happen when the Control Center/Runtime Repository;
PROMPT where this location was registered is crashed, or deleted, or just cannot be;
PROMPT reached any more.;
PROMPT ===========================================================================;

accept WORKSPACE_NAME CHAR PROMPT 'Enter Workspace Name: '
accept USER_NAME CHAR PROMPT 'Enter Workspace User Name: '
accept loc_name prompt 'Enter Location Name (ctrl/c to cancel): ';

  declare
    type CurType is ref cursor;
    l_cur CurType;
    l_count NUMBER;
    l_count1 NUMBER;
    l_locid NUMBER;
    l_conid NUMBER;
    v_workspace boolean;

    function getworkspace return boolean as 
      v_workspaceid number;
      begin
      select workspace_id into 
        v_workspaceid from workspace_assignment 
        where workspace_name = UPPER('&WORKSPACE_NAME') and user_name = UPPER('&USER_NAME');
      dbms_output.put_line('Select Workspace Id for workspace ' || '&WORKSPACE_NAME' || ' and user ' || '&USER_NAME');
      dbms_output.put_line('Workspace id = ' || v_workspaceid);

      owb_workspace_manager.set_workspace(v_workspaceid);
      return true;
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
          dbms_output.put_line('Workspace id not found for workspace ' || '&WORKSPACE_NAME' || ' and user ' || '&USER_NAME');
          return false;
        WHEN OTHERS THEN
          dbms_output.put_line('Other Error');
          return false;
      end;   

  begin

    v_workspace := getworkspace;
    if v_workspace = true then       
  
      select count(*) into l_count
      from ALL_IV_LOCATIONS 
      where location_name=UPPER('&loc_name');

      select count(*) into l_count1
      from WB_RTV_STORES 
      where store_name=UPPER('&loc_name');

      if l_count = 0 then
        dbms_output.put_line(' Location  &loc_name does not exist');
      elsif l_count1 <> 0 then
        dbms_output.put_line(' Location  &loc_name is registered in this repository. ');
        dbms_output.put_line(' Please use OWB Client UI or Scripting to unregister this location.');
      else
        select location_id into l_locid
        from ALL_IV_LOCATIONS 
        where location_name=UPPER('&loc_name');

        wb_env_util.unregister_location(l_locid);
  
        select count(*) into l_count
        from ALL_IV_CONNECTORS 
        where location_id = l_locid;

        if l_count = 0 then
          dbms_output.put_line(' Location is unregistered<');
        else
          open l_cur for 
            'select connector_id  from ALL_IV_CONNECTORS where location_id = '
                || l_locid;

            loop
              fetch l_cur into l_conid;
              exit when l_cur%notfound;

              wb_env_util.unregister_connector(l_conid);

            end loop;
          close l_cur;
          
          commit;
          
          dbms_output.put_line(' Location and all its connectors are unregistered');
        end if;
      end if;
    end if;

end;
/

