/***************************************************************************************************
 * Object Name     :  OWB-HTMLDB Portal Images
 * File Name       :  OWB_HTMLDB_PORTAL_IMG.sql
 * Purpose         :  SQL Script file to import OWB-HTMLDB Portal Images 
 *
 * 
 * Author Name  : Ramesh Pasula
 * Company Name : Oracle Corporation(NAIO)
 *
 * 
 * Change History
 * Version      Date                   Name                              Description of Change
 * -------      --------------------   --------------------------------- ----------------------------
 * 1.0          20-Jun-2005            Ramesh Pasula                     Original Code
 *              
 ****************************************************************************************************/
set define off
set verify off
set serveroutput on size 1000000
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin wwv_flow.g_import_in_progress := true; end; 
/
 
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to sqlplus as the owner of the flow or as the flows (internal) user.
  wwv_flow_api.set_security_group_id(p_security_group_id=>11256211008707138);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum flows version required to import this flow.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2004.07.04');
 
end;
/

prompt  Set Flow ID...
 
begin
 
   -- SET FLOW ID
   wwv_flow.g_flow_id := 125;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

---------------------------------------
prompt  ...Image Repository
set linesize 250
--
 
begin
 
    wwv_flow_image_api.remove_image(
      p_image_name   => 'tips.gif', 
      p_flow_id      => 125); 
   null;
 
end;
/

begin
    wwv_flow_image_api.g_varchar2_table(1) := '47494638396110001000B3FF00FFFFFFC0C0C0CCFFFFCCCCFFCCCCCC99CCCC9999CC6699CC66999966669933669900000000000000000000000000000021F90401000001002C000000001000100040045B30C849EB54001495101A80520947528083A128';
    wwv_flow_image_api.g_varchar2_table(2) := '07519527306C8760DDC180881362681881027140BC0A196142A039E09E504ACA62D8AD7C3B03A58ACC00082B2D45015215CC03DE85905191BF6AC986AD411212E24A75352C44A111003B00CC66FFCC66CCCC6699CC6666CC6633CC6600CC33FFCC33CCCC';
    wwv_flow_image_api.g_varchar2_table(3) := '3399CC3366CC3333CC3300CC00FFCC00CCCC0099CC0066CC0033CC000099FFFF99FFCC99FF9999FF6699FF3399FF0099CCFF99CCCC99CC9999CC6699CC3399CC009999FF9999CC9999999999669999339999009966FF9966CC9966999966669966339966';
    wwv_flow_image_api.g_varchar2_table(4) := '009933FF9933CC9933999933669933339933009900FF9900CC99009999006699003399000066FFFF66FFCC66FF9966FF6666FF3366FF0066CCFF66CCCC66CC9966CC6666CC3366CC006699FF6699CC6699996699666699336699006666FF6666CC666699';
    wwv_flow_image_api.g_varchar2_table(5) := '6666666666336666006633FF6633CC6633996633666633336633006600FF6600CC66009966006666003366000033FFFF33FFCC33FF9933FF6633FF3333FF0033CCFF33CCCC33CC9933CC6633CC3333CC003399FF3399CC33999933996633993333990033';
    wwv_flow_image_api.g_varchar2_table(6) := '66FF3366CC3366993366663366333366003333FF3333CC3333993333663333333333003300FF3300CC33009933006633003333000000FFFF00FFCC00FF9900FF6600FF3300FF0000CCFF00CCCC00CC9900CC6600CC3300CC000099FF0099CC0099990099';
    wwv_flow_image_api.g_varchar2_table(7) := '660099330099000066FF0066CC0066990066660066330066000033FF0033CC0033990033660033330033000000FF0000CC000099000066000033000000000000000000000000000000000000000000000000000000000000000000000000000000000000';
    wwv_flow_image_api.g_varchar2_table(8) := '0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002C000000001000100000087C0001081C48B0A0';
    wwv_flow_image_api.g_varchar2_table(9) := 'C1832AAA1C34A8420F2983551C9222A5272229850349E401F44405808413F3AC2018F18981812B26621C5811C093872428E6D1539094C72AA49EE0ECF89060CF9780F4E8F1D87320A9910070DA0490B2609E2702630222E1324FC197489F405D0168E5C0';
    wwv_flow_image_api.g_varchar2_table(10) := '8D1D3FBECC4315A2448A5017AA5DAB3620003B';
 
end;
/

 
declare
    l_name   varchar2(255);
    l_img_id number := null;
begin
    l_name   := 'tips.gif';
    l_img_id := wwv_flow_image_api.new_image_repository_record(
                  p_name              => l_name,
                  p_varchar2_table    => wwv_flow_image_api.g_varchar2_table,
                  p_mimetype          => 'image/gif',
                  p_flow_id           => 125,
                  p_nlang             => '0',
                  p_notes             => '');
 
end;
/

commit;
begin 
execute immediate 'alter session set nls_numeric_characters='''||wwv_flow_api.g_nls_numeric_chars||'''';
end;
/
set verify on
set feedback on
prompt  ...done
