/*=======================================================================+
 |  Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfdemos.sql
 |
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_DEMO and WF_REQDEMO
 |
 | NOTES
 | MODIFIED     10/30/97	Added create_req, submit_req, confirm_req,
 |				req_timeout, and print_error
 |				for web based demo of Requisition Approval
 |                              Workflow.
 | MODIFIED     11/10/97        Added parameter Item_Type to Submit_Req,
 |                              Req_Timeout, and Confirm_Req.
 |                              Added procedures Forward_Req, Approve_Req,
 |                              and Reject_Req to replace WF_STANDARD.NOOP
 |                              function calls in activities RECORDFORWARD,
 |                              APPROVEREQUISITION, and REJECTREQUISITION,
 |                              respectively.
 | MODIFIED     11/10/97        Removed procedure CanOwnerApprove.
 | MODIFIED     11/18/98        Added procedures CREATE_REQ_DOCUMENT and
 |                              REMINDER_REQ_DOCUMENT to support messages 
 |                              using plsql documents.
 | MODIFIED     03/12/99	Added procedure HOME, HOMEHEADER, HOMEMENU
 *=======================================================================*/

whenever sqlerror exit failure rollback;

create or replace package WF_DEMO as
/* $Header: wfdemos.sql 26.1 2002/09/17 05:44:48 rosthoma ship $ */
--
-- Procedure 
--	Home
--
-- Description		Generates Demonstration Home page.
procedure Home;

--
-- Procedure 
--	HomeHeader
--
procedure HomeHeader;

--
-- Procedure 
--	HomeMenu
--
-- Description		Generates Demonstration Home page.
-- IN
--   origin - 
-- NOTE
--   This page links to all other workflow demo interfaces.
procedure HomeMenu(
  origin in varchar2 default 'NORMAL');

end WF_DEMO;
/
show error package WF_DEMO 
/
create or replace package WF_REQDEMO as
/* $Header: wfdemos.sql 26.1 2002/09/17 05:44:48 rosthoma ship $ */
--
-- Procedure 
--	StartProcess
--
-- Description		starts the requisition approval workflow.
--
-- IN
--   RequisitionNumber	- Requisition Number from calling application
--   RequisitionDesc	- Requisition Description (user displayed key) from
--			  calling application
--   RequisitionAmount  - Requisition Amount from calling application
--   RequestorUsername  - Requisition Requestor Username from callling application
--   ProcessOwner	- Requisition process Owner Username from calling application
--   Workflowprocess    - Workflow process to run.
--	
procedure StartProcess(	RequisitionNumber	in varchar2,
			RequisitionDesc		in varchar2,
			RequisitionAmount	in number,
			RequestorUsername	in varchar2,
			ProcessOwner		in varchar2,
			WorkflowProcess		in varchar2 default null,
			Item_Type		in varchar2 default null );
--
--
-- Procedure 
--	selector
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--	
procedure Selector (	itemtype	in varchar2,
			itemkey  	in varchar2,
			actid		in number,
			funcmode	in varchar2,
			resultout	out varchar2	);
--
-- Procedure 
--	Forward_Req
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--	
procedure Forward_Req (	itemtype	in varchar2,
			itemkey  	in varchar2,
			actid		in number,
			funcmode	in varchar2,
			resultout	out varchar2	);
--
-- Procedure 
--	Approve_Req
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--	
procedure Approve_Req (	itemtype	in varchar2,
			itemkey  	in varchar2,
			actid		in number,
			funcmode	in varchar2,
			resultout	out varchar2	);
--
-- Procedure 
--	Reject_Req
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--	
procedure Reject_Req (	itemtype	in varchar2,
			itemkey  	in varchar2,
			actid		in number,
			funcmode	in varchar2,
			resultout	out varchar2	);
--
-- SelectApprover
--   Select an employees manager
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   actid     - The function activity(instance id).
--   funcmode  - Run/Cancel
-- OUT
--   Resultout    - 'COMPLETE:T' if employee has a manager
--		  - 'COMPLETE:F' if employee does not have a manager
-- 
-- USED BY ACTIVITIES
--  <ITEM_TYPE> <ACTIVITY>
--   WFDEMO     SELECTAPPROVER
--
procedure SelectApprover (	itemtype	in varchar2,
				itemkey  	in varchar2,
				actid		in number,
				funcmode	in varchar2,
				resultout	out varchar2	);
--
-- VerifyAuthority
--   Check the spending limit of an employee
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   actid     - The function activity(instance id).
--   funcmode  - Run/Cancel
-- OUT
--   Resultout    
--	'COMPLETE:Y' - If RequisitionAmount <= SpendingLimit
--	'COMPLETE:N' - If RequisitionAmount >  SpendingLimit
--
-- USED BY ACTIVITIES
--  <ITEM_TYPE> <ACTIVITY>
--   WFDEMO     VERIFYAUTHORITY
--
procedure VerifyAuthority ( 	itemtype	in varchar2,
				itemkey  	in varchar2,
				actid		in number,
				funcmode	in varchar2,
				resultout	out varchar2	);
--
-- Print_Error
--   Generate a web page displaying error stack
-- IN 
-- OUT
-- USED BY
--
procedure Print_Error;
--
-- Create_Req
--   Generate the input web page for Create Requisition.
-- IN
-- OUT
-- USED BY
--
procedure Create_Req;
--
-- Submit_Req
--   Given the input from the Create_Req web page, call StartProcess 
-- IN
--   RequisitionNumber	- Requisition Number from calling application
--   RequisitionDesc	- Requisition Descriptor (user displayed key) from
--			  calling application
--   RequisitionAmount  - Requisition Amount from calling application
--   RequestorUsername  - Requisition Requestor Username from callling application
--   ProcessOwner	- Requisition process Owner Username from calling application
--   Item_Type		- Item Type from calling application
-- OUT
-- USED BY
--
procedure Submit_Req(	RequisitionNumber	in varchar2,
			RequisitionDescription	in varchar2,
			RequisitionAmount	in varchar2,
			RequestorUsername	in varchar2,
			ProcessOwner		in varchar2,
			Item_Type		in varchar2 default null);
--
-- Req_TimeOut
--   Given the requisition number from Confirm_Req display page, 
--   call wf_engine.ProcessTimeout for item type 'WFDEMO'
--   then call confirm_req to redisplay page
-- IN
--   RequisitionNumber	- Requisition Number from calling application
--   Item_Type		- Item Type from calling application
-- OUT
-- USED BY
--
procedure Req_TimeOut(	RequisitionNumber	in varchar2,
			Item_Type		in varchar2 default null);

--
-- Confirm_Req
--   Generate the confirm requisition web page.
-- IN
--   RequisitionNumber	- Requisition Number from calling application
--   Item_Type		- Item Type from calling application
-- OUT
-- USED BY
--
procedure Confirm_Req(	RequisitionNumber	in varchar2,
			Item_Type		in varchar2 default null);

/** Bug 2336498 
    The requisition PL/SQL document is now replaced by the 
    message functions WF_NOTIFICATION(ATTRS,<attr1>,...)
    and WF_NOTIFICATION(HISTORY).
--
-- Create_Req_Document
--   Generate the Requisition Document for display in messages, either
--   text or html
-- IN
--   document_id	- Item Key
--   display_type	- either 'text/plain' or 'text/html'
--   document		- document buffer 
--   document_type	- type of document buffer created, either 'text/plain'
--			  or 'text/html'
-- OUT
-- USED BY
--
procedure Create_Req_Document(document_id	in	varchar2,
				display_type	in	varchar2,
				document	in out	varchar2,
				document_type	in out	varchar2);
**/
--
-- Reminder_Req_Document
--   Generate the Reminder Requisition Document for display in messages, either
--   text or html
-- IN
--   document_id	- Item Key
--   display_type	- either 'text/plain' or 'text/html'
--   document		- document buffer 
--   document_type	- type of document buffer created, either 'text/plain'
--			  or 'text/html'
-- OUT
-- USED BY
--
procedure Reminder_Req_Document(document_id	in	varchar2,
				display_type	in	varchar2,
				document	in out	varchar2,
				document_type	in out	varchar2);
end WF_REQDEMO;
/
show error package WF_REQDEMO 
exit;
