/*=======================================================================+
 |  Copyright (c) 1998 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | $Header: wfdemous.sql 26.0 2003/04/25 18:11:51 varrajar noship $
 | FILENAME
 |   wfdemous.sql
 |
 | DESCRIPTION
 |      Create Workflow Demonstration users for SSO
 | USAGE
 |      sqlplus <WF_ACCNT>/<WF_ACCNT PWD> @wfdemou <WF_ACCNT>
 =======================================================================*/

WHENEVER SQLERROR CONTINUE

set serveroutput on size 100000

declare
  type namesTyp is table of varchar2(320);
  names namesTyp;
  isuser number;
begin
  names := namesTyp('SPIERSON','BLEWIS','KWALKER','CDOUGLAS',
           'WFADMIN','SYSADMIN');
  for i in 1..names.LAST loop
    select count(1) into isuser
      from wf_users
     where name = names(i);

    if (isuser = 0) then
      wf_directory.createadhocuser(
          name                    => names(i),
          display_name            => names(i),
          language                => 'AMERICAN',
          territory               => 'AMERICA',
          description             => 'Demo User: ' || names(i),
          notification_preference => 'MAILHTML',
          email_address           => names(i)||'@demo.com',
          fax                     => null,
          status                  => 'ACTIVE',
          expiration_date         => null);

    else
      -- User already exists Ignore..
      null;
    end if;
  end loop;
end;
/

--duplicate users may exist as database users and rows
--in wf_local_users. Check and delete from wf_local_users.
-- WF_LOCAL_USERS has been made obsolete from 2.6.3 onwards
-- Replaced by wf_local_roles where user_flag = 'Y'
delete from &1..wf_local_roles lu
where 2 = (select count(*) from &1..wf_users
           where name = lu.name)
and lu.user_flag = 'Y';


commit;
exit;

