/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfevdems.sql
 |
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_EVENTDEMO
 |
 | NOTES
 | MODIFIED     10/10/00 Created 
 *=======================================================================*/

/* $Header: wfevdems.sql 26.5 2001/05/01 19:16:26 kma ship $ */

whenever sqlerror exit failure rollback;

create or replace package WF_EVENTDEMO as
--
-- Procedure
--      Print Error
--
procedure Print_Error;
--
-- Procedure 
-- 	 Create Order	
--
-- Description		Creates a Purchase Order.
procedure Create_Order;
--
-- Procedure
--      Submit PO 
--
-- Description		Inserts PO into table ands raises business event
procedure SubmitPO (PO_Number           in varchar2,
                        Requestor       in varchar2,
                        Item_Number     in varchar2,
                        Item_Description in varchar2,
                        Total_Cost      in number,
                        Delivery_Date   in varchar2);
--
-- Procedure 
--      Confirm Order 
--
-- Description          Confirm Order 
procedure Confirm_Order(
 P_PO_NUMBER	in	varchar2);
--
-- Procedure
--	Process Order
--
-- Description		Process Order
procedure Process_Order (
  P_ITEM_KEY	in	varchar2);
--
-- Procedure
--      Track Order
--
-- Description          Track Order
procedure Track_Order;
--
-- Function 
-- 	Generate XML	
--
-- Description		Generates XML PO
function GenerateXML (
  P_EVENT_NAME     in    varchar2,
  P_EVENT_KEY      in    varchar2
) return clob;
--
-- Procedure
--      FindSupplier 
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--
procedure FindSupplier ( itemtype        in varchar2,
                        itemkey         in varchar2,
                        actid           in number,
                        funcmode        in varchar2,
                        resultout       out varchar2    );
--
-- Procedure
--      StockCheck 
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--
procedure StockCheck ( itemtype        in varchar2,
                        itemkey         in varchar2,
                        actid           in number,
                        funcmode        in varchar2,
                        resultout       out varchar2    );
--
-- Procedure
--      CheckShipping 
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--
procedure CheckShipping ( itemtype        in varchar2,
                        itemkey         in varchar2,
                        actid           in number,
                        funcmode        in varchar2,
                        resultout       out varchar2    );
--
-- Procedure
--      CreateInvoice 
--
-- Description
--
-- IN
--   itemtype  - A valid item type from (WF_ITEM_TYPES table).
--   itemkey   - A string generated from the application object's primary key.
--   itemuserkey - A string generated from the application object user-friendly
--               primary key.
--   actid     - The function activity(instance id).
--   processowner - The username owner for this item instance.
--   funcmode  - Run/Cancel
-- OUT
--   resultout    - Name of workflow process to run
--
procedure CreateInvoice ( itemtype        in varchar2,
                        itemkey         in varchar2,
                        actid           in number,
                        funcmode        in varchar2,
                        resultout       out varchar2    );
--
-- Function 
--      DeriveCorrelationID 
--
-- Description
--   This rule function derives the correlation id from the event
--   It will be associated with a subscription that fires before
--   the main subscription which will be launch or continue a
--   a workflow process.
--
-- IN/OUT
--   p_subscription in raw
--   p_event        in out wf_event_t
     
-- RETURN
--   varchar2    - SUCCESS, WARNING, ERROR
--
function DeriveCorrelationID (p_subscription_guid in     raw,
                              p_event             in out wf_event_t) 
return varchar2;

end WF_EVENTDEMO;
/
show error package WF_EVENTDEMO 
commit;
exit;
