/*=======================================================================+
 |  Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfrund.sql
 |
 | DESCRIPTION
 |   Annonymous plsql block to start Requisition demonstration workflow
 |
 |   The procedure runs the workflow demonstration as defined in the files 
 |
 |   	- demo/wfdemo.wft
 | 	- demo/wfdemos.sql
 |	- demo/wfdemoc.sql
 | 	- demo/wfdemob.sql
 |   
 |    The demonstration workflow is designed to work with directory 
 |    services implementations that include wf_local_users and wf_local_roles
 |
 |	- sql/wfdircsv.sql
 |	- sql/wfdirouv.sql
 |	- sql/wfdirhrv.sql
 |
 | USAGE sqlplus @wfrund.sql <Req_number> <Req_Description> <Req_amount> <Req_Requestor> <Req_Owner> <Workflow_Process> <Item type>
 |
 | 	Req_Number  	- Text String to uniquely identify the Requisition (used as item_key)
 |      Req_Description - Text String to uniquely identify the Requisition (used as user item key)
 |      Req_Amount  	- Amount of Requisition
 |      Req_Requestor 	- One of the following users from wf_users 
 |				- BLEWIS
 |   				- CDOUGLAS
 |				- KWALKER
 |				- SPIERSON
 |      Req_Owner 	- One of the following users from wf_users 
 |				- BLEWIS
 |   				- CDOUGLAS
 |				- KWALKER
 |				- SPIERSON
 |                        (used as process owner)
 |      Workflow_Porcess - Workflow process to run. 
 |				- REQUISITION_APPROVAL If null the selector function will determine the process name
 |
 |      Item_type        - Item Type of workflow
 |			        - If null default = WFDEMO
 |
 | NOTES
 |       Calling application must commit
 |
 | MODIFIED    (MM/DD/YY)
 *=======================================================================*/

/* $Header: wfrund.sql 26.0 2000/07/05 22:08:40 kma ship $ */

--
set verify off
set echo off
--
define Req_Number = '&1'
define Req_Description = '&2'
define Req_Amount = &3
define Req_Requestor = '&4'
define Req_Owner = '&5'
define Workflow_Process = '&6'
define item_type = '&7'
--
begin
	wf_reqdemo.startprocess('&Req_Number','&Req_Description',&Req_Amount,upper('&Req_Requestor'),upper('&Req_Owner'),upper('&Workflow_Process'),upper('&item_type'));
end;
/


