create or replace package wmp_administration_pages as

  LOAD_PREF_FROM_FILE boolean := FALSE;

	type option_array is table of varchar2(2000) index by binary_integer;

	function url(p_call in varchar2) return varchar2;
	function hlink(p_text in varchar2, p_call in varchar2) return varchar2;
	function user_name_from_id(p_user_id in number) return varchar2;
	procedure redirect_to_main(p_request in varchar2, p_call in varchar2:=null);

	procedure show(
		p_error in varchar2 := null, 
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		is_full_page in varchar2 := null
		);

	procedure purge_users(
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);
	   
	procedure show_resource(
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);
	
	procedure show_register_repository(
		p_error in varchar2 := null, 
		p_name in varchar2 := null, 
		p_hostname in varchar2 := null, 
		p_sid in varchar2 := null, 
		p_repos_schema in varchar2 := null, 
		p_dblink in varchar2 := null, 
		p_description in varchar2 := null, 
		p_request in varchar2 := null, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);
	 
	procedure show_access_repository(
		p_repository_id in varchar2, 
		p_error in varchar2 := null,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);
	 
	procedure show_edit_repository(
		p_repository_id in varchar2, 
		p_error in varchar2 := null, 
		p_request in varchar2 := null, 
		p_link_from in number := null,
		p_is_portlet in varchar2 := null,
	  	p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure unregister_repository(
		p_repository_id in varchar2, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure show_access_role(
		p_role_name in varchar2, 
		p_error in varchar2 := null,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);

	procedure show_register_report(
		p_error in varchar2 := null, 
		p_display_name in varchar2 := null, 
		p_type_name in varchar2 := null, 
		p_helper in varchar2 := null, 
		p_repository_id in varchar2 := null, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	        p_reference_path in varchar2 := null
		);
	        
	procedure show_edit_report(
		p_report_id in varchar2, 
		p_error in varchar2 := null, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure show_report_roles(
		p_report_id in varchar2, 
		p_error in varchar2 := null, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure unregister_report(
		p_report_id in varchar2, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure edit_report(
		p_request in varchar2, 
		p_report_id in varchar2 := null, 
		p_display_name in varchar2 := null, 
		p_type_name in varchar2 := null, 
		p_helper in varchar2 := null, 
		p_repository_id in varchar2 := null,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	        p_reference_path in varchar2 := null, 
		p_call_from_register in number := null 
		);

	procedure show_access_portlet(
		p_portlet_name in varchar2, 
		p_error in varchar2 := null,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);
		
	procedure edit_repository(
		p_request in varchar2, 
		p_repository_id in varchar2 := null, 
		p_name in varchar2 := null, 
		p_hostname in varchar2 := null, 
		p_sid in varchar2 := null, 
		p_repos_schema in varchar2 := null, 
		p_dblink in varchar2 := null, 
		p_description in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
	        p_reference_path in varchar2 := null , 
		p_link_from in number := null
		);

	procedure grant_access(
		p_request in varchar2, 
		p_type in varchar2, 
		p_ident in varchar2, 
		p_user_name in varchar2, 
		p_group_name in varchar2,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);
	 
	 procedure grant_access(
		p_request in varchar2, 
		p_type in varchar2, 
		p_ident in varchar2, 
		p_user_type in varchar2,
		p_user_guid in varchar2,
		p_user_name in varchar2, 
		p_group_name in varchar2,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);

	procedure revoke_access(
		p_request in varchar2, 
		p_type in varchar2, 
		p_ident in varchar2, 
		p_grantee_id in varchar2,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);

	procedure close_report_roles(
		p_report_id in number, 
		p_request in varchar2 := null,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);

	procedure add_report_role(
		p_report_id in number, 
		p_role_name in varchar2,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);

	procedure remove_report_role(
		p_report_id in number, 
		p_role_name in varchar2,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
	 	p_reference_path in varchar2 := null
		);
/*
	procedure save_nls_options (
		p_request in varchar2, 
		p_language in varchar2 := null, 
		p_level in varchar2 := null,	
		p_save_as_default_nls in varchar2 := null
		);	
*/
	procedure show_dblinks(
		p_error in varchar2 := null, 
		p_repository_id in varchar2 := null, 
		p_link_from in number := null,
		p_is_portlet in varchar2 := null,
	  	p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure show_edit_dblink(
		p_action in varchar2 := wmp_api_administration.EDIT, 
		p_error in varchar2 := null, 
		p_dblink in varchar2 := null, 
		p_username in varchar2 := null, 
		p_password in varchar2 := null, 
		p_connect_type in varchar2 := null, 
		p_tnsname in varchar2 := null, 
		p_host in varchar2 := null, 
		p_service in varchar2 := null, 
		p_port in varchar2 := null, 
		p_protocol in varchar2 := null, 
		p_owner in varchar2 := null, 
		p_connect in varchar2 := null, 
		p_link_from in number := null, 
		p_repository_id in varchar2 := null,
		p_is_portlet in varchar2 := null,
	  	p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure edit_dblink(
		p_action in varchar2 := wmp_api_administration.EDIT, 
		p_request in varchar2 := null, 
		p_error in varchar2 := null, 
		p_dblink in varchar2 := null, 
		p_username in varchar2 := null, 
		p_password in varchar2 := null, 
		p_connect_type in varchar2 := null, 
		p_tnsname in varchar2 := null, 
		p_host in varchar2 := null, 
		p_service in varchar2 := null, 
		p_port in varchar2 := null, 
		p_protocol in varchar2 := null, 
		p_connect in varchar2 := null, 
		p_link_from in number := null, 
		p_repository_id in varchar2 := null,
		p_is_portlet in varchar2 := null,
	  	p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	function group_name_from_id(p_group_id in number) return varchar2;

  procedure show_preference(p_is_portlet in varchar2 := null, 
                            p_back_url in varchar2 := null,
                            p_reference_path in varchar2 := null,
                            p_request in varchar2 := null);

  procedure save_preference(p_is_portlet in varchar2 := null, 
                            p_back_url in varchar2 := null,
                            p_reference_path in varchar2 := null);

  /*
  procedure save_preference_action(p_is_portlet in varchar2 := null, 
                            p_back_url in varchar2 := null,
                            p_reference_path in varchar2 := null);
                            */

  procedure load_preference(
                            p_error in varchar2 := null, 
                            p_is_portlet in varchar2 := null, 
                            p_back_url in varchar2 := null,
                            p_reference_path in varchar2 := null);

  /*
  procedure get_preference(p_is_portlet in varchar2 := null, 
                           p_back_url in varchar2 := null,
                           p_reference_path in varchar2 := null);
                           */

  procedure show_save_preference_status(
                           p_request in varchar2 := null,
                           p_filename in varchar2 := null,
                           p_error in varchar2 := null,
                           p_is_portlet in varchar2 := null, 
                           p_back_url in varchar2 := null,
                           p_reference_path in varchar2 := null);

  procedure show_load_preference_status(
                           p_request in varchar2 := null,
                           p_filename in varchar2 := null,
                           p_file in varchar2 := null,
		                        p_repos_schema in varchar2 := null, 
                        		p_password in varchar2 := null, 
                        		p_hostname in varchar2 := null, 
                        		p_port in varchar2 := null, 
                        		p_sid in varchar2 := null, 
                        		p_connect_type in varchar2 := null, 
                            -- not used
                            p_repository_id in varchar2 := null, 
                            p_name in varchar2 := null,
                            p_dblink in varchar2 := null, 
                            p_description in varchar2 := null,
                            -- not used (end)
                            p_link_from in number := -1,
                           p_error in varchar2 := null,
                           p_is_portlet in varchar2 := null, 
                           p_back_url in varchar2 := null,
                           p_reference_path in varchar2 := null);

	procedure show_refresh_options(
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure save_refresh_options (
		p_request in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null,
		p_reference_path in varchar2 := null,
		p_option in wmp_administration_pages.option_array 
		);

end wmp_administration_pages;