create or replace package wmp_load_preferences as

  SUCCESS number := 0;
  ERROR number := 1;
  WARNING number := 2;
  DBLINK varchar2(32) := 'OWB_TMPDATA012_FROM_SCHEMA';
--  DEBUG boolean := FALSE;

  procedure add_group_portlets ( p_group_name in varchar2 := null,
                                 p_portlet_name in varchar2 := null);

  procedure add_group_repositories ( p_group_name in varchar2 := null,
                                     p_repository_name in varchar2 := null);
                                     
  procedure add_group_roles ( p_group_name in varchar2 := null,
                              p_role_name in varchar2 := null);

  procedure add_links ( p_link_name in varchar2 := null,
                        p_user_name in varchar2 := null,
                        p_repository_name in varchar2 := null,
                        p_role_name in varchar2 := null,
                        p_type_name in varchar2 := null,
                        p_object_id in number := null,
                        p_url in varchar2 := null,
                        p_is_type_wise in varchar2 := null,
                        p_is_public in varchar2 := null,
                        p_is_action in varchar2 := null,
                        p_is_owb_object in varchar2 := null,
                        p_description in varchar2 := null );

 procedure add_navigation_favorites ( p_user_name in varchar2 := null,
                                        p_repository_name in varchar2 := null,
                                        p_role_name in varchar2 := null,
                                        p_type_name in varchar2 := null,
                                        p_object_id in number := null,
                                        p_description in varchar2 := null );

  procedure add_reports (p_report_id in number := null,
                          p_type_name in varchar2 := null,
                          p_report_display_name in varchar2 := null,
                          p_repository_version in varchar2 := null,
                          p_report_helper in varchar2 := null,
                          p_report_category in varchar2 := null,
                          p_dblink_name in varchar2 := null,
                          p_alt_dispatch in varchar2 := null );


  procedure add_report_favorites (  p_user_name in varchar2 := null,
                                    p_repository_name in varchar2 := null,
                                    p_role_name in varchar2 := null,
                                    p_report_display_name in varchar2 := null,
                                    p_report_helper in varchar2 := null,
                                    p_report_category in varchar2 := null,
                                    p_type_name in varchar2 := null,
                                    p_object_id in number := null,
                                    p_description in varchar2 := null );


  procedure add_repositories (  
                                p_name in varchar2 := null,
                                p_host_name in varchar2 := null,
                                p_dblink_name in varchar2 := null,
                                p_db_sid in varchar2 := null,
                                p_repos_schema in varchar2 := null,
                                p_description in varchar2 := null );

  /*
  procedure add_roles ( p_role_name in varchar2,
                        p_display_name in varchar2,
                        p_parent_role_name in varchar2 );
  */

  procedure add_role_reports (  p_report_id in number := null,
                                p_type_name in varchar2 := null,
                                p_report_display_name in varchar2 := null,
                                p_role_name in varchar2 := null );
                                
  procedure add_user_portlets ( p_user_name in varchar2 := null,
                                p_portlet_name in varchar2 := null );

  procedure add_user_repositories ( p_user_name in varchar2 := null,
                                    p_repository_name in varchar2 := null );

  procedure add_user_roles (  p_user_name in varchar2 := null,
                              p_role_name in varchar2 := null );

  function no_errors return boolean;
  procedure check_role (p_role_name in varchar2 := null);

  procedure check_group ( p_group_name in varchar2 := null );

  procedure check_user ( p_user_name in varchar2 := null );

  procedure check_dblink ( p_dblink_name in varchar2 := null,
                           p_schema in varchar2 := null,
                           p_host_info in varchar2 := null );

  procedure create_dblink ( p_schema in varchar2 := null,
                            p_password in varchar2 := null,
                            p_host in varchar2 := null,
                            p_port in varchar2 := null,
                            p_sid in varchar2 := null,
                            p_error in out varchar2  );

  procedure drop_dblink;
  procedure start_migration(p_language in varchar2 := null);
  procedure end_migration;

end wmp_load_preferences;