begin 
declare
clob_loc clob;
buf raw(32767);
begin

    --WM Text Documents of type .xsl

  --text document 'us/impact.xsl'

insert into wmp_text_docs (doc_name, doc_value,language) values ('impact.xsl', empty_clob() ,'us');
select doc_value into clob_loc from wmp_text_docs where doc_name = 'impact.xsl';
dbms_lob.open(clob_loc, dbms_lob.lob_readwrite);
dbms_lob.writeappend(clob_loc, 23, '<?xml version=''1.0''?>  ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 80, '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 56, '<xsl:output method="html" indent="no" encoding="UTF8"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 55, '<xsl:variable name="desc" select="TREE/@Description"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 71, '<xsl:variable name="prefixURL" select="substring-before($desc, ''|'')"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 92, '<xsl:variable name="reposID" select="substring-after(substring-before($desc, ''||''), ''|'')"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 71, '<xsl:variable name="imageSize" select="substring-after($desc, ''||'')"/> ');
dbms_lob.writeappend(clob_loc, 15, '               ');
dbms_lob.writeappend(clob_loc, 28, '<xsl:template match="TREE"> ');
dbms_lob.writeappend(clob_loc, 30, '	  <xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 52, '	    <xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 15, '		<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 48, '			<xsl:when test="count(DEPENDENCY/OBJECT)=1"> ');
dbms_lob.writeappend(clob_loc, 46, '				<xsl:call-template name="addFirstObject"> ');
dbms_lob.writeappend(clob_loc, 66, '				   <xsl:with-param name="object" select="DEPENDENCY/OBJECT"/> ');
dbms_lob.writeappend(clob_loc, 45, '				   <xsl:with-param name="N" select="1"/> ');
dbms_lob.writeappend(clob_loc, 37, '                </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 15, '			</xsl:when> ');
dbms_lob.writeappend(clob_loc, 19, '			<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 66, '				<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 29, '					<xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '						<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 64, '							<xsl:attribute name="class">PortletText2</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 74, '							<xsl:text>This object doesn''t have impact dependencies.</xsl:text> ');
dbms_lob.writeappend(clob_loc, 21, '						</xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '			</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 16, '		</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 65, '		<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 21, '      </xsl:element> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 37, '<xsl:template name="addFirstObject"> ');
dbms_lob.writeappend(clob_loc, 28, '	<xsl:param name="object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 63, '	<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 27, '	  <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '	    <xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 52, '		   <xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 57, '		   <xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 57, '		   <xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 32, '		     <xsl:element name="td"/> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 220, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/PARENT/TYPE, ''&#38;p_id='', $object/PARENT/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '					<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '					    <xsl:value-of select="$object/PARENT/NAME"/> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 32, '		     <xsl:element name="td"/> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '				 <xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 271, '					<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_report_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=4&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID, ''&#38;p_helper=wmp_rh_impact_analysis&#38;p_category=Impact_Diagram'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '				 </xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 32, '				   <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 106, '						<xsl:value-of select="concat($prefixURL, ''lia_client.show_binary_doc?p_doc_name='', $object/TYPE)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="alt"> ');
dbms_lob.writeappend(clob_loc, 115, '						<xsl:value-of select="concat(substring-before($object/PARENT/DESCRIPTION, ''.''), ''.'', $object/DESCRIPTION)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 21, '				  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 28, '			 <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 55, '				<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '				<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 107, '						<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '				<xsl:attribute name="valign">up</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 206, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '					<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 47, '					    <xsl:value-of select="$object/NAME"/> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 17, '		</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '	  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 46, '	  <xsl:call-template name="addDependencies"> ');
dbms_lob.writeappend(clob_loc, 51, '		<xsl:with-param name="object" select="$object"/> ');
dbms_lob.writeappend(clob_loc, 41, '		<xsl:with-param name="N" select="$N"/> ');
dbms_lob.writeappend(clob_loc, 24, '	  </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 39, '<xsl:template name="addSameRowObject"> ');
dbms_lob.writeappend(clob_loc, 28, '	<xsl:param name="object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="S"/> ');
dbms_lob.writeappend(clob_loc, 27, '	  <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 52, '	  <xsl:attribute name="align">left</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 16, '	  <xsl:choose> ');
dbms_lob.writeappend(clob_loc, 33, '		<xsl:when test="position()=1"> ');
dbms_lob.writeappend(clob_loc, 55, '			<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 14, '		</xsl:when> ');
dbms_lob.writeappend(clob_loc, 18, '		<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 16, '			<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 40, '				<xsl:when test="position()=last()"> ');
dbms_lob.writeappend(clob_loc, 54, '					<xsl:attribute name="valign">top</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 16, '				</xsl:when> ');
dbms_lob.writeappend(clob_loc, 20, '				<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 57, '					<xsl:attribute name="valign">middle</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 21, '				</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 17, '			</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '		</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 18, '	   </xsl:choose> ');
dbms_lob.writeappend(clob_loc, 4, '	   ');
dbms_lob.writeappend(clob_loc, 29, '		<xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 49, '		<xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 28, '			 <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 58, '			    <xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 33, '				<xsl:if test="$S=3 or $S=2"> ');
dbms_lob.writeappend(clob_loc, 33, '				    <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 33, '						<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 108, '							<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '						<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 36, '						<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 14, '				</xsl:if> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 220, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/PARENT/TYPE, ''&#38;p_id='', $object/PARENT/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '					<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '					    <xsl:value-of select="$object/PARENT/NAME"/> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 55, '				<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '				<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 21, '				    <xsl:choose> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=0"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector3.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '						</xsl:when> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=1"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector4.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '						</xsl:when> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=2"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector8.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '						</xsl:when> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=3"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector5.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '						</xsl:when>	 ');
dbms_lob.writeappend(clob_loc, 22, '				    </xsl:choose> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '				 <xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 271, '					<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_report_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=4&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID, ''&#38;p_helper=wmp_rh_impact_analysis&#38;p_category=Impact_Diagram'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '				 </xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '				  <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 106, '						<xsl:value-of select="concat($prefixURL, ''lia_client.show_binary_doc?p_doc_name='', $object/TYPE)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="alt"> ');
dbms_lob.writeappend(clob_loc, 115, '						<xsl:value-of select="concat(substring-before($object/PARENT/DESCRIPTION, ''.''), ''.'', $object/DESCRIPTION)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 21, '				  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 55, '				<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 17, '				<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 37, '				  <xsl:when test="$S=1 or $S=2"> ');
dbms_lob.writeappend(clob_loc, 33, '				    <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 33, '						<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 108, '							<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '						<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 39, '					    <xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '				  </xsl:when> ');
dbms_lob.writeappend(clob_loc, 22, '				  <xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 30, '					<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 33, '						<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 108, '							<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '						<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 36, '						<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '				  </xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 18, '				</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '				<xsl:attribute name="valign">up</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 206, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '				    <xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '						<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 53, '							<xsl:when test="count($object/DEPENDENCY)=1"> ');
dbms_lob.writeappend(clob_loc, 21, '								<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 62, '									<xsl:when test="$object/DEPENDENCY/@Complete=''YES''"> ');
dbms_lob.writeappend(clob_loc, 48, '										<xsl:value-of select="$object/NAME"/> ');
dbms_lob.writeappend(clob_loc, 21, '									</xsl:when> ');
dbms_lob.writeappend(clob_loc, 25, '									<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 61, '										<xsl:value-of select="concat($object/NAME, ''*'')"/> ');
dbms_lob.writeappend(clob_loc, 26, '									</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 22, '								</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '							</xsl:when> ');
dbms_lob.writeappend(clob_loc, 23, '							<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 46, '								<xsl:value-of select="$object/NAME"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:choose>			 ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 17, '		</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '	  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 46, '	  <xsl:call-template name="addDependencies"> ');
dbms_lob.writeappend(clob_loc, 51, '		<xsl:with-param name="object" select="$object"/> ');
dbms_lob.writeappend(clob_loc, 41, '		<xsl:with-param name="N" select="$N"/> ');
dbms_lob.writeappend(clob_loc, 24, '	  </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 44, '<xsl:template name="addFollowingEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 33, '    <xsl:param name="m_object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="M"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 22, '	<xsl:if test="$N>0"> ');
dbms_lob.writeappend(clob_loc, 26, '		<xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 79, '			<xsl:variable name="last" select="count($m_object[$M]/DEPENDENCY/OBJECT)"/> ');
dbms_lob.writeappend(clob_loc, 59, '			<xsl:for-each select="$m_object[$M]/DEPENDENCY/OBJECT"> ');
dbms_lob.writeappend(clob_loc, 43, '				<xsl:if test="ID=$m_object[$M +1]/ID"> ');
dbms_lob.writeappend(clob_loc, 56, '					<xsl:variable name="current" select="position()"/> ');
dbms_lob.writeappend(clob_loc, 37, '					<xsl:if test="$last!=$current"> ');
dbms_lob.writeappend(clob_loc, 35, '					   <xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 55, '					   <xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 60, '					   <xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 60, '					   <xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					     <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 33, '						   <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '							<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 35, '								<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 110, '									<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 37, '								<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 38, '								<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 22, '							</xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '						   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '						  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 32, '						  <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 33, '						   <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '							<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 35, '								<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 110, '									<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 37, '								<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 38, '								<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 22, '							</xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '						   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '						  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 32, '						  <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 33, '						   <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '							<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 35, '								<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 110, '									<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 37, '								<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 38, '								<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 22, '							</xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '						   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '						  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '					   </xsl:element>	 ');
dbms_lob.writeappend(clob_loc, 15, '					</xsl:if> ');
dbms_lob.writeappend(clob_loc, 14, '				</xsl:if> ');
dbms_lob.writeappend(clob_loc, 19, '			</xsl:for-each> ');
dbms_lob.writeappend(clob_loc, 17, '		</xsl:element> ');
dbms_lob.writeappend(clob_loc, 51, '		<xsl:call-template name="addFollowingEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 59, '		    <xsl:with-param name="m_object" select="$m_object"/> ');
dbms_lob.writeappend(clob_loc, 45, '			<xsl:with-param name="N" select="$N -1"/> ');
dbms_lob.writeappend(clob_loc, 45, '			<xsl:with-param name="M" select="$M +1"/> ');
dbms_lob.writeappend(clob_loc, 23, '		</xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 11, '	</xsl:if> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 40, '<xsl:template name="addFirstEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 33, '    <xsl:param name="m_object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 26, '	<xsl:element name="td"/> ');
dbms_lob.writeappend(clob_loc, 50, '	<xsl:call-template name="addFollowingEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 55, '		<xsl:with-param name="m_object" select="$m_object"/> ');
dbms_lob.writeappend(clob_loc, 44, '		<xsl:with-param name="N" select="$N -1"/> ');
dbms_lob.writeappend(clob_loc, 40, '		<xsl:with-param name="M" select="1"/> ');
dbms_lob.writeappend(clob_loc, 22, '	</xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 38, '<xsl:template name="addDependencies"> ');
dbms_lob.writeappend(clob_loc, 28, '	<xsl:param name="object"/> ');
dbms_lob.writeappend(clob_loc, 26, '	<xsl:param name="N"/>    ');
dbms_lob.writeappend(clob_loc, 14, '	<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 56, '	  <xsl:when test="count($object/DEPENDENCY/OBJECT)=0"> ');
dbms_lob.writeappend(clob_loc, 34, '         <xsl:element name="td">  ');
dbms_lob.writeappend(clob_loc, 54, '			<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '			<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 28, '			<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 107, '						<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '			</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '		 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 66, '		 <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 71, '         <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 15, '	  </xsl:when> ');
dbms_lob.writeappend(clob_loc, 19, '	  <xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 52, '		<xsl:for-each select="$object/DEPENDENCY/OBJECT"> ');
dbms_lob.writeappend(clob_loc, 4, '			 ');
dbms_lob.writeappend(clob_loc, 35, '			<xsl:if test="position() != 1"> ');
dbms_lob.writeappend(clob_loc, 48, '			<xsl:call-template name="addFirstEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 79, '			    <xsl:with-param name="m_object" select="ancestor::*[name()=''OBJECT'']"/> ');
dbms_lob.writeappend(clob_loc, 43, '				<xsl:with-param name="N" select="$N"/> ');
dbms_lob.writeappend(clob_loc, 24, '			</xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 13, '			</xsl:if> ');
dbms_lob.writeappend(clob_loc, 4, '			 ');
dbms_lob.writeappend(clob_loc, 32, '			<xsl:variable name="status"> ');
dbms_lob.writeappend(clob_loc, 17, '				<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 68, '					<xsl:when test="count(../../DEPENDENCY/OBJECT)=1">0</xsl:when> ');
dbms_lob.writeappend(clob_loc, 21, '					<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 21, '					   <xsl:choose> ');
dbms_lob.writeappend(clob_loc, 50, '						 <xsl:when test="position()=1">1</xsl:when> ');
dbms_lob.writeappend(clob_loc, 55, '						 <xsl:when test="position()=last()">3</xsl:when> ');
dbms_lob.writeappend(clob_loc, 40, '						 <xsl:otherwise>2</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 22, '					   </xsl:choose> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 18, '				</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '			</xsl:variable> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 50, '		    <xsl:call-template name="addSameRowObject"> ');
dbms_lob.writeappend(clob_loc, 48, '			  <xsl:with-param name="object" select="."/> ');
dbms_lob.writeappend(clob_loc, 46, '			  <xsl:with-param name="N" select="$N+1"/> ');
dbms_lob.writeappend(clob_loc, 49, '			  <xsl:with-param name="S" select="$status"/> ');
dbms_lob.writeappend(clob_loc, 27, '		    </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 21, '	    </xsl:for-each> ');
dbms_lob.writeappend(clob_loc, 20, '	  </xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 15, '	</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 18, '</xsl:stylesheet> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.close(clob_loc);

  --text document 'us/lineage.xsl'

insert into wmp_text_docs (doc_name, doc_value,language) values ('lineage.xsl', empty_clob() ,'us');
select doc_value into clob_loc from wmp_text_docs where doc_name = 'lineage.xsl';
dbms_lob.open(clob_loc, dbms_lob.lob_readwrite);
dbms_lob.writeappend(clob_loc, 23, '<?xml version=''1.0''?>  ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 80, '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 56, '<xsl:output method="html" indent="no" encoding="UTF8"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 55, '<xsl:variable name="desc" select="TREE/@Description"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 71, '<xsl:variable name="prefixURL" select="substring-before($desc, ''|'')"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 92, '<xsl:variable name="reposID" select="substring-after(substring-before($desc, ''||''), ''|'')"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 71, '<xsl:variable name="imageSize" select="substring-after($desc, ''||'')"/> ');
dbms_lob.writeappend(clob_loc, 15, '               ');
dbms_lob.writeappend(clob_loc, 28, '<xsl:template match="TREE"> ');
dbms_lob.writeappend(clob_loc, 30, '	  <xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 52, '	    <xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '	    <xsl:choose> ');
dbms_lob.writeappend(clob_loc, 48, '			<xsl:when test="count(DEPENDENCY/OBJECT)=1"> ');
dbms_lob.writeappend(clob_loc, 46, '				<xsl:call-template name="addFirstObject"> ');
dbms_lob.writeappend(clob_loc, 66, '				   <xsl:with-param name="object" select="DEPENDENCY/OBJECT"/> ');
dbms_lob.writeappend(clob_loc, 45, '				   <xsl:with-param name="N" select="1"/> ');
dbms_lob.writeappend(clob_loc, 37, '                </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 15, '			</xsl:when> ');
dbms_lob.writeappend(clob_loc, 19, '			<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 66, '				<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 29, '					<xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '						<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 64, '							<xsl:attribute name="class">PortletText2</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 75, '							<xsl:text>This object doesn''t have lineage dependencies.</xsl:text> ');
dbms_lob.writeappend(clob_loc, 21, '						</xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '			</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 16, '		</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 65, '		<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 21, '      </xsl:element> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 37, '<xsl:template name="addFirstObject"> ');
dbms_lob.writeappend(clob_loc, 28, '	<xsl:param name="object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 63, '	<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 27, '	  <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '	    <xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 52, '		   <xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 57, '		   <xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 57, '		   <xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 220, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/PARENT/TYPE, ''&#38;p_id='', $object/PARENT/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '					<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '					    <xsl:value-of select="$object/PARENT/NAME"/> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '			 <xsl:element name="td"/> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '				 <xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 264, '					<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_report_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=4&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID, ''&#38;p_helper=wmp_rh_lineage&#38;p_category=Lineage_Diagram'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '				 </xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '				  <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 106, '						<xsl:value-of select="concat($prefixURL, ''lia_client.show_binary_doc?p_doc_name='', $object/TYPE)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="alt"> ');
dbms_lob.writeappend(clob_loc, 115, '						<xsl:value-of select="concat(substring-before($object/PARENT/DESCRIPTION, ''.''), ''.'', $object/DESCRIPTION)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 21, '				  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '			 <xsl:element name="td"/> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '				<xsl:attribute name="valign">up</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 206, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '					<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 47, '					    <xsl:value-of select="$object/NAME"/> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 28, '			 <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 55, '				<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '				<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 107, '						<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 17, '		</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '	  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 46, '	  <xsl:call-template name="addDependencies"> ');
dbms_lob.writeappend(clob_loc, 51, '		<xsl:with-param name="object" select="$object"/> ');
dbms_lob.writeappend(clob_loc, 41, '		<xsl:with-param name="N" select="$N"/> ');
dbms_lob.writeappend(clob_loc, 24, '	  </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 39, '<xsl:template name="addSameRowObject"> ');
dbms_lob.writeappend(clob_loc, 28, '	<xsl:param name="object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="S"/> ');
dbms_lob.writeappend(clob_loc, 27, '	  <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 53, '	  <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 16, '	  <xsl:choose> ');
dbms_lob.writeappend(clob_loc, 33, '		<xsl:when test="position()=1"> ');
dbms_lob.writeappend(clob_loc, 55, '			<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 14, '		</xsl:when> ');
dbms_lob.writeappend(clob_loc, 18, '		<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 16, '			<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 40, '				<xsl:when test="position()=last()"> ');
dbms_lob.writeappend(clob_loc, 54, '					<xsl:attribute name="valign">top</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 16, '				</xsl:when> ');
dbms_lob.writeappend(clob_loc, 20, '				<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 57, '					<xsl:attribute name="valign">middle</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 21, '				</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 17, '			</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '		</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 18, '	   </xsl:choose> ');
dbms_lob.writeappend(clob_loc, 4, '	   ');
dbms_lob.writeappend(clob_loc, 29, '		<xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 49, '		<xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '		<xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 220, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/PARENT/TYPE, ''&#38;p_id='', $object/PARENT/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '					<xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 54, '					    <xsl:value-of select="$object/PARENT/NAME"/> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 28, '			 <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 58, '			    <xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 33, '				<xsl:if test="$S=3 or $S=2"> ');
dbms_lob.writeappend(clob_loc, 33, '				    <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 33, '						<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 108, '							<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '						<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 36, '						<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 14, '				</xsl:if> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '				 <xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 264, '					<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_report_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=4&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID, ''&#38;p_helper=wmp_rh_lineage&#38;p_category=Lineage_Diagram'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '				 </xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 31, '				  <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 106, '						<xsl:value-of select="concat($prefixURL, ''lia_client.show_binary_doc?p_doc_name='', $object/TYPE)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="alt"> ');
dbms_lob.writeappend(clob_loc, 115, '						<xsl:value-of select="concat(substring-before($object/PARENT/DESCRIPTION, ''.''), ''.'', $object/DESCRIPTION)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 21, '				  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 28, '			 <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 55, '				<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 29, '				<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 21, '				    <xsl:choose> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=0"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector3.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '						</xsl:when> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=1"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector4.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '						</xsl:when> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=2"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector7.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '						</xsl:when> ');
dbms_lob.writeappend(clob_loc, 29, '						<xsl:when test="$S=3"> ');
dbms_lob.writeappend(clob_loc, 34, '							<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 109, '								<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector6.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '						</xsl:when>	 ');
dbms_lob.writeappend(clob_loc, 22, '				    </xsl:choose> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 29, '		   <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 31, '		     <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 57, '			    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '				<xsl:attribute name="valign">up</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 27, '				<xsl:element name="a"> ');
dbms_lob.writeappend(clob_loc, 33, '					<xsl:attribute name="href"> ');
dbms_lob.writeappend(clob_loc, 206, '						<xsl:value-of select="concat($prefixURL, ''wmp_pages.show_navigation_page?p_repository_id='', $reposID, ''&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name='', $object/TYPE, ''&#38;p_id='', $object/ID)"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '				    <xsl:element name="font"> ');
dbms_lob.writeappend(clob_loc, 63, '						<xsl:attribute name="class">PortletText3</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 19, '						<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 53, '							<xsl:when test="count($object/DEPENDENCY)=1"> ');
dbms_lob.writeappend(clob_loc, 21, '								<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 62, '									<xsl:when test="$object/DEPENDENCY/@Complete=''YES''"> ');
dbms_lob.writeappend(clob_loc, 48, '										<xsl:value-of select="$object/NAME"/> ');
dbms_lob.writeappend(clob_loc, 21, '									</xsl:when> ');
dbms_lob.writeappend(clob_loc, 25, '									<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 61, '										<xsl:value-of select="concat($object/NAME, ''*'')"/> ');
dbms_lob.writeappend(clob_loc, 26, '									</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 22, '								</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '							</xsl:when> ');
dbms_lob.writeappend(clob_loc, 23, '							<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 46, '								<xsl:value-of select="$object/NAME"/> ');
dbms_lob.writeappend(clob_loc, 24, '							</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:choose>			 ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '				</xsl:element> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 28, '			 <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 55, '				<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 56, '				<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 17, '				<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 37, '				  <xsl:when test="$S=1 or $S=2"> ');
dbms_lob.writeappend(clob_loc, 33, '				    <xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 33, '						<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 108, '							<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '						<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 39, '					    <xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 20, '					</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '				  </xsl:when> ');
dbms_lob.writeappend(clob_loc, 22, '				  <xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 30, '					<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 33, '						<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 108, '							<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '						<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 36, '						<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 43, '							<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 23, '						</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 53, '						<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 23, '				    </xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '				  </xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 18, '				</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '			 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 20, '		   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 17, '		</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '	  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 46, '	  <xsl:call-template name="addDependencies"> ');
dbms_lob.writeappend(clob_loc, 51, '		<xsl:with-param name="object" select="$object"/> ');
dbms_lob.writeappend(clob_loc, 41, '		<xsl:with-param name="N" select="$N"/> ');
dbms_lob.writeappend(clob_loc, 24, '	  </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 44, '<xsl:template name="addFollowingEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 33, '    <xsl:param name="m_object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="M"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 22, '	<xsl:if test="$N>0"> ');
dbms_lob.writeappend(clob_loc, 26, '		<xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 56, '		    <xsl:attribute name="align">right</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 79, '			<xsl:variable name="last" select="count($m_object[$M]/DEPENDENCY/OBJECT)"/> ');
dbms_lob.writeappend(clob_loc, 59, '			<xsl:for-each select="$m_object[$M]/DEPENDENCY/OBJECT"> ');
dbms_lob.writeappend(clob_loc, 43, '				<xsl:if test="ID=$m_object[$M +1]/ID"> ');
dbms_lob.writeappend(clob_loc, 56, '					<xsl:variable name="current" select="position()"/> ');
dbms_lob.writeappend(clob_loc, 37, '					<xsl:if test="$last!=$current"> ');
dbms_lob.writeappend(clob_loc, 35, '					   <xsl:element name="table"> ');
dbms_lob.writeappend(clob_loc, 55, '					   <xsl:attribute name="border">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 60, '					   <xsl:attribute name="cellspacing">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 60, '					   <xsl:attribute name="cellpadding">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					     <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 33, '						   <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '							<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 35, '								<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 110, '									<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 37, '								<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 38, '								<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 22, '							</xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '						   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '						  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 32, '						  <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 33, '						   <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '							<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 35, '								<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 110, '									<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 37, '								<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 38, '								<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 22, '							</xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '						   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '						  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 32, '						  <xsl:element name="tr"> ');
dbms_lob.writeappend(clob_loc, 33, '						   <xsl:element name="td"> ');
dbms_lob.writeappend(clob_loc, 32, '							<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 35, '								<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 110, '									<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 37, '								<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 38, '								<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 45, '									<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 25, '								</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '								<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 22, '							</xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '						   </xsl:element> ');
dbms_lob.writeappend(clob_loc, 23, '						  </xsl:element> ');
dbms_lob.writeappend(clob_loc, 24, '					   </xsl:element>	 ');
dbms_lob.writeappend(clob_loc, 15, '					</xsl:if> ');
dbms_lob.writeappend(clob_loc, 14, '				</xsl:if> ');
dbms_lob.writeappend(clob_loc, 19, '			</xsl:for-each> ');
dbms_lob.writeappend(clob_loc, 17, '		</xsl:element> ');
dbms_lob.writeappend(clob_loc, 51, '		<xsl:call-template name="addFollowingEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 59, '		    <xsl:with-param name="m_object" select="$m_object"/> ');
dbms_lob.writeappend(clob_loc, 45, '			<xsl:with-param name="N" select="$N -1"/> ');
dbms_lob.writeappend(clob_loc, 45, '			<xsl:with-param name="M" select="$M +1"/> ');
dbms_lob.writeappend(clob_loc, 23, '		</xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 11, '	</xsl:if> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 40, '<xsl:template name="addFirstEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 33, '    <xsl:param name="m_object"/> ');
dbms_lob.writeappend(clob_loc, 23, '	<xsl:param name="N"/> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 26, '	<xsl:element name="td"/> ');
dbms_lob.writeappend(clob_loc, 50, '	<xsl:call-template name="addFollowingEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 55, '		<xsl:with-param name="m_object" select="$m_object"/> ');
dbms_lob.writeappend(clob_loc, 44, '		<xsl:with-param name="N" select="$N -1"/> ');
dbms_lob.writeappend(clob_loc, 40, '		<xsl:with-param name="M" select="1"/> ');
dbms_lob.writeappend(clob_loc, 22, '	</xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 38, '<xsl:template name="addDependencies"> ');
dbms_lob.writeappend(clob_loc, 28, '	<xsl:param name="object"/> ');
dbms_lob.writeappend(clob_loc, 26, '	<xsl:param name="N"/>    ');
dbms_lob.writeappend(clob_loc, 14, '	<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 56, '	  <xsl:when test="count($object/DEPENDENCY/OBJECT)=0"> ');
dbms_lob.writeappend(clob_loc, 31, '	     <xsl:element name="td">  ');
dbms_lob.writeappend(clob_loc, 54, '			<xsl:attribute name="align">center</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 55, '			<xsl:attribute name="valign">bottom</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 28, '			<xsl:element name="img"> ');
dbms_lob.writeappend(clob_loc, 32, '					<xsl:attribute name="src"> ');
dbms_lob.writeappend(clob_loc, 107, '						<xsl:value-of select="concat($prefixURL, ''wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif'')"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 34, '					<xsl:attribute name="width"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 35, '					<xsl:attribute name="height"> ');
dbms_lob.writeappend(clob_loc, 42, '						<xsl:value-of select="$imageSize"/> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="hspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 52, '					<xsl:attribute name="vspace">0</xsl:attribute> ');
dbms_lob.writeappend(clob_loc, 18, '			</xsl:element> ');
dbms_lob.writeappend(clob_loc, 18, '		 </xsl:element> ');
dbms_lob.writeappend(clob_loc, 66, '		 <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 71, '         <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text> ');
dbms_lob.writeappend(clob_loc, 15, '	  </xsl:when> ');
dbms_lob.writeappend(clob_loc, 19, '	  <xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 52, '		<xsl:for-each select="$object/DEPENDENCY/OBJECT"> ');
dbms_lob.writeappend(clob_loc, 4, '			 ');
dbms_lob.writeappend(clob_loc, 35, '			<xsl:if test="position() != 1"> ');
dbms_lob.writeappend(clob_loc, 48, '			<xsl:call-template name="addFirstEmptyCell"> ');
dbms_lob.writeappend(clob_loc, 79, '			    <xsl:with-param name="m_object" select="ancestor::*[name()=''OBJECT'']"/> ');
dbms_lob.writeappend(clob_loc, 43, '				<xsl:with-param name="N" select="$N"/> ');
dbms_lob.writeappend(clob_loc, 24, '			</xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 13, '			</xsl:if> ');
dbms_lob.writeappend(clob_loc, 4, '			 ');
dbms_lob.writeappend(clob_loc, 32, '			<xsl:variable name="status"> ');
dbms_lob.writeappend(clob_loc, 17, '				<xsl:choose> ');
dbms_lob.writeappend(clob_loc, 68, '					<xsl:when test="count(../../DEPENDENCY/OBJECT)=1">0</xsl:when> ');
dbms_lob.writeappend(clob_loc, 21, '					<xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 21, '					   <xsl:choose> ');
dbms_lob.writeappend(clob_loc, 50, '						 <xsl:when test="position()=1">1</xsl:when> ');
dbms_lob.writeappend(clob_loc, 55, '						 <xsl:when test="position()=last()">3</xsl:when> ');
dbms_lob.writeappend(clob_loc, 40, '						 <xsl:otherwise>2</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 22, '					   </xsl:choose> ');
dbms_lob.writeappend(clob_loc, 22, '					</xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 18, '				</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 19, '			</xsl:variable> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 50, '		    <xsl:call-template name="addSameRowObject"> ');
dbms_lob.writeappend(clob_loc, 48, '			  <xsl:with-param name="object" select="."/> ');
dbms_lob.writeappend(clob_loc, 46, '			  <xsl:with-param name="N" select="$N+1"/> ');
dbms_lob.writeappend(clob_loc, 49, '			  <xsl:with-param name="S" select="$status"/> ');
dbms_lob.writeappend(clob_loc, 27, '		    </xsl:call-template> ');
dbms_lob.writeappend(clob_loc, 21, '	    </xsl:for-each> ');
dbms_lob.writeappend(clob_loc, 20, '	  </xsl:otherwise> ');
dbms_lob.writeappend(clob_loc, 15, '	</xsl:choose> ');
dbms_lob.writeappend(clob_loc, 16, '</xsl:template> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.writeappend(clob_loc, 18, '</xsl:stylesheet> ');
dbms_lob.writeappend(clob_loc, 1, ' ');
dbms_lob.close(clob_loc);

end; 
end;
