
begin

declare
 TYPE it_128 is table of varchar(128) index by binary_integer;
 TYPE it_64 is table of varchar(64) index by binary_integer;
 TYPE it_1 is table of number(1) index by binary_integer;
 
 cg_gk it_128;
 cg_fn it_64;
 cg_in it_64;
 cg_gt it_1;
 cg_pk it_128;
 cg_lan it_64;
 cg_types it_128;
 cp_pk  it_128;
 cp_pn it_64;
 cp_lan it_64;
 cp_val it_128;
 cp_gk  it_128;
 cg_index it_64;
 cp_index it_64;
 
 cg_i number := 0;
 cp_i number := 0;

 procedure add_cg (
 	g_gk in varchar2,
 	g_fn in varchar2,
 	g_in in varchar2,
 	g_gt in number,
 	g_pk in varchar2,
 	g_lan in varchar2,
 	g_types in varchar2,
        g_key in varchar2
  ) 
  is
  	l_gk varchar2(128) := g_gk;
  	l_fn varchar2(64) := g_fn;
  	l_gt number(1) := g_gt;
  	l_lan varchar2(64) := g_lan;
  	l_types varchar2(128) := g_types;
  begin
  	if l_gk is null then
  		 l_gk := 'A';
        end if;
        if l_fn is null then 
       		l_fn := 'A';
       	end if;
       	if l_gt is null then
       		l_gt := 0;
       	end if;
       	if l_lan is null then
       		l_lan := 'en';
       	end if;
       	if l_types is null then
       		l_types := 'A';
       	end if;
       	
       	cg_i := cg_i +1;
       	cg_gk(cg_i) := l_gk;
  	cg_fn(cg_i) := l_fn;
  	cg_in(cg_i) := g_in;
  	cg_gt(cg_i) := l_gt;
  	cg_pk(cg_i) := g_pk;
  	cg_lan(cg_i) := l_lan;
  	cg_types(cg_i) := l_types;
        
       
	cg_index(cg_i) := g_key;

  end;

  procedure add_cp (
  	p_pk in varchar2,
  	p_pn in varchar2,
  	p_gk in varchar2,
  	p_lan in varchar2,
  	p_val in varchar2,
	p_key in varchar2
  )
  is
  	l_pk varchar2(128) := p_pk;
  	l_pn varchar2(64) := p_pn;
  	l_gk varchar2(128) := p_gk;
  	l_lan varchar2(64) := p_lan;
  	l_val varchar2(128) := p_val;
  begin
  	if l_pk	is null then
  		l_pk := 'A';
  	end if;
  	if l_pn	is null then
  		l_pn := 'A';
  	end if;
  	if l_gk	is null then
  		l_gk := 'A';
  	end if;
  	if l_lan is null then
  		l_lan := 'en';
  	end if;
  	if l_val is null then
  		l_val := 'A';
  	end if;

  	cp_i := cp_i + 1;
  	cp_pk(cp_i) := l_pk;
  	cp_pn(cp_i) := l_pn;
  	cp_gk(cp_i) := l_gk;
  	cp_lan(cp_i) := l_lan;
        cp_val(cp_i) := l_val;
	cp_index(cp_i) := p_key;

  end;




begin




-- File /owb/oracle/wh/service/impl/integrator/xml/files/81b2.xml
 add_cg('ORACLE8.1',
                   	'Oracle 8.1 Instance',
  		   	'Application',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPInstalledModule,CMPWBDataWarehouse',
  		   	'12007'
  		   	);
  add_cg('8i.TABLES',
                   	'Tables',
  		   	'Table',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12002'
  		   	);
  add_cg('8i.COLUMNS',
 		   	'Columns',
  		   	'Column',
  		   	'3',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPItem,CMPRelationalDBItem',
  		   	'12008'
  		   	);
  add_cg('8i.COLUMNS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.COLUMNS',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12009'
  		   	);
  add_cg('8i.TABLE.CONSTRAINT',
 		   	'Constraints',
  		   	'Constraint',
  		   	'3',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPUniqueKey,CMPForeignKey,CMPWBCheckConstraint',
  		   	'12010'
  		   	);
  add_cg('8i.TABLE.CONSTRAINT.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.TABLE.CONSTRAINT',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12009'
  		   	);
  add_cp('8i.TABLE.CONSTRAINT.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.TABLE.CONSTRAINT.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.TABLE.CONSTRAINT.CREATIONMETHOD',
 		   	'Creation Method',
  		   	null,
  		   	'4',
  		   	'8i.TABLE.CONSTRAINT',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12012'
  		   	);
  add_cp('8i.TABLE.CONSTRAINT.INDEXTABLESPACE',
                   	'Index Tablespace',
  		   	'8i.TABLE.CONSTRAINT.CREATIONMETHOD',
  		   	'en',
  		   	'','12013'
  		   	);
  add_cp('8i.TABLE.CONSTRAINT.USINGINDEX',
                   	'Using Index',
  		   	'8i.TABLE.CONSTRAINT.CREATIONMETHOD',
  		   	'en',
  		   	'false',
  		   	'12014'
  		   	);
  add_cg('8i.TABLES.PARTITIONING',
 		   	'Hash Partition Parameters',
  		   	null,
  		   	'4',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12015'
  		   	);
  add_cp('8i.TABLES.STOREIN',
                   	'Hash Partition Tablespace List',
  		   	'8i.TABLES.PARTITIONING',
  		   	'en',
  		   	'','12016'
  		   	);
  add_cp('8i.TABLES.HSPNUMBER',
                   	'Hash SubPartition Number',
  		   	'8i.TABLES.PARTITIONING',
  		   	'en',
  		   	'2',
  		   	'12017'
  		   	);
  add_cg('8i.PARTITIONS',
 		   	'Range Partitions',
  		   	'Partition',
  		   	'2',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12018'
  		   	);
  add_cg('8i.PARTITIONS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.PARTITIONS',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12009'
  		   	);
  add_cp('8i.PARTITIONS.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.PARTITIONS.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.PARTITIONS.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.PARTITIONS',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12019'
  		   	);
  add_cp('8i.PARTITIONS.TABLESPACE',
                   	'Tablespace',
  		   	'8i.PARTITIONS.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.PARTITIONS.PARTITIONPARAMS',
 		   	'Partition Parameters',
  		   	null,
  		   	'4',
  		   	'8i.PARTITIONS',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12021'
  		   	);
  add_cp('8i.PARTITIONS.VALLESSTHAN',
                   	'Values Less Than',
  		   	'8i.PARTITIONS.PARTITIONPARAMS',
  		   	'en',
  		   	'TO_DATE(''01-JAN-1999'', ''DD-MON-YYYY'')','12022'
  		   	);
  add_cg('8i.PARTITIONKEYS',
 		   	'Partition Keys',
  		   	'Partition Key',
  		   	'3',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPItem,CMPRelationalDBItem',
  		   	'12023'
  		   	);
  add_cg('8i.PARTITIONKEYS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.PARTITIONKEYS',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12009'
  		   	);
  add_cp('8i.PARTITIONKEYS.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.PARTITIONKEYS.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.PARTITIONKEYS.PARTKEYPARAMS',
 		   	'Partition Key Parameters',
  		   	null,
  		   	'4',
  		   	'8i.PARTITIONKEYS',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12024'
  		   	);
  add_cp('8i.PARTITIONKEYS.PARTKEYTYPE',
                   	'Type',
  		   	'8i.PARTITIONKEYS.PARTKEYPARAMS',
  		   	'en',
  		   	'RANGE','12025'
  		   	);
  add_cg('8i.INDEXES',
 		   	'Indexes',
  		   	'Index',
  		   	'2',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12026'
  		   	);
  add_cg('8i.INDEXCOLUMNS',
 		   	'Index Columns',
  		   	'Index Column',
  		   	'3',
  		   	'8i.INDEXES',
  		   	'en',
  		   	'CMPItem,CMPRelationalDBItem',
  		   	'12027'
  		   	);
  add_cg('8i.INDEXCOLUMNS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.INDEXCOLUMNS',
  		   	'en',
  		   	'',
  		   	'12009'
  		   	);
  add_cg('8i.INDEXES.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.INDEXES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12009'
  		   	);
  add_cp('8i.INDEXES.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.INDEXES.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.INDEXES.INDEXTYPEPARAMS',
 		   	'Index Type',
  		   	null,
  		   	'4',
  		   	'8i.INDEXES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12028'
  		   	);
  add_cp('8i.INDEXES.INDEXTYPE',
                   	'Index Type',
  		   	'8i.INDEXES.INDEXTYPEPARAMS',
  		   	'en',
  		   	'UNIQUE','12028'
  		   	);
  add_cp('8i.INDEXES.LOCALITY',
                   	'Local Index',
  		   	'8i.INDEXES.INDEXTYPEPARAMS',
  		   	'en',
  		   	'false',
  		   	'12029'
  		   	);
  add_cg('8i.INDEXES.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.INDEXES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12019'
  		   	);
  add_cp('8i.INDEXES.TABLESPACE',
                   	'Tablespace',
  		   	'8i.INDEXES.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.INDEXES.PARALLELISM',
 		   	'Parallel',
  		   	null,
  		   	'4',
  		   	'8i.INDEXES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12030'
  		   	);
  add_cp('8i.INDEXES.PARALLEL',
                   	'Parallel Access Mode',
  		   	'8i.INDEXES.PARALLELISM',
  		   	'en',
  		   	'PARALLEL','12031'
  		   	);
  add_cg('8i.INDEXES.PERFORMANCEPARAM',
 		   	'Performance Parameters',
  		   	null,
  		   	'4',
  		   	'8i.INDEXES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12032'
  		   	);
  add_cp('8i.INDEXES.LOGGING',
                   	'Logging Mode',
  		   	'8i.INDEXES.PERFORMANCEPARAM',
  		   	'en',
  		   	'LOGGING','12033'
  		   	);
  add_cg('8i.TABLES.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12009'
  		   	);
  add_cp('8i.TABLES.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.TABLES.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.TABLES.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12019'
  		   	);
  add_cp('8i.TABLES.TABLESPACE',
                   	'Tablespace',
  		   	'8i.TABLES.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.TABLES.PARALLELISM',
 		   	'Parallel',
  		   	null,
  		   	'4',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12030'
  		   	);
  add_cp('8i.TABLES.PARALLEL',
                   	'Parallel Access Mode',
  		   	'8i.TABLES.PARALLELISM',
  		   	'en',
  		   	'PARALLEL','12031'
  		   	);
  add_cg('8i.TABLES.PERFORMANCEPARAM',
 		   	'Performance Parameters',
  		   	null,
  		   	'4',
  		   	'8i.TABLES',
  		   	'en',
  		   	'CMPDatabaseRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12032'
  		   	);
  add_cp('8i.TABLES.LOGGING',
                   	'Logging Mode',
  		   	'8i.TABLES.PERFORMANCEPARAM',
  		   	'en',
  		   	'LOGGING','12033'
  		   	);
  add_cp('8i.TABLES.ESTIMATEPCT',
                   	'Analyze Table: Estimate Percent',
  		   	'8i.TABLES.PERFORMANCEPARAM',
  		   	'en',
  		   	'99',
  		   	'12034'
  		   	);
  add_cg('8i.ADVANCEDQUEUES',
                   	'Advanced Queues',
  		   	'Advanced Queue',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPAdvancedQueue',
  		   	'12035'
  		   	);
  add_cg('8i.ADVANCEDQUEUES.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'8i.ADVANCEDQUEUES',
  		   	'en',
  		   	'CMPAdvancedQueue',
  		   	'12036'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.MAXRETRIES',
                   	'Max Retries',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'','12037'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.RETRYDELAY',
                   	'Retry Delay',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'0','12038'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.RETENTIONTIME',
                   	'Retention Time',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'0','12039'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.DEPENDENCYTRACKING',
                   	'Dependency Tracking',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'false',
  		   	'12040'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.AUTOCOMMIT',
                   	'Auto Commit',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12041'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.ENQUEUEENABLED',
                   	'Enqueue Enabled',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12042'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.DEFAULT.DEQUEUEENABLED',
                   	'Dequeue Enabled',
  		   	'8i.ADVANCEDQUEUES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12043'
  		   	);
  add_cg('8i.ADVANCEDQUEUES.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.ADVANCEDQUEUES',
  		   	'en',
  		   	'CMPAdvancedQueue',
  		   	'12019'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.TABLESPACE',
                   	'Tablespace',
  		   	'8i.ADVANCEDQUEUES.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.ADVANCEDQUEUES.GENOPTIONS',
 		   	'Generation Options',
  		   	null,
  		   	'4',
  		   	'8i.ADVANCEDQUEUES',
  		   	'en',
  		   	'CMPAdvancedQueue',
  		   	'12044'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.GENERATEAQ',
                   	'Generate Advanced Queue',
  		   	'8i.ADVANCEDQUEUES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12045'
  		   	);
  add_cp('8i.ADVANCEDQUEUES.GENERATETEMPTABLE',
                   	'Generate Temporary Table',
  		   	'8i.ADVANCEDQUEUES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12046'
  		   	);
  add_cg('8i.STREAMSCAPTURE',
                   	'',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPStreamsCapture',
  		   	'12047'
  		   	);
  add_cg('8i.STREAMSCAPTURE.DEFAULT',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.STREAMSCAPTURE',
  		   	'en',
  		   	'CMPStreamsCapture',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.USE',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'START_SCN','12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.START_DATE',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.MAXSCN',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'2',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.MESSAGELIMIT',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'2',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.PARALLELISM',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'2',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.STARTUPSECONDS',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'2',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.TIMELIMIT',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'2',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.START_SCN',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'2',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.DEPLOYABLE',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.DISABLEONLIMIT',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.DEFAULT.WRITEALERTLOG',
                   	'',
  		   	'8i.STREAMSCAPTURE.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.STREAMSCAPTURE.STORAGESPACE',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.STREAMSCAPTURE',
  		   	'en',
  		   	'CMPStreamsCapture',
  		   	'12047'
  		   	);
  add_cp('8i.STREAMSCAPTURE.TABLESPACE',
                   	'',
  		   	'8i.STREAMSCAPTURE.STORAGESPACE',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cg('8i.QUEUETABLES',
                   	'Queue Tables',
  		   	'Queue Table',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPQueueTable',
  		   	'12048'
  		   	);
  add_cg('8i.QUEUETABLES.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'8i.QUEUETABLES',
  		   	'en',
  		   	'CMPQueueTable',
  		   	'12036'
  		   	);
  add_cp('8i.QUEUETABLES.DEFAULT.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.QUEUETABLES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.QUEUETABLES.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.QUEUETABLES',
  		   	'en',
  		   	'CMPQueueTable',
  		   	'12019'
  		   	);
  add_cp('8i.QUEUETABLES.TABLESPACE',
                   	'Tablespace',
  		   	'8i.QUEUETABLES.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.QUEUETABLES.GENOPTIONS',
 		   	'Generation Options',
  		   	null,
  		   	'4',
  		   	'8i.QUEUETABLES',
  		   	'en',
  		   	'CMPQueueTable',
  		   	'12044'
  		   	);
  add_cp('8i.QUEUETABLES.GENERATEQUEUETABLE',
                   	'Generate Queue Table',
  		   	'8i.QUEUETABLES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12049'
  		   	);
  add_cg('8i.QUEUEPROPAGATIONS',
                   	'Queue Propagations',
  		   	'Queue Propagation',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPQueuePropagation',
  		   	'12050'
  		   	);
  add_cg('8i.QUEUEPROPAGATIONS.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'8i.QUEUEPROPAGATIONS',
  		   	'en',
  		   	'CMPQueuePropagation',
  		   	'12036'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.DEFAULT.STARTTIME',
                   	'Start Time',
  		   	'8i.QUEUEPROPAGATIONS.DEFAULT',
  		   	'en',
  		   	'SYSDATE','12051'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.DEFAULT.DURATION',
                   	'Duration',
  		   	'8i.QUEUEPROPAGATIONS.DEFAULT',
  		   	'en',
  		   	'','12052'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.DEFAULT.NEXTTIME',
                   	'Next Time',
  		   	'8i.QUEUEPROPAGATIONS.DEFAULT',
  		   	'en',
  		   	'','12053'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.DEFAULT.LATENCY',
                   	'Latency',
  		   	'8i.QUEUEPROPAGATIONS.DEFAULT',
  		   	'en',
  		   	'60','12054'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.DEFAULT.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.QUEUEPROPAGATIONS.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.QUEUEPROPAGATIONS.GENOPTIONS',
 		   	'Generation Options',
  		   	null,
  		   	'4',
  		   	'8i.QUEUEPROPAGATIONS',
  		   	'en',
  		   	'CMPQueuePropagation',
  		   	'12044'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.GENERATEDATABASELINK',
                   	'Generate Database Link',
  		   	'8i.QUEUEPROPAGATIONS.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12055'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.GENERATEQUEUEPROPAGATION',
                   	'Generate Queue Propagation',
  		   	'8i.QUEUEPROPAGATIONS.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12056'
  		   	);
  add_cp('8i.QUEUEPROPAGATIONS.GENERATESCHEDULEPROPAGATION',
                   	'Generate Schedule Propagation',
  		   	'8i.QUEUEPROPAGATIONS.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12057'
  		   	);
  add_cg('8i.VIEWS',
                   	'Views',
  		   	'View',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPWBView',
  		   	'12003'
  		   	);
  add_cg('8i.VIEWS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.VIEWS',
  		   	'en',
  		   	'CMPWBView',
  		   	'12009'
  		   	);
  add_cp('8i.VIEWS.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.VIEWS.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.EXTERNALTABLES',
                   	'External Tables',
  		   	'External Table',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12058'
  		   	);
  add_cg('8i.EXTERNALTABLES.COLUMNS',
 		   	'Columns',
  		   	'Column',
  		   	'3',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPItem,CMPRelationalDBItem',
  		   	'12008'
  		   	);
  add_cg('8i.EXTERNALTABLES.COLUMNS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.EXTERNALTABLES.COLUMNS',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12009'
  		   	);
  add_cg('8i.EXTERNALTABLES.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12009'
  		   	);
  add_cp('8i.EXTERNALTABLES.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.EXTERNALTABLES.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.EXTERNALTABLES.FIELDEDITING',
 		   	'Field Editing',
  		   	null,
  		   	'4',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12059'
  		   	);
  add_cp('8i.EXTERNALTABLES.TRIM',
                   	'Trim',
  		   	'8i.EXTERNALTABLES.FIELDEDITING',
  		   	'en',
  		   	'NONE','12060'
  		   	);
  add_cp('8i.EXTERNALTABLES.MISSINGVALUESNULL',
                   	'Load Nulls when Missing Values',
  		   	'8i.EXTERNALTABLES.FIELDEDITING',
  		   	'en',
  		   	'false',
  		   	'12061'
  		   	);
  add_cg('8i.EXTERNALTABLES.DATACHARACTERISTICS',
 		   	'Data Characteristics',
  		   	null,
  		   	'4',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12062'
  		   	);
  add_cp('8i.EXTERNALTABLES.ENDIAN',
                   	'Endian',
  		   	'8i.EXTERNALTABLES.DATACHARACTERISTICS',
  		   	'en',
  		   	'PLATFORM','12063'
  		   	);
  add_cp('8i.EXTERNALTABLES.STRINGSIZESIN',
                   	'String sizes in',
  		   	'8i.EXTERNALTABLES.DATACHARACTERISTICS',
  		   	'en',
  		   	'BYTES','12064'
  		   	);
  add_cg('8i.EXTERNALTABLES.PARALLEL',
 		   	'Parallel',
  		   	null,
  		   	'4',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12030'
  		   	);
  add_cp('8i.EXTERNALTABLES.NUMBERDRIVERS',
                   	'Parallel Access Drivers',
  		   	'8i.EXTERNALTABLES.PARALLEL',
  		   	'en',
  		   	'1',
  		   	'12065'
  		   	);
  add_cp('8i.EXTERNALTABLES.PARALLELPROCESSING',
                   	'Parallel Access Mode',
  		   	'8i.EXTERNALTABLES.PARALLEL',
  		   	'en',
  		   	'false',
  		   	'12031'
  		   	);
  add_cg('8i.EXTERNALTABLES.REJECT',
 		   	'Reject',
  		   	null,
  		   	'4',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12066'
  		   	);
  add_cp('8i.EXTERNALTALBES.NUMBERREJECTS',
                   	'Number of rejects allowed',
  		   	'8i.EXTERNALTABLES.REJECT',
  		   	'en',
  		   	'0',
  		   	'12067'
  		   	);
  add_cp('8i.EXTERNALTABLES.REJECTSUNLIMITED',
                   	'Rejects are unlimited',
  		   	'8i.EXTERNALTABLES.REJECT',
  		   	'en',
  		   	'true',
  		   	'12068'
  		   	);
  add_cg('8i.DATAFILES',
 		   	'Data Files',
  		   	'Data File',
  		   	'2',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12069'
  		   	);
  add_cg('8i.DATAFILES.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'8i.DATAFILES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12036'
  		   	);
  add_cp('8i.DATAFILES.DATAFILELOC',
                   	'Data File Location',
  		   	'8i.DATAFILES.DEFAULT',
  		   	'en',
  		   	'USE_DEFAULT_LOCATION','12070'
  		   	);
  add_cp('8i.DATAFILES.DATAFILENAME',
                   	'Data File Name',
  		   	'8i.DATAFILES.DEFAULT',
  		   	'en',
  		   	'','12071'
  		   	);
  add_cg('8i.EXTERNALTABLES.ACCESSSPECIFICATION',
 		   	'Access Specification',
  		   	null,
  		   	'4',
  		   	'8i.EXTERNALTABLES',
  		   	'en',
  		   	'CMPExternalTable',
  		   	'12072'
  		   	);
  add_cp('8i.EXTERNALTABLES.BADFILELOC',
                   	'Bad file location',
  		   	'8i.EXTERNALTABLES.ACCESSSPECIFICATION',
  		   	'en',
  		   	'USE_DEFAULT_LOCATION','12073'
  		   	);
  add_cp('8i.EXTERNALTABLES.BADFILENAME',
                   	'Bad file name',
  		   	'8i.EXTERNALTABLES.ACCESSSPECIFICATION',
  		   	'en',
  		   	'','12074'
  		   	);
  add_cp('8i.EXTERNALTABLES.DISCARDFILELOC',
                   	'Discard file location',
  		   	'8i.EXTERNALTABLES.ACCESSSPECIFICATION',
  		   	'en',
  		   	'USE_DEFAULT_LOCATION','12075'
  		   	);
  add_cp('8i.EXTERNALTABLES.DISCARDFILENAME',
                   	'Discard file name',
  		   	'8i.EXTERNALTABLES.ACCESSSPECIFICATION',
  		   	'en',
  		   	'','12076'
  		   	);
  add_cp('8i.EXTERNALTABLES.LOGFILELOC',
                   	'Log file location',
  		   	'8i.EXTERNALTABLES.ACCESSSPECIFICATION',
  		   	'en',
  		   	'USE_DEFAULT_LOCATION','12077'
  		   	);
  add_cp('8i.EXTERNALTABLES.LOGFILENAME',
                   	'Log file name',
  		   	'8i.EXTERNALTABLES.ACCESSSPECIFICATION',
  		   	'en',
  		   	'','12078'
  		   	);
  add_cg('8i.MININGMODEL',
                   	'',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPDMModel',
  		   	'12047'
  		   	);
  add_cg('8i.MINING_BUILD_COLUMNS',
 		   	'',
  		   	'',
  		   	'3',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPItem,CMPRelationalDBItem',
  		   	'12047'
  		   	);
  add_cg('8i.MININGMODEL.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12009'
  		   	);
  add_cp('8i.MININGMODEL.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.MININGMODEL.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.MININGMODEL.MININGMODELPARAMS',
 		   	'Model Build Parameters',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12079'
  		   	);
  add_cp('8i.MININGMODEL.SETTINGS_TABLE_NAME',
                   	'Settings Table Name',
  		   	'8i.MININGMODEL.MININGMODELPARAMS',
  		   	'en',
  		   	'','12080'
  		   	);
  add_cp('8i.MININGMODEL.PRIORS_TABLE_NAME',
                   	'Prior Probabilties Table Name',
  		   	'8i.MININGMODEL.MININGMODELPARAMS',
  		   	'en',
  		   	'','12081'
  		   	);
  add_cg('8i.MININGMODEL.ABN',
 		   	'Adaptive Bayes Network',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12082'
  		   	);
  add_cp('8i.MININGMODEL.ABN.MODELTYPE',
                   	'Model Type',
  		   	'8i.MININGMODEL.ABN',
  		   	'en',
  		   	'ABNS_NAIVE_BAYES','12083'
  		   	);
  add_cp('8i.MININGMODEL.ABN.MAX_NB_PREDICTORS',
                   	'Max Naive Bayes Predictors',
  		   	'8i.MININGMODEL.ABN',
  		   	'en',
  		   	'10',
  		   	'12084'
  		   	);
  add_cp('8i.MININGMODEL.ABN.MAX_PREDICTORS',
                   	'Max Predictors',
  		   	'8i.MININGMODEL.ABN',
  		   	'en',
  		   	'25',
  		   	'12085'
  		   	);
  add_cp('8i.MININGMODEL.ABN.MAX_BUILD_MINUTES',
                   	'Maximum Build Time',
  		   	'8i.MININGMODEL.ABN',
  		   	'en',
  		   	'0',
  		   	'12086'
  		   	);
  add_cg('8i.MININGMODEL.NB',
 		   	'Naive Bayes',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12087'
  		   	);
  add_cp('8i.MININGMODEL.NB.SINGLETON_THRESHOLD',
                   	'Singleton Threshold',
  		   	'8i.MININGMODEL.NB',
  		   	'en',
  		   	'.01','12088'
  		   	);
  add_cp('8i.MININGMODEL.NB.PAIRWISE_THRESHOLD',
                   	'Pairwise Threshold',
  		   	'8i.MININGMODEL.NB',
  		   	'en',
  		   	'.01','12089'
  		   	);
  add_cg('8i.MININGMODEL.SVM',
 		   	'Support Vector Machines',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12090'
  		   	);
  add_cp('8i.MININGMODEL.SVM.KERNEL_FUNCTION',
                   	'Kernel Function',
  		   	'8i.MININGMODEL.SVM',
  		   	'en',
  		   	'LINEAR','12091'
  		   	);
  add_cp('8i.MININGMODEL.SVM.EPSILON',
                   	'Epsilon',
  		   	'8i.MININGMODEL.SVM',
  		   	'en',
  		   	'.1','12092'
  		   	);
  add_cp('8i.MININGMODEL.SVM.CONVTOLERANCE',
                   	'Convergence Tolerance',
  		   	'8i.MININGMODEL.SVM',
  		   	'en',
  		   	'','12093'
  		   	);
  add_cp('8i.MININGMODEL.SVM.STDDEV',
                   	'Standard Deviation',
  		   	'8i.MININGMODEL.SVM',
  		   	'en',
  		   	'','12094'
  		   	);
  add_cp('8i.MININGMODEL.SVM.CFACTOR',
                   	'Complexity Factor',
  		   	'8i.MININGMODEL.SVM',
  		   	'en',
  		   	'','12095'
  		   	);
  add_cp('8i.MININGMODEL.SVM.TARGETTYPE',
                   	'Target Type',
  		   	'8i.MININGMODEL.SVM',
  		   	'en',
  		   	'SVMS_SINGLE_TARGET','12096'
  		   	);
  add_cp('8i.MININGMODEL.SVM.KERNEL_CACHE',
                   	'Kernel Cache',
  		   	'8i.MININGMODEL.SVM',
  		   	'en',
  		   	'50000000',
  		   	'12097'
  		   	);
  add_cg('8i.MININGMODEL.NMF',
 		   	'Non-Negative Matrix Factorization',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12098'
  		   	);
  add_cp('8i.MININGMODEL.NMF.CONV_TOLERANCE',
                   	'Convergence Tolerance',
  		   	'8i.MININGMODEL.NMF',
  		   	'en',
  		   	'0.05','12093'
  		   	);
  add_cp('8i.MININGMODEL.NMF.RANDOM_SEED',
                   	'Random Seed',
  		   	'8i.MININGMODEL.NMF',
  		   	'en',
  		   	'-1','12099'
  		   	);
  add_cp('8i.MININGMODEL.NMF.STOP_CRITERIA',
                   	'Stopping Criterion',
  		   	'8i.MININGMODEL.NMF',
  		   	'en',
  		   	'ITERATE_OR_CONVERGE','12100'
  		   	);
  add_cp('8i.MININGMODEL.NMF.NUM_ITERATIONS',
                   	'Iterations',
  		   	'8i.MININGMODEL.NMF',
  		   	'en',
  		   	'50',
  		   	'12101'
  		   	);
  add_cg('8i.MININGMODEL.KMEANS',
 		   	'K-Means',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12102'
  		   	);
  add_cp('8i.MININGMODEL.KMEANS.DISTANCE',
                   	'Distance Function',
  		   	'8i.MININGMODEL.KMEANS',
  		   	'en',
  		   	'EUCLIDEAN','12103'
  		   	);
  add_cp('8i.MININGMODEL.KMEANS.CONV_TOLERANCE',
                   	'Convergence Tolerance',
  		   	'8i.MININGMODEL.KMEANS',
  		   	'en',
  		   	'0.01','12093'
  		   	);
  add_cp('8i.MININGMODEL.KMEANS.SPLIT_CRITERION',
                   	'Split Criterion',
  		   	'8i.MININGMODEL.KMEANS',
  		   	'en',
  		   	'KMNS_VARIANCE','12104'
  		   	);
  add_cp('8i.MININGMODEL.KMEANS.SCORING_GOAL',
                   	'',
  		   	'8i.MININGMODEL.KMEANS',
  		   	'en',
  		   	'ACCURACY','12047'
  		   	);
  add_cp('8i.MININGMODEL.KMEANS.ITERATIONS',
                   	'Iterations',
  		   	'8i.MININGMODEL.KMEANS',
  		   	'en',
  		   	'3',
  		   	'12101'
  		   	);
  add_cp('8i.MININGMODEL.KMEANS.BLOCK_GROWTH',
                   	'Block Growth',
  		   	'8i.MININGMODEL.KMEANS',
  		   	'en',
  		   	'2',
  		   	'12105'
  		   	);
  add_cp('8i.MININGMODEL.KMEANS.REFINE_CENTERS',
                   	'',
  		   	'8i.MININGMODEL.KMEANS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.MININGMODEL.ASSOCRULES',
 		   	'Association Rules',
  		   	null,
  		   	'4',
  		   	'8i.MININGMODEL',
  		   	'en',
  		   	'CMPDMModel',
  		   	'12106'
  		   	);
  add_cp('8i.MININGMODEL.ASSOCRULES.MIN_CONFIDENCE',
                   	'Minimum Confidence',
  		   	'8i.MININGMODEL.ASSOCRULES',
  		   	'en',
  		   	'0.1','12107'
  		   	);
  add_cp('8i.MININGMODEL.ASSOCRULES.MIN_SUPPORT',
                   	'Minimum Support',
  		   	'8i.MININGMODEL.ASSOCRULES',
  		   	'en',
  		   	'0.1','12108'
  		   	);
  add_cp('8i.MININGMODEL.ASSOCRULES.MAX_RULE_LENGTH',
                   	'Maximum Rule Length',
  		   	'8i.MININGMODEL.ASSOCRULES',
  		   	'en',
  		   	'1',
  		   	'12109'
  		   	);
  add_cg('8i.MATERIALIZEDVIEWS',
                   	'Materialized Views',
  		   	'Materialized View',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12110'
  		   	);
  add_cg('8i.MATERIALIZEDVIEWS.PARTITIONING',
 		   	'Hash Partition Parameters',
  		   	null,
  		   	'4',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12015'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.STOREIN',
                   	'Hash Partition Tablespace List',
  		   	'8i.MATERIALIZEDVIEWS.PARTITIONING',
  		   	'en',
  		   	'','12016'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.HSPNUMBER',
                   	'Hash SubPartition Number',
  		   	'8i.MATERIALIZEDVIEWS.PARTITIONING',
  		   	'en',
  		   	'2',
  		   	'12017'
  		   	);
  add_cg('8i.MVPARTITIONS',
 		   	'Range Partitions',
  		   	'Partition',
  		   	'2',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12018'
  		   	);
  add_cg('8i.MVPARTITIONS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.MVPARTITIONS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12009'
  		   	);
  add_cp('8i.MVPARTITIONS.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.MVPARTITIONS.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.MVPARTITIONS.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.MVPARTITIONS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12019'
  		   	);
  add_cp('8i.MVPARTITIONS.TABLESPACE',
                   	'Tablespace',
  		   	'8i.MVPARTITIONS.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.MVPARTITIONS.PARTITIONPARAMS',
 		   	'Partition Parameters',
  		   	null,
  		   	'4',
  		   	'8i.MVPARTITIONS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12021'
  		   	);
  add_cp('8i.MVPARTITIONS.VALLESSTHAN',
                   	'Date Less Than',
  		   	'8i.MVPARTITIONS.PARTITIONPARAMS',
  		   	'en',
  		   	'TO_DATE(''01-JAN-1999'', ''DD-MON-YYYY'')','12111'
  		   	);
  add_cg('8i.MVPARTITIONKEYS',
 		   	'Partition Keys',
  		   	'Partition Key',
  		   	'3',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPItem,CMPRelationalDBItem',
  		   	'12023'
  		   	);
  add_cg('8i.MVPARTITIONKEYS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.MVPARTITIONKEYS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12009'
  		   	);
  add_cp('8i.MVPARTITIONKEYS.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.MVPARTITIONKEYS.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.MVPARTITIONKEYS.PARTKEYPARAMS',
 		   	'Partition Key Parameters',
  		   	null,
  		   	'4',
  		   	'8i.MVPARTITIONKEYS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12024'
  		   	);
  add_cp('8i.MVPARTITIONKEYS.PARTKEYTYPE',
                   	'Type',
  		   	'8i.MVPARTITIONKEYS.PARTKEYPARAMS',
  		   	'en',
  		   	'RANGE','12025'
  		   	);
  add_cg('8i.MVINDEXES',
 		   	'Indexes',
  		   	'Index',
  		   	'2',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12026'
  		   	);
  add_cg('8i.MVINDEXCOLUMNS',
 		   	'Index Columns',
  		   	'Index Column',
  		   	'3',
  		   	'8i.MVINDEXES',
  		   	'en',
  		   	'CMPItem,CMPRelationalDBItem',
  		   	'12027'
  		   	);
  add_cg('8i.MVINDEXCOLUMNS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.MVINDEXCOLUMNS',
  		   	'en',
  		   	'',
  		   	'12009'
  		   	);
  add_cg('8i.MVINDEXES.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.MVINDEXES',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12009'
  		   	);
  add_cp('8i.MVINDEXES.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.MVINDEXES.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.MVINDEXES.INDEXTYPEPARAMS',
 		   	'Index Type',
  		   	null,
  		   	'4',
  		   	'8i.MVINDEXES',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12028'
  		   	);
  add_cp('8i.MVINDEXES.INDEXTYPE',
                   	'Index Type',
  		   	'8i.MVINDEXES.INDEXTYPEPARAMS',
  		   	'en',
  		   	'UNIQUE','12028'
  		   	);
  add_cp('8i.MVINDEXES.LOCALITY',
                   	'Local Index',
  		   	'8i.MVINDEXES.INDEXTYPEPARAMS',
  		   	'en',
  		   	'false',
  		   	'12029'
  		   	);
  add_cg('8i.MVINDEXES.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.MVINDEXES',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12019'
  		   	);
  add_cp('8i.MVINDEXES.TABLESPACE',
                   	'Tablespace',
  		   	'8i.MVINDEXES.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.MVINDEXES.PARALLELISM',
 		   	'Parallel',
  		   	null,
  		   	'4',
  		   	'8i.MVINDEXES',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12030'
  		   	);
  add_cp('8i.MVINDEXES.PARALLEL',
                   	'Parallel Access Mode',
  		   	'8i.MVINDEXES.PARALLELISM',
  		   	'en',
  		   	'PARALLEL','12031'
  		   	);
  add_cg('8i.MVINDEXES.PERFORMANCEPARAM',
 		   	'Performance Parameters',
  		   	null,
  		   	'4',
  		   	'8i.MVINDEXES',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12032'
  		   	);
  add_cp('8i.MVINDEXES.LOGGING',
                   	'Logging Mode',
  		   	'8i.MVINDEXES.PERFORMANCEPARAM',
  		   	'en',
  		   	'LOGGING','12033'
  		   	);
  add_cg('8i.MATERIALIZEDVIEWS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12009'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.MATERIALIZEDVIEWS.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.MATERIALIZEDVIEWS.STORAGESPACE',
 		   	'Storage Space',
  		   	null,
  		   	'4',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12019'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.TABLESPACE',
                   	'Tablespace',
  		   	'8i.MATERIALIZEDVIEWS.STORAGESPACE',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.MATERIALIZEDVIEWS.MVPARAMS',
 		   	'Materialized View Parameters',
  		   	null,
  		   	'4',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12112'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.BUILD',
                   	'Build',
  		   	'8i.MATERIALIZEDVIEWS.MVPARAMS',
  		   	'en',
  		   	'IMMEDIATE','12113'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.REFRESH',
                   	'Refresh',
  		   	'8i.MATERIALIZEDVIEWS.MVPARAMS',
  		   	'en',
  		   	'COMPLETE','12114'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.QUERY REWRITE',
                   	'Query Rewrite',
  		   	'8i.MATERIALIZEDVIEWS.MVPARAMS',
  		   	'en',
  		   	'ENABLE','12115'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.BASETABLES',
                   	'Base Tables',
  		   	'8i.MATERIALIZEDVIEWS.MVPARAMS',
  		   	'en',
  		   	'','12116'
  		   	);
  add_cg('8i.MATERIALIZEDVIEWS.PARALLELISM',
 		   	'Parallel',
  		   	null,
  		   	'4',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12030'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.PARALLEL',
                   	'Parallel Access Mode',
  		   	'8i.MATERIALIZEDVIEWS.PARALLELISM',
  		   	'en',
  		   	'PARALLEL','12031'
  		   	);
  add_cg('8i.MATERIALIZEDVIEWS.PERFORMANCEPARAM',
 		   	'Performance Parameters',
  		   	null,
  		   	'4',
  		   	'8i.MATERIALIZEDVIEWS',
  		   	'en',
  		   	'CMPWBMaterializedView',
  		   	'12032'
  		   	);
  add_cp('8i.MATERIALIZEDVIEWS.LOGGING',
                   	'Logging Mode',
  		   	'8i.MATERIALIZEDVIEWS.PERFORMANCEPARAM',
  		   	'en',
  		   	'LOGGING','12033'
  		   	);
  add_cg('8i.SQLCOLLECTION',
                   	'',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPSQLCollection',
  		   	'12047'
  		   	);
  add_cg('8i.SQLCOLLECTION.IDENTIFICATION',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.SQLCOLLECTION',
  		   	'en',
  		   	'CMPSQLCollection',
  		   	'12047'
  		   	);
  add_cp('8i.SQLCOLLECTION.DEPLOYABLE',
                   	'',
  		   	'8i.SQLCOLLECTION.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.OBJECTTYPE',
                   	'',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPObjectType',
  		   	'12047'
  		   	);
  add_cg('8i.OBJECTTYPE.IDENTIFICATION',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.OBJECTTYPE',
  		   	'en',
  		   	'CMPObjectType',
  		   	'12047'
  		   	);
  add_cp('8i.OBJECTTYPE.DEPLOYABLE',
                   	'',
  		   	'8i.OBJECTTYPE.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.SEQUENCE',
                   	'Sequence',
  		   	'Sequence',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPWBSequence',
  		   	'12004'
  		   	);
  add_cg('8i.SEQUENCE.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.SEQUENCE',
  		   	'en',
  		   	'CMPWBSequence',
  		   	'12009'
  		   	);
  add_cp('8i.SEQUENCE.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.SEQUENCE.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.SEQUENCE.SEQUENCEPARAMS',
 		   	'Sequence Parameters',
  		   	null,
  		   	'4',
  		   	'8i.SEQUENCE',
  		   	'en',
  		   	'CMPWBSequence',
  		   	'12117'
  		   	);
  add_cp('8i.SEQUENCE.INCREMENTBY',
                   	'Increment By',
  		   	'8i.SEQUENCE.SEQUENCEPARAMS',
  		   	'en',
  		   	'1',
  		   	'12118'
  		   	);
  add_cp('8i.SEQUENCE.STARTWITH',
                   	'Start With',
  		   	'8i.SEQUENCE.SEQUENCEPARAMS',
  		   	'en',
  		   	'1',
  		   	'12119'
  		   	);
  add_cg('8i.TRANSFORMPACKAGES',
                   	'SQL Libraries',
  		   	'Library',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPFunctionCategory',
  		   	'12120'
  		   	);
  add_cg('8i.TRANSFORMATION',
                   	'Functions',
  		   	'Function',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPFunction',
  		   	'12121'
  		   	);
  add_cg('8i.TRANSFORMATION.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.TRANSFORMATION',
  		   	'en',
  		   	'CMPFunction',
  		   	'12009'
  		   	);
  add_cp('8i.TRANSFORMATION.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.TRANSFORMATION.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.TRANSFORMATION.OPTIONS',
 		   	'Options',
  		   	null,
  		   	'4',
  		   	'8i.TRANSFORMATION',
  		   	'en',
  		   	'CMPFunction',
  		   	'12122'
  		   	);
  add_cp('8i.TRANSFORMATION.AUTHID',
                   	'AUTHID',
  		   	'8i.TRANSFORMATION.OPTIONS',
  		   	'en',
  		   	'None','12123'
  		   	);
  add_cg('8i.TRANSFORMPACKAGES.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.TRANSFORMPACKAGES',
  		   	'en',
  		   	'CMPFunctionCategory',
  		   	'12009'
  		   	);
  add_cp('8i.TRANSFORMPACKAGES.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.TRANSFORMPACKAGES.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.TRANSFORMPACKAGES.OPTIONS',
 		   	'Options',
  		   	null,
  		   	'4',
  		   	'8i.TRANSFORMPACKAGES',
  		   	'en',
  		   	'CMPFunctionCategory',
  		   	'12122'
  		   	);
  add_cp('8i.TRANSFORMPACKAGES.AUTHID',
                   	'AUTHID',
  		   	'8i.TRANSFORMPACKAGES.OPTIONS',
  		   	'en',
  		   	'None','12123'
  		   	);
  add_cg('8i.MAPPINGS',
                   	'Mappings',
  		   	'Package',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPMap',
  		   	'12124'
  		   	);
  add_cg('8i.MAPPINGS.IDENTIFICATION',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'8i.MAPPINGS',
  		   	'en',
  		   	'CMPMap',
  		   	'12036'
  		   	);
  add_cp('8i.MAPPINGS.STEPTYPE',
                   	'Step Type',
  		   	'8i.MAPPINGS.IDENTIFICATION',
  		   	'en',
  		   	'8i.MAPPINGS.UNKNOWNSTEP','12125'
  		   	);
  add_cg('8i.ORACLE8.1.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1',
  		   	'en',
  		   	'CMPInstalledModule,CMPWBDataWarehouse',
  		   	'12009'
  		   	);
  add_cp('8i.ORACLE8.1.MAINAPP',
                   	'Main Application Short Name',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'ora','12126'
  		   	);
  add_cp('8i.ORACLE8.1.SHORTNAME',
                   	'Application Short Name',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'WB','12127'
  		   	);
  add_cp('8i.ORACLE8.1.SCHEMAOWNER',
                   	'Schema Owner',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'OWB','12128'
  		   	);
  add_cp('8i.ORACLE8.1.CONNECTSTRING',
                   	'Connect String',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'','12129'
  		   	);
  add_cp('8i.ORACLE8.1.JDBCSERVER',
                   	'Remote Host Name',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'','12130'
  		   	);
  add_cp('8i.ORACLE8.1.JDBCPORT',
                   	'Port',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'','12131'
  		   	);
  add_cp('8i.ORACLE8.1.JDBCSERVICENAME',
                   	'Service Name',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'','12132'
  		   	);
  add_cp('8i.ORACLE8.1.APPTOPDIRECTORY',
                   	'Top Directory',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'..\..\codegen\','12133'
  		   	);
  add_cp('8i.ORACLE8.1.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.ORACLE8.1.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.ORACLE8.1.GENDIRECTORIES',
 		   	'Generation Target Directories',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1',
  		   	'en',
  		   	'CMPInstalledModule,CMPWBDataWarehouse',
  		   	'12134'
  		   	);
  add_cp('8i.ORACLE8.1.TCLDIRECTORY',
                   	'TCL Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'tcl\','12135'
  		   	);
  add_cp('8i.ORACLE8.1.DDLDIRECTORY',
                   	'DDL Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'ddl\','12136'
  		   	);
  add_cp('8i.ORACLE8.1.DDLEXTENSION',
                   	'DDL Extension',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'.ddl','12137'
  		   	);
  add_cp('8i.ORACLE8.1.DDLSPOOLDIRECTORY',
                   	'DDL Spool Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'ddl\log\','12138'
  		   	);
  add_cp('8i.ORACLE8.1.LIBDIRECTORY',
                   	'LIB Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'lib\','12139'
  		   	);
  add_cp('8i.ORACLE8.1.LIBEXTENSION',
                   	'LIB Extension',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'.lib','12140'
  		   	);
  add_cp('8i.ORACLE8.1.LIBSPOOLDIRECTORY',
                   	'LIB Spool Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'lib\log\','12141'
  		   	);
  add_cp('8i.ORACLE8.1.PLSDIRECTORY',
                   	'SQL Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'pls\','12142'
  		   	);
  add_cp('8i.ORACLE8.1.PLSEXTENSION',
                   	'SQL Extension',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'.pls','12143'
  		   	);
  add_cp('8i.ORACLE8.1.PLSRUNPRM',
                   	'SQL Run Parameter File',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'_run.ini','12144'
  		   	);
  add_cp('8i.ORACLE8.1.PLSSPOOLDIRECTORY',
                   	'SQL Spool Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'pls\log\','12145'
  		   	);
  add_cp('8i.ORACLE8.1.ABAPDIRECTORY',
                   	'ABAP Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'abap\','12146'
  		   	);
  add_cp('8i.ORACLE8.1.ABAPEXTENSION',
                   	'ABAP Extension',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'.abap','12147'
  		   	);
  add_cp('8i.ORACLE8.1.ABAPRUNPRM',
                   	'ABAP Run Parameter File',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'_run.ini','12148'
  		   	);
  add_cp('8i.ORACLE8.1.ABAPSPOOLDIRECTORY',
                   	'ABAP Spool Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'abap\log\','12149'
  		   	);
  add_cp('8i.ORACLE8.1.CTLDIRECTORY',
                   	'LOADER Directory',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'ctl\','12150'
  		   	);
  add_cp('8i.ORACLE8.1.CTLEXTENSION',
                   	'LOADER Extension',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'.ctl','12151'
  		   	);
  add_cp('8i.ORACLE8.1.CTLRUNPRM',
                   	'LOADER Run Parameter File',
  		   	'8i.ORACLE8.1.GENDIRECTORIES',
  		   	'en',
  		   	'_run.ini','12152'
  		   	);
  add_cg('8i.ORACLE8.1.RUNTIMEDIRECTORIES',
 		   	'Run Time Directories',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1',
  		   	'en',
  		   	'CMPInstalledModule,CMPWBDataWarehouse',
  		   	'12153'
  		   	);
  add_cp('8i.ORACLE8.1.RECEIVEDIRECTORY',
                   	'Receive Directory',
  		   	'8i.ORACLE8.1.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'receive\','12154'
  		   	);
  add_cp('8i.ORACLE8.1.INPUTDIRECTORY',
                   	'Input Directory',
  		   	'8i.ORACLE8.1.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'input\','12155'
  		   	);
  add_cp('8i.ORACLE8.1.INVALIDDIRECTORY',
                   	'Invalid Directory',
  		   	'8i.ORACLE8.1.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'invalid\','12156'
  		   	);
  add_cp('8i.ORACLE8.1.WORKDIRECTORY',
                   	'Work Directory',
  		   	'8i.ORACLE8.1.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'work\','12157'
  		   	);
  add_cp('8i.ORACLE8.1.SORTDIRECTORY',
                   	'Sort Directory',
  		   	'8i.ORACLE8.1.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'sort\','12158'
  		   	);
  add_cp('8i.ORACLE8.1.LOGDIRECTORY',
                   	'Log Directory',
  		   	'8i.ORACLE8.1.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'log\','12159'
  		   	);
  add_cp('8i.ORACLE8.1.ARCHIVEDIRECTORY',
                   	'Archive Directory',
  		   	'8i.ORACLE8.1.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'archive\','12160'
  		   	);
  add_cg('8i.ORACLE8.1.GENPREFERENCES',
 		   	'Generation Preferences',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1',
  		   	'en',
  		   	'CMPInstalledModule,CMPWBDataWarehouse',
  		   	'12161'
  		   	);
  add_cp('8i.ORACLE8.1.GENPREFCRLF',
                   	'End of Line',
  		   	'8i.ORACLE8.1.GENPREFERENCES',
  		   	'en',
  		   	'\r\n','12162'
  		   	);
  add_cg('8i.ORACLE8.1.DEPLOYMENTSYSTEMTYPE',
 		   	'Deployment System Type',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1',
  		   	'en',
  		   	'CMPInstalledModule,CMPWBDataWarehouse',
  		   	'12163'
  		   	);
  add_cp('8i.ORACLE8.1.DEPLOYMENTDBTYPE',
                   	'SQL Generation Mode',
  		   	'8i.ORACLE8.1.DEPLOYMENTSYSTEMTYPE',
  		   	'en',
  		   	'Oracle9i','12164'
  		   	);
  add_cg('8i.ORACLE8.1.DEFAULT_STORAGETABLESPACE',
 		   	'Tablespace Defaults',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1',
  		   	'en',
  		   	'CMPInstalledModule,CMPWBDataWarehouse',
  		   	'12165'
  		   	);
  add_cp('8i.ORACLE8.1.DEFAULT_INDEXTABLESPACE',
                   	'Default Index Tablespace',
  		   	'8i.ORACLE8.1.DEFAULT_STORAGETABLESPACE',
  		   	'en',
  		   	'','12166'
  		   	);
  add_cp('8i.ORACLE8.1.DEFAULT_OBJECTTABLESPACE',
                   	'Default Object Tablespace',
  		   	'8i.ORACLE8.1.DEFAULT_STORAGETABLESPACE',
  		   	'en',
  		   	'','12167'
  		   	);
  add_cg('8i.DIMENSIONS',
                   	'Dimensions',
  		   	'Dimension',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPDimension',
  		   	'12168'
  		   	);
  add_cg('8i.DIMENSIONS.SHADOWTABLES',
 		   	'Shadow Tables',
  		   	'ShadowTables',
  		   	'3',
  		   	'8i.DIMENSIONS',
  		   	'en',
  		   	'CMPRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12169'
  		   	);
  add_cg('8i.DIMENSIONS.SHADOWTABLE.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.DIMENSIONS.SHADOWTABLES',
  		   	'en',
  		   	'CMPDimension',
  		   	'12009'
  		   	);
  add_cp('8i.DIMENSIONS.SHADOWTABLE.TABLENAME',
                   	'Shadow Table Name ',
  		   	'8i.DIMENSIONS.SHADOWTABLE.IDENTIFICATION',
  		   	'en',
  		   	'','12170'
  		   	);
  add_cp('8i.DIMENSIONS.SHADOWTABLE.TABLESPACE',
                   	'Tablespace',
  		   	'8i.DIMENSIONS.SHADOWTABLE.IDENTIFICATION',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.DIMENSIONS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.DIMENSIONS',
  		   	'en',
  		   	'CMPDimension',
  		   	'12009'
  		   	);
  add_cp('8i.DIMENSIONS.DEPLOYMENT',
                   	'Deployment Options',
  		   	'8i.DIMENSIONS.IDENTIFICATION',
  		   	'en',
  		   	'Deploy All','12171'
  		   	);
  add_cp('8i.DIMENSIONS.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.DIMENSIONS.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.CHANGELOGS',
                   	'ChangeSets',
  		   	'ChangeSet',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPChangeLog',
  		   	'12172'
  		   	);
  add_cg('8i.CUBES',
                   	'Cubes',
  		   	'cube',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPCube',
  		   	'12173'
  		   	);
  add_cg('8i.CUBES.SHADOWTABLES',
 		   	'Shadow Tables',
  		   	'ShadowTables',
  		   	'3',
  		   	'8i.CUBES',
  		   	'en',
  		   	'CMPRelation,CMPWBTable,CMPRelationalDBObject',
  		   	'12169'
  		   	);
  add_cg('8i.CUBES.SHADOWTABLE.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.CUBES.SHADOWTABLES',
  		   	'en',
  		   	'CMPCube',
  		   	'12009'
  		   	);
  add_cp('8i.CUBES.SHADOWTABLE.TABLENAME',
                   	'Shadow Table Name ',
  		   	'8i.CUBES.SHADOWTABLE.IDENTIFICATION',
  		   	'en',
  		   	'','12170'
  		   	);
  add_cp('8i.CUBES.SHADOWTABLE.TABLESPACE',
                   	'Tablespace',
  		   	'8i.CUBES.SHADOWTABLE.IDENTIFICATION',
  		   	'en',
  		   	'','12020'
  		   	);
  add_cg('8i.CUBES.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.CUBES',
  		   	'en',
  		   	'CMPCube',
  		   	'12009'
  		   	);
  add_cp('8i.CUBES.DEPLOYMENT',
                   	'',
  		   	'8i.CUBES.IDENTIFICATION',
  		   	'en',
  		   	'Deploy All','12047'
  		   	);
  add_cp('8i.CUBES.DEPLOYABLE',
                   	'',
  		   	'8i.CUBES.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.TTSSET',
                   	'TTS Deployment',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPWBOracleTTSSet',
  		   	'12174'
  		   	);
  add_cg('8i.TTSSET',
 		   	'TTS Deployment',
  		   	null,
  		   	'4',
  		   	'8i.TTSSET',
  		   	'en',
  		   	'CMPWBOracleTTSSet',
  		   	'12174'
  		   	);
  add_cp('8i.TTSSET.WORKINGDIR',
                   	'Working Directory',
  		   	'8i.TTSSET',
  		   	'en',
  		   	'','12175'
  		   	);
  add_cp('8i.TTSSET.TARGETOSTYPE',
                   	'Target OS Type',
  		   	'8i.TTSSET',
  		   	'en',
  		   	'Unix','12176'
  		   	);
  add_cp('8i.TTSSET.DEPLOYMENT',
                   	'What to Deploy',
  		   	'8i.TTSSET',
  		   	'en',
  		   	'ALL_OBJECTS','12177'
  		   	);
  add_cg('8i.TTSDATAFILES',
 		   	'Source Datafiles',
  		   	'',
  		   	'3',
  		   	'8i.TTSSET',
  		   	'en',
  		   	'CMPWBOracleDatafile',
  		   	'12178'
  		   	);
  add_cg('8i.TTSDATAFILES.TARGETDATAFILE',
 		   	'Target Datafile',
  		   	null,
  		   	'4',
  		   	'8i.TTSDATAFILES',
  		   	'en',
  		   	'CMPWBOracleTTSSet',
  		   	'12179'
  		   	);
  add_cp('8i.TTSDATAFILES.TARGETDATAFILE.DIRECTORY',
                   	'Directory',
  		   	'8i.TTSDATAFILES.TARGETDATAFILE',
  		   	'en',
  		   	'','12180'
  		   	);
  add_cp('8i.TTSDATAFILES.TARGETDATAFILE.FILENAME',
                   	'File Name',
  		   	'8i.TTSDATAFILES.TARGETDATAFILE',
  		   	'en',
  		   	'','12181'
  		   	);
  add_cg('8i.TTSSCHEMAS',
 		   	'Source Schemas',
  		   	'',
  		   	'3',
  		   	'8i.TTSSET',
  		   	'en',
  		   	'CMPInstalledModule',
  		   	'12182'
  		   	);
  add_cg('8i.TTSSCHEMAS.TARGETSCHEMA',
 		   	'Target Schema',
  		   	null,
  		   	'4',
  		   	'8i.TTSSCHEMAS',
  		   	'en',
  		   	'CMPWBOracleTTSSet',
  		   	'12183'
  		   	);
  add_cp('8i.TTSSCHEMAS.TARGETSCHEMA.NAME',
                   	'Target Schema Name',
  		   	'8i.TTSSCHEMAS.TARGETSCHEMA',
  		   	'en',
  		   	'','12184'
  		   	);
  add_cp('8i.TTSSCHEMAS.TARGETSCHEMA.CREATEIFNOTEXISTS',
                   	'Create',
  		   	'8i.TTSSCHEMAS.TARGETSCHEMA',
  		   	'en',
  		   	'true',
  		   	'12185'
  		   	);
  add_cg('8i.PLSQLRECORDTYPES',
                   	'',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPPLSRecord',
  		   	'12047'
  		   	);
  add_cg('8i.PLSQLRECORDTYPES.DEFAULT',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.PLSQLRECORDTYPES',
  		   	'en',
  		   	'CMPPLSRecord',
  		   	'12047'
  		   	);
  add_cp('8i.PLSQLRECORDTYPES.DEFAULT.QUEUETABLENAME',
                   	'',
  		   	'8i.PLSQLRECORDTYPES.DEFAULT',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cp('8i.PLSQLRECORDTYPES.DEFAULT.DEPLOYABLE',
                   	'',
  		   	'8i.PLSQLRECORDTYPES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.PLSQLRECORDTYPES.STORAGESPACE',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.PLSQLRECORDTYPES',
  		   	'en',
  		   	'CMPPLSRecord',
  		   	'12047'
  		   	);
  add_cp('8i.PLSQLRECORDTYPES.TABLESPACE',
                   	'',
  		   	'8i.PLSQLRECORDTYPES.STORAGESPACE',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cg('8i.PLSQLRECORDTYPES.GENOPTIONS',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.PLSQLRECORDTYPES',
  		   	'en',
  		   	'CMPPLSRecord',
  		   	'12047'
  		   	);
  add_cp('8i.PLSQLRECORDTYPES.GENERATEOBJECTTYPE',
                   	'',
  		   	'8i.PLSQLRECORDTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.PLSQLRECORDTYPES.GENERATEQUEUETABLE',
                   	'',
  		   	'8i.PLSQLRECORDTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.PLSQLRECORDTYPES.GENERATEAQ',
                   	'',
  		   	'8i.PLSQLRECORDTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.PLSQLRECORDTYPES.GENERATETEMPTABLE',
                   	'',
  		   	'8i.PLSQLRECORDTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.REFCURSORTYPES',
                   	'',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPRefCursorType',
  		   	'12047'
  		   	);
  add_cg('8i.REFCURSORTYPES.DEFAULT',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.REFCURSORTYPES',
  		   	'en',
  		   	'CMPRefCursorType',
  		   	'12047'
  		   	);
  add_cp('8i.REFCURSORTYPES.DEFAULT.QUEUETABLENAME',
                   	'',
  		   	'8i.REFCURSORTYPES.DEFAULT',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cp('8i.REFCURSORTYPES.DEFAULT.DEPLOYABLE',
                   	'',
  		   	'8i.REFCURSORTYPES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.REFCURSORTYPES.STORAGESPACE',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.REFCURSORTYPES',
  		   	'en',
  		   	'CMPRefCursorType',
  		   	'12047'
  		   	);
  add_cp('8i.REFCURSORTYPES.TABLESPACE',
                   	'',
  		   	'8i.REFCURSORTYPES.STORAGESPACE',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cg('8i.REFCURSORTYPES.GENOPTIONS',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.REFCURSORTYPES',
  		   	'en',
  		   	'CMPRefCursorType',
  		   	'12047'
  		   	);
  add_cp('8i.REFCURSORTYPES.GENERATEOBJECTTYPE',
                   	'',
  		   	'8i.REFCURSORTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.REFCURSORTYPES.GENERATEQUEUETABLE',
                   	'',
  		   	'8i.REFCURSORTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.REFCURSORTYPES.GENERATEAQ',
                   	'',
  		   	'8i.REFCURSORTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.REFCURSORTYPES.GENERATETEMPTABLE',
                   	'',
  		   	'8i.REFCURSORTYPES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.NESTEDTABLES',
                   	'',
  		   	'',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPPLSCollection',
  		   	'12047'
  		   	);
  add_cg('8i.NESTEDTABLES.DEFAULT',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.NESTEDTABLES',
  		   	'en',
  		   	'CMPPLSCollection',
  		   	'12047'
  		   	);
  add_cp('8i.NESTEDTABLES.DEFAULT.QUEUETABLENAME',
                   	'',
  		   	'8i.NESTEDTABLES.DEFAULT',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cp('8i.NESTEDTABLES.DEFAULT.DEPLOYABLE',
                   	'',
  		   	'8i.NESTEDTABLES.DEFAULT',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cg('8i.NESTEDTABLES.STORAGESPACE',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.NESTEDTABLES',
  		   	'en',
  		   	'CMPPLSCollection',
  		   	'12047'
  		   	);
  add_cp('8i.NESTEDTABLES.TABLESPACE',
                   	'',
  		   	'8i.NESTEDTABLES.STORAGESPACE',
  		   	'en',
  		   	'','12047'
  		   	);
  add_cg('8i.NESTEDTABLES.GENOPTIONS',
 		   	'',
  		   	null,
  		   	'4',
  		   	'8i.NESTEDTABLES',
  		   	'en',
  		   	'CMPPLSCollection',
  		   	'12047'
  		   	);
  add_cp('8i.NESTEDTABLES.GENERATEOBJECTTYPE',
                   	'',
  		   	'8i.NESTEDTABLES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.NESTEDTABLES.GENERATEQUEUETABLE',
                   	'',
  		   	'8i.NESTEDTABLES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.NESTEDTABLES.GENERATEAQ',
                   	'',
  		   	'8i.NESTEDTABLES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
  add_cp('8i.NESTEDTABLES.GENERATETEMPTABLE',
                   	'',
  		   	'8i.NESTEDTABLES.GENOPTIONS',
  		   	'en',
  		   	'true',
  		   	'12047'
  		   	);
 
 begin
  forall p in 1..cg_gk.count 
   insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
 exception
  when others then
   for p in 1..cg_gk.count loop
    begin
      insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
    exception
     when others then
      null;
    end;
   end loop;
  end;

 begin
  forall q in 1..cp_pk.count 
   insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
  exception
   when others then
    for q in 1..cp_pk.count loop
     begin
       insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
     exception
      when others then
       null;
     end;
    end loop;
  end; 

end;

end;

/



