
begin

declare
 TYPE it_128 is table of varchar(128) index by binary_integer;
 TYPE it_64 is table of varchar(64) index by binary_integer;
 TYPE it_1 is table of number(1) index by binary_integer;
 
 cg_gk it_128;
 cg_fn it_64;
 cg_in it_64;
 cg_gt it_1;
 cg_pk it_128;
 cg_lan it_64;
 cg_types it_128;
 cp_pk  it_128;
 cp_pn it_64;
 cp_lan it_64;
 cp_val it_128;
 cp_gk  it_128;
 cg_index it_64;
 cp_index it_64;
 
 cg_i number := 0;
 cp_i number := 0;

 procedure add_cg (
 	g_gk in varchar2,
 	g_fn in varchar2,
 	g_in in varchar2,
 	g_gt in number,
 	g_pk in varchar2,
 	g_lan in varchar2,
 	g_types in varchar2,
        g_key in varchar2
  ) 
  is
  	l_gk varchar2(128) := g_gk;
  	l_fn varchar2(64) := g_fn;
  	l_gt number(1) := g_gt;
  	l_lan varchar2(64) := g_lan;
  	l_types varchar2(128) := g_types;
  begin
  	if l_gk is null then
  		 l_gk := 'A';
        end if;
        if l_fn is null then 
       		l_fn := 'A';
       	end if;
       	if l_gt is null then
       		l_gt := 0;
       	end if;
       	if l_lan is null then
       		l_lan := 'en';
       	end if;
       	if l_types is null then
       		l_types := 'A';
       	end if;
       	
       	cg_i := cg_i +1;
       	cg_gk(cg_i) := l_gk;
  	cg_fn(cg_i) := l_fn;
  	cg_in(cg_i) := g_in;
  	cg_gt(cg_i) := l_gt;
  	cg_pk(cg_i) := g_pk;
  	cg_lan(cg_i) := l_lan;
  	cg_types(cg_i) := l_types;
        
       
	cg_index(cg_i) := g_key;

  end;

  procedure add_cp (
  	p_pk in varchar2,
  	p_pn in varchar2,
  	p_gk in varchar2,
  	p_lan in varchar2,
  	p_val in varchar2,
	p_key in varchar2
  )
  is
  	l_pk varchar2(128) := p_pk;
  	l_pn varchar2(64) := p_pn;
  	l_gk varchar2(128) := p_gk;
  	l_lan varchar2(64) := p_lan;
  	l_val varchar2(128) := p_val;
  begin
  	if l_pk	is null then
  		l_pk := 'A';
  	end if;
  	if l_pn	is null then
  		l_pn := 'A';
  	end if;
  	if l_gk	is null then
  		l_gk := 'A';
  	end if;
  	if l_lan is null then
  		l_lan := 'en';
  	end if;
  	if l_val is null then
  		l_val := 'A';
  	end if;

  	cp_i := cp_i + 1;
  	cp_pk(cp_i) := l_pk;
  	cp_pn(cp_i) := l_pn;
  	cp_gk(cp_i) := l_gk;
  	cp_lan(cp_i) := l_lan;
        cp_val(cp_i) := l_val;
	cp_index(cp_i) := p_key;

  end;




begin




-- File /owb/oracle/wh/service/impl/integrator/xml/files/81ssb2.xml
 add_cg('ORACLE8.1.1SS',
                   	'Oracle 8.1 Instance',
  		   	'Application',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPInstalledModule,CMPSharedInstalledModule,CMPWBDataWarehouse',
  		   	'12007'
  		   	);
  add_cg('8i.SS.TRANSFORMPACKAGES',
                   	'SQL Libraries',
  		   	'Library',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPFunctionCategory',
  		   	'12120'
  		   	);
  add_cg('8i.SS.TRANSFORMATION',
                   	'Functions',
  		   	'Function',
  		   	'0',
  		   	null,
  		   	'en',
  		   	'CMPFunction',
  		   	'12121'
  		   	);
  add_cg('8i.SS.TRANSFORMATION.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.SS.TRANSFORMATION',
  		   	'en',
  		   	'CMPFunction',
  		   	'12009'
  		   	);
  add_cp('8i.SS.TRANSFORMATION.NAME',
                   	'Name',
  		   	'8i.SS.TRANSFORMATION.IDENTIFICATION',
  		   	'en',
  		   	'','12186'
  		   	);
  add_cp('8i.SS.TRANSFORMATION.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.SS.TRANSFORMATION.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.SS.TRANSFORMATION.OPTIONS',
 		   	'Options',
  		   	null,
  		   	'4',
  		   	'8i.SS.TRANSFORMATION',
  		   	'en',
  		   	'CMPFunction',
  		   	'12122'
  		   	);
  add_cp('8i.SS.TRANSFORMATION.AUTHID',
                   	'AUTHID',
  		   	'8i.SS.TRANSFORMATION.OPTIONS',
  		   	'en',
  		   	'None','12123'
  		   	);
  add_cg('8i.SS.TRANSFORMPACKAGES.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'8i.SS.TRANSFORMPACKAGES',
  		   	'en',
  		   	'CMPFunctionCategory',
  		   	'12009'
  		   	);
  add_cp('8i.SS.TRANSFORMPACKAGES.NAME',
                   	'Name',
  		   	'8i.SS.TRANSFORMPACKAGES.IDENTIFICATION',
  		   	'en',
  		   	'','12186'
  		   	);
  add_cp('8i.SS.TRANSFORMPACKAGES.DEPLOYABLE',
                   	'Deployable',
  		   	'8i.SS.TRANSFORMPACKAGES.IDENTIFICATION',
  		   	'en',
  		   	'true',
  		   	'12011'
  		   	);
  add_cg('8i.SS.TRANSFORMPACKAGES.OPTIONS',
 		   	'Options',
  		   	null,
  		   	'4',
  		   	'8i.SS.TRANSFORMPACKAGES',
  		   	'en',
  		   	'CMPFunctionCategory',
  		   	'12122'
  		   	);
  add_cp('8i.SS.TRANSFORMPACKAGES.AUTHID',
                   	'AUTHID',
  		   	'8i.SS.TRANSFORMPACKAGES.OPTIONS',
  		   	'en',
  		   	'None','12123'
  		   	);
  add_cg('8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1.1SS',
  		   	'en',
  		   	'CMPInstalledModule,CMPSharedInstalledModule,CMPWBDataWarehouse',
  		   	'12009'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.NAME',
                   	'Name',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'','12186'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.MAINAPP',
                   	'Main Application Short Name',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'ora','12126'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.SHORTNAME',
                   	'Application Short Name',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'WB','12127'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.SCHEMAOWNER',
                   	'Schema Owner',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'OWB','12128'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.CONNECTSTRING',
                   	'Connect String',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'','12129'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.JDBCSERVER',
                   	'Machine',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'','12187'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.JDBCPORT',
                   	'Port',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'','12131'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.JDBCSERVICENAME',
                   	'Service Name',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'','12132'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.APPTOPDIRECTORY',
                   	'Top Directory',
  		   	'8i.SS.ORACLE8.1.1SS.IDENTIFICATION',
  		   	'en',
  		   	'ORACLE_PRODUCT_HOME','12133'
  		   	);
  add_cg('8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
 		   	'Generation Target Directories',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1.1SS',
  		   	'en',
  		   	'CMPInstalledModule,CMPSharedInstalledModule,CMPWBDataWarehouse',
  		   	'12134'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.TCLDIRECTORY',
                   	'TCL Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'tcl\','12135'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.APPRUNTASK',
                   	'MODULE Run Task File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.txt','12188'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.APPRUNBAT',
                   	'MODULE Run Batch File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.bat','12189'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.DDLDIRECTORY',
                   	'DDL Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'ddl\','12136'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.DDLEXTENSION',
                   	'DDL Extension',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'.ddl','12137'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.DDLSPOOLDIRECTORY',
                   	'DDL Spool Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'ddl\log\','12138'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.LIBDIRECTORY',
                   	'LIB Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'lib\','12139'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.LIBEXTENSION',
                   	'LIB Extension',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'.lib','12140'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.LIBSPOOLDIRECTORY',
                   	'LIB Spool Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'lib\log\','12141'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PLSDIRECTORY',
                   	'SQL Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'pls\','12142'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PLSEXTENSION',
                   	'SQL Extension',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'.pls','12143'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PLSRUNPRM',
                   	'SQL Run Parameter File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.ini','12144'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PLSRUNTASK',
                   	'SQL Run Task File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.txt','12190'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PLSRUNBAT',
                   	'SQL Run Batch File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.bat','12191'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PLSSPOOLDIRECTORY',
                   	'SQL Spool Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'pls\log\','12145'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.CTLDIRECTORY',
                   	'LOADER Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'ctl\','12150'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.CTLEXTENSION',
                   	'LOADER Extension',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'.ctl','12151'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.CTLRUNPRM',
                   	'LOADER Run Parameter File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.ini','12152'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.CTLRUNTASK',
                   	'LOADER Run Task File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.txt','12192'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.CTLRUNBAT',
                   	'LOADER Run Batch File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.bat','12193'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMDIRECTORY',
                   	'OEM Directory',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'c:\orant\','12194'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PERUNPRM',
                   	'Pure Extract Run Parameter File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.ini','12195'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PERUNTASK',
                   	'Pure Extract Run Task File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.txt','12196'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PERUNBAT',
                   	'Pure Extract Run Batch File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.bat','12197'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PIRUNPRM',
                   	'Pure Integrate Run Parameter File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.ini','12198'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PIRUNTASK',
                   	'Pure Integrate Run Task File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.txt','12199'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.PIRUNBAT',
                   	'Pure Integrate Run Batch File',
  		   	'8i.SS.ORACLE8.1.1SS.GENDIRECTORIES',
  		   	'en',
  		   	'_run.bat','12200'
  		   	);
  add_cg('8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
 		   	'Run Time Directories',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1.1SS',
  		   	'en',
  		   	'CMPInstalledModule,CMPSharedInstalledModule,CMPWBDataWarehouse',
  		   	'12153'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.RECEIVEDIRECTORY',
                   	'Receive Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'receive\','12154'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.INPUTDIRECTORY',
                   	'Input Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'input\','12155'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.INVALIDDIRECTORY',
                   	'Invalid Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'invalid\','12156'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.WORKDIRECTORY',
                   	'Work Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'work\','12157'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.SORTDIRECTORY',
                   	'Sort Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'sort\','12158'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.LOGDIRECTORY',
                   	'Log Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'log\','12159'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.ARCHIVEDIRECTORY',
                   	'Archive Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'archive\','12160'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.LISTENERDIRECTORY',
                   	'Queue Listener Directory',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEDIRECTORIES',
  		   	'en',
  		   	'd:\orahome\owb\workflow\','12201'
  		   	);
  add_cg('8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
 		   	'OEM Registration',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1.1SS',
  		   	'en',
  		   	'CMPInstalledModule,CMPSharedInstalledModule,CMPWBDataWarehouse',
  		   	'12202'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMUSER',
                   	'OEM User',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'sysman','12203'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMPASSWORD',
                   	'OEM Password',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'sysman','12204'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMDOMAIN',
                   	'OEM Domain',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'local','12205'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMTARGETNAME',
                   	'OEM Target Name',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'local','12206'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMJOBUSER',
                   	'OEM Job User',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'owb','12207'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMJOBPASSWORD',
                   	'OEM Job Password',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'owb','12208'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMJOBCONNECTSTRING',
                   	'OEM Job Connect String',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'orcl','12209'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.OEMJOBNAME',
                   	'OEM Job Name',
  		   	'8i.SS.ORACLE8.1.1SS.OEMREGISTRATION',
  		   	'en',
  		   	'_job','12210'
  		   	);
  add_cg('8i.SS.ORACLE8.1.1SS.GENPREFERENCES',
 		   	'Generation Preferences',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1.1SS',
  		   	'en',
  		   	'CMPInstalledModule,CMPSharedInstalledModule,CMPWBDataWarehouse',
  		   	'12161'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.GENPREFCRLF',
                   	'End of Line',
  		   	'8i.SS.ORACLE8.1.1SS.GENPREFERENCES',
  		   	'en',
  		   	'\r\n','12162'
  		   	);
  add_cg('8i.SS.ORACLE8.1.1SS.RUNTIMEAUDIT',
 		   	'Runtime Audit',
  		   	null,
  		   	'4',
  		   	'ORACLE8.1.1SS',
  		   	'en',
  		   	'CMPInstalledModule,CMPSharedInstalledModule,CMPWBDataWarehouse',
  		   	'12211'
  		   	);
  add_cp('8i.SS.ORACLE8.1.1SS.AUDITLEVEL',
                   	'Audit Level',
  		   	'8i.SS.ORACLE8.1.1SS.RUNTIMEAUDIT',
  		   	'en',
  		   	'COMPLETE','12212'
  		   	);
 
 begin
  forall p in 1..cg_gk.count 
   insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
 exception
  when others then
   for p in 1..cg_gk.count loop
    begin
      insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
    exception
     when others then
      null;
    end;
   end loop;
  end;

 begin
  forall q in 1..cp_pk.count 
   insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
  exception
   when others then
    for q in 1..cp_pk.count loop
     begin
       insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
     exception
      when others then
       null;
     end;
    end loop;
  end; 

end;

end;

/



