CREATE OR REPLACE PACKAGE MODELSERVICE
  IS
  
   CORE NUMBER(1) := 0;
   LOGICAL NUMBER(1) := 1;
   CONFIGURATION NUMBER(1) := 2;
   USER_DEFINED NUMBER(1) := 3;
   
   STRING_PROPERTY NUMBER(1) := 0;
   CLOB_PROPERTY NUMBER(1) := 1;
   REFERENCE_PROPERTY NUMBER(1) := 2;
   LINE NUMBER(1) := 3;
   
   STRING_TYPE VARCHAR2(255) := 'String';
   INTEGER_TYPE VARCHAR2(255) := 'Integer';
   LONG_TYPE VARCHAR2(255) := 'Long';
   FLOAT_TYPE VARCHAR2(255) := 'Float';
   DOUBLE_TYPE VARCHAR2(255) := 'Double';
   TIMESTAMP_TYPE VARCHAR2(255) := 'Timestamp';
   DATE_TYPE VARCHAR2(255) := 'Date';
   BOOLEAN_TYPE VARCHAR2(255) := 'Boolean';
   URL_TYPE VARCHAR2(255) := 'URL';

   FCO_CLASS VARCHAR2(255) := 'oracle.wh.repos.impl.component.FirstClassObject';
   SCO_CLASS VARCHAR2(255) := 'oracle.wh.repos.impl.component.SecondClassObject';
   FOLDER_CLASS VARCHAR2(255) := 'oracle.wh.repos.impl.component.Folder';

   FCO_ID NUMBER;
   SCO_ID NUMBER;
   FOLDER_ID NUMBER;

   UDP_KEY VARCHAR2(255) := 'USER_DEFINED_PROPERTIES';

   SCO NUMBER(1) := 0;
   FCO NUMBER(1) := 1;
   FOLDER NUMBER(1) := 2;
   UNKNOWN NUMBER(1) := 3;

   PROCEDURE cleanProperties ;
   
   PROCEDURE cleanProperties (elemId IN NUMBER);
       
   FUNCTION decideClassDefId(viewName IN VARCHAR2, elemId IN NUMBER) RETURN NUMBER;
   
   FUNCTION isValid(tname IN VARCHAR2, value IN VARCHAR2) RETURN VARCHAR2;   

   FUNCTION deleteAllPropertyValues(propDef IN NUMBER, cname IN VARCHAR2, viewName IN VARCHAR2, isFCO IN NUMBER) RETURN NUMBER;   

   FUNCTION getComponentKind(cname IN VARCHAR2) RETURN NUMBER;

   FUNCTION getComponentKind(cid IN NUMBER) RETURN NUMBER;

   FUNCTION getClassId(cname IN VARCHAR2) RETURN NUMBER;

END; -- Package spec
