CREATE OR REPLACE PACKAGE NamespaceServiceImpl AS
-- reserve a name 
PROCEDURE reserveName(outcome out VARCHAR2,
		      pID IN Reservation_Store.parentID%TYPE,
		      elemId IN Reservation_Store.parentID%TYPE,
		      classification IN Reservation_Store.domain%TYPE,
		      desiredName IN Reservation_Store.reservedName%TYPE,
		      isPhys IN Reservation_Store.isPhys%TYPE,
 		      isProp IN NUMBER,
		      osUser IN Reservation_Store.osUser%TYPE,
		      sessID IN Reservation_Store.sessID%TYPE,
	              instanceID IN NUMBER,
		      isReposCheckRequired IN NUMBER,
		      upperCaseGenedPhyName IN NUMBER,
                      bulkMode IN NUMBER,
                      singleUserLock IN NUMBER,
		      ISOID in Reservation_Store.languageISOID%TYPE, 
		      db_platform_name in varchar2);
-- generate unique name and reserve
PROCEDURE generateAndReserveUniqueName(outcome out VARCHAR2,
		      pID IN Reservation_Store.parentID%TYPE,
		      classification IN Reservation_Store.domain%TYPE,
		      desiredName IN Reservation_Store.reservedName%TYPE,
		      isPhys IN Reservation_Store.isPhys%TYPE,
		      osUser IN Reservation_Store.osUser%TYPE,
		      sessID IN Reservation_Store.sessID%TYPE,
	              instanceID IN NUMBER,
		      isReposCheckRequired IN NUMBER,
                      bulkMode IN NUMBER,
                      singleUserLock IN NUMBER, 
		     db_platform_name in varchar2
		      );

-- generate unique name and reserve(old one)
PROCEDURE generateNewUniqueName(outcome out VARCHAR2,
		      pID IN Reservation_Store.parentID%TYPE,
		      classification IN Reservation_Store.domain%TYPE,
		      desiredName IN Reservation_Store.reservedName%TYPE,
		      isPhys IN Reservation_Store.isPhys%TYPE,
		      osUser IN Reservation_Store.osUser%TYPE,
		      sessID IN Reservation_Store.sessID%TYPE,
	              instanceID IN NUMBER,
		      isReposCheckRequired IN NUMBER,
		      bulkMode IN NUMBER,
		      singleUserLock IN NUMBER,
		     db_platform_name in varchar2

		      );

-- generate unique name and reserve(new one)
PROCEDURE generateNewUniqueName(outcome out VARCHAR2,
		      pID IN Reservation_Store.parentID%TYPE,
		      classification IN Reservation_Store.domain%TYPE,
		      desiredName IN Reservation_Store.reservedName%TYPE,
		      isPhys IN Reservation_Store.isPhys%TYPE,
		      osUser IN Reservation_Store.osUser%TYPE,
		      sessID IN Reservation_Store.sessID%TYPE,
	              instanceID IN NUMBER,
	 	      isReposCheckRequired IN NUMBER,
		      ISOID IN Reservation_Store.languageISOID%TYPE,
		      db_platform_name in varchar2
		      );

-- Commit and Rollback event behave exactly same As repository name cache
-- is built on demand and there is no cahes stored until next call so
-- unlike CORBA thingy's Commit and Rollback behave exctly the same
-- so this method is used for both commit and rollback events

PROCEDURE unReserveSession(currSession IN Reservation_store.sessID%TYPE,currInstance in number);

--sochen:remove it from pks, since nobody call it outside of this pkg
--FUNCTION getInstalledModule(id in CMPElement_v.elementID%TYPE)
--         RETURN CMPElement_v.elementID%TYPE;
 
--sochen:nobody use it, hence remove it totally(pks/pkb)...
--PROCEDURE delTree(elemid in CMPElement_v.elementID%TYPE);

--sochen:nobody use it outside the pkb, remove it from pks
--FUNCTION getParentID(id in Reservation_Store.parentID%TYPE)
--         RETURN Reservation_Store.parentID%TYPE;

/*
PROCEDURE reserveAllNamesForDeletion(pID IN Reservation_Store.parentID%TYPE,
                         osUser IN Reservation_Store.osUser%TYPE,
                         sessID IN Reservation_Store.sessID%TYPE,
        	         instanceID IN NUMBER,
                         bulkMode IN NUMBER,
                         singleUserLock IN NUMBER);
*/


PROCEDURE cleanSIDs;

--sochen:nobody use it, hence remove it totally(pks/pkb)
--FUNCTION getOwningFolder(id in Reservation_Store.parentID%TYPE)
--         RETURN Reservation_Store.parentID%TYPE;


--sochen: this one is specific for pkged function
PROCEDURE saveNameToDBCacheForFunction(
	isoid CMPALLFOLDERFCONAMES.languageISOID%TYPE, 
	parentid 	CMPALLFOLDERFCONAMES.parentID%TYPE,
	domain CMPALLFOLDERFCONAMES.domain%TYPE,
	name CMPALLFOLDERFCONAMES.name%TYPE,
	isPhysical CMPALLFOLDERFCONAMES.isPhys%TYPE,
	elemId CMPALLFOLDERFCONAMES.elementid%TYPE,
	snapshot_view NUMBER
	);

/*	
PROCEDURE reserveNameForFnBeforeDelete(
	elemId CMPALLFOLDERFCONAMES.elementid%TYPE,
	isoid CMPALLFOLDERFCONAMES.LANGUAGEISOID%TYPE,
	classification CMPALLFOLDERFCONAMES.domain%type,
	snapshot_view NUMBER,
	theSessId NUMBER,
	instID IN NUMBER,
	theOsUser reservation_store.osuser%type
	);	 
*/

---return 1: means ok, 0 not ok, and if ok also reserve the name
FUNCTION isUniqueWorkspaceName(ws_name varchar2 ,ws_owner varchar2, toReserve boolean) return number;
PROCEDURE unReserveWorkspaceName(ws_name varchar2 ,ws_owner varchar2);

END NamespaceServiceImpl;
