CREATE OR REPLACE PACKAGE Snapshot AS

-- component type
FCO_TYPE               NUMBER(1):= 0;
SCO_TYPE               NUMBER(1):= 1;
MM_TYPE                NUMBER(1):= 2;

-- object type
LOGICAL                NUMBER(1):= 0;
PHYSICAL               NUMBER(1):= 1;
MMDEFINITION           NUMBER(1):= 2;

-- snapshot operation types
CREATE_SNAPSHOT      NUMBER(1) := 0;
DELETE_SNAPSHOT      NUMBER(1) := 1;
MODIFY_SNAPSHOT      NUMBER(1) := 2;
RESTORE_SNAPSHOT     NUMBER(1) := 3;
COMPARE_SNAPSHOT     NUMBER(1) := 4;
SHRINK_SNAPSHOT      NUMBER(1) := 5;
ALTER_SNAPSHOT       NUMBER(1) := 6;
COMPARE_LABEL        NUMBER(1) := 7;
RESTORE_NEW          NUMBER(1) := 8;
UNDELETE             NUMBER(1) := 9;

-- Heavy or Light
HEAVY_SNAPSHOT       NUMBER(1) := 0;
LIGHT_SNAPSHOT       NUMBER(1) := 1;

-- Type of light weight associations
PARENT_ASSOC         NUMBER(1):=0;
INTRA_ASSOC          NUMBER(1):=1;
INTER_ASSOC          NUMBER(1):=2;
NONASSOC             NUMBER(1):=3;

-- Node matching for creation of light weight snapshots
UOIDBASED            NUMBER(1):=0;
NAMEBASED            NUMBER(1):=1;
POSBASED             NUMBER(1):=2;
IGNORE               NUMBER(1):=3;

-- Cascade or No Cascade
CASCADE_SNAPSHOT     NUMBER(1) := 0;
NON_CASCADE_SNAPSHOT NUMBER(1) := 1;

-- following const define structures for procs and funcs
PERSISTENT_SNAPSHOT  NUMBER(1) := 0;
TRANSIENT_SNAPSHOT   NUMBER(1) := 1;

CURRENT_SNAPSHOT     NUMBER(1) := 0;
VERSION_SNAPSHOT     NUMBER(1) := 1;

CONSISTENT           NUMBER(1):= 0;
NOT_CONSISTENT       NUMBER(1):= 1;

IMMED_CUSTOMIZE      NUMBER(1):= 0;
DEFER_CUSTOMIZE      NUMBER(1):= 1;

currentUser VARCHAR2(255);

FUNCTION isDebug RETURN BOOLEAN;

PROCEDURE debug(str IN VARCHAR2,value IN VARCHAR2);

FUNCTION getLWContextTable(transient IN NUMBER) RETURN VARCHAR2;

FUNCTION insertSnapshotStore(elemID IN NUMBER,snap IN NUMBER,
  description IN VARCHAR2,isHeavy IN NUMBER,isCascade IN NUMBER) RETURN NUMBER;

FUNCTION doMCMOperation(operType IN NUMBER,labelStr IN VARCHAR2,retValue OUT NUMBER,
  owbuser IN VARCHAR2 default null,descriptionStr IN VARCHAR2 default null,
  isHeavy IN NUMBER default 0,isCurrent IN NUMBER default 0) RETURN NUMBER;

FUNCTION compareLabel(vSrcSnapshotID IN NUMBER, vTgtSnapshotID IN NUMBER,
  transient IN NUMBER default 0, filter IN NUMBER default 0) RETURN NUMBER;


FUNCTION compareLabel(srcLabel IN VARCHAR2, targetLabel IN VARCHAR2,
  transient IN NUMBER default 0, filter IN NUMBER default 0) RETURN NUMBER;


FUNCTION compare(compareID out NUMBER, srcLabel IN VARCHAR2, targetLabel IN VARCHAR2,
  vCompUOID IN VARCHAR2, transient IN NUMBER default 0) RETURN NUMBER;

FUNCTION compareCurrentWithSnap(label IN VARCHAR2, vCompUOID IN VARCHAR2,
    target IN NUMBER default 0) RETURN NUMBER;

PROCEDURE findDependeeComponents(depth IN NUMBER);
PROCEDURE findDependeeComponents;

PROCEDURE findRedundantComponents;

FUNCTION isModelConsistent(snap IN NUMBER) RETURN NUMBER;

/**
 * Procedures to be used by SnapshotMXS and SnapshotImport
 */
FUNCTION isFunction(elemID IN NUMBER,current IN NUMBER default 0) RETURN BOOLEAN;

FUNCTION isFirstClassObject(elemID IN NUMBER,current IN NUMBER default 0) RETURN BOOLEAN;

FUNCTION isSecondClassObject(elemID IN NUMBER,current IN NUMBER default 0) RETURN BOOLEAN;

PROCEDURE storeComponentRows(elemID IN NUMBER,isCascade IN NUMBER,
  isCurrent IN NUMBER);

FUNCTION getSnapshotID(labelStr IN VARCHAR2,transient IN NUMBER,
  description IN VARCHAR2,isHeavy IN NUMBER,
  snapType IN NUMBER default RESTORE_SNAPSHOT,snap IN NUMBER default 0)
  RETURN NUMBER;

PROCEDURE takeLWSnapshot(elemID IN NUMBER,snap IN NUMBER,transient IN NUMBER,
      current IN NUMBER,matchingStrategy IN NUMBER default 0,
      defaultStrategy IN NUMBER default 0,customize IN NUMBER default 0);
PROCEDURE cleanTempTable;
PROCEDURE cleanTempFCO;
PROCEDURE cleanComponent;

END Snapshot;
/
