CREATE OR REPLACE PACKAGE SnapshotCreateRestore AS
/**
 * Object type
 */
PROJECT       NUMBER(1):= 0;
MODULE        NUMBER(1):= 1;
ENTITY        NUMBER(1):= 2;

/**
 * FCOPARENTS  - type in tempfco which signifies that the object is a parent
 *               of the FCO being restored
 * FCOCHILDREN - type in tempfco which signifies that the object is either
 *               the FCO itself or a child FCO of the FCO being restored
 * ITEMSETS    - type in tempfco which signified that the object is an itemset
 *               which is used by restoring of the namespace tables
 */
FCOPARENTS    NUMBER(1):= 0;
FCOCHILDREN   NUMBER(1):= 1;
ITEMSETS      NUMBER(1):= 2;

/**
 * Paste type
 */
INTRAPROJPLAT NUMBER(1):= 0;
INTERPROJECT  NUMBER(1):= 1;
INTERPLATFORM NUMBER(1):= 2;
INTERPROJPLAT NUMBER(1):= 3;

type elemidType is table of cmpelement_v.elementid%TYPE index by BINARY_INTEGER;
type uoidType is table of cmpelement_v.uoid%TYPE index by BINARY_INTEGER;

PROCEDURE takeSnapshot(elemID IN NUMBER,snap IN NUMBER);
FUNCTION restore(uoidStr IN VARCHAR2,snap IN NUMBER,restoreParents IN BOOLEAN,
  restoreOper IN NUMBER default Snapshot.RESTORE_SNAPSHOT,
  newParent IN NUMBER default 0) RETURN NUMBER;
FUNCTION resetParent(uoidStr IN VARCHAR2,snap IN NUMBER,newParent IN NUMBER,
  pasteType IN NUMBER, srcPlatformId IN NUMBER, tgtPlatformId IN NUMBER)
  RETURN NUMBER;
PROCEDURE resolveNSIssues(snap IN NUMBER,elemID IN NUMBER,
  newPhysName IN VARCHAR2,newLogName IN VARCHAR2,newNSName IN VARCHAR2,
  newDomain IN VARCHAR2);
FUNCTION validateNamespace(elemId IN NUMBER,platformId IN NUMBER)
  RETURN NUMBER;

PROCEDURE copy(snap IN NUMBER);
PROCEDURE paste(snap IN NUMBER,newParent IN NUMBER,nsNewParent IN NUMBER,
  pasteType IN NUMBER, srcPlatformId IN NUMBER, tgtPlatformId IN NUMBER);
PROCEDURE recycle(snap IN NUMBER);
PROCEDURE undelete(snap IN NUMBER);

END SnapshotCreateRestore;
/
