CREATE OR REPLACE PACKAGE SnapshotDataTypeService AS

type mappedPairType is table of NUMBER index by VARCHAR2(32);

PROCEDURE loadMappings(fromPlatform IN NUMBER, toPlatform IN NUMBER);

FUNCTION getMappedDataTypeFQN(dataType IN NUMBER) RETURN VARCHAR2;

FUNCTION getMappedDataTypeUOID(dataType IN NUMBER) RETURN VARCHAR2;

FUNCTION resetLength(srcDataType IN NUMBER, tgtDataType IN NUMBER, curValue IN NUMBER) RETURN NUMBER;

FUNCTION resetPrecision(srcDataType IN NUMBER, tgtDataType IN NUMBER, curValue IN NUMBER) RETURN NUMBER;

FUNCTION resetScale(srcDataType IN NUMBER, tgtDataType IN NUMBER, curValue IN NUMBER) RETURN NUMBER;

FUNCTION getMappedDataType(sourceDataType IN NUMBER,
                           targetPlatform IN NUMBER,
                           propertyValues IN mappedPairType) RETURN NUMBER;

PROCEDURE resetDataTypes(elemID IN NUMBER,
                         srcPlatformId IN NUMBER, tgtPlatformId IN NUMBER);

PROCEDURE resetDataTypes(uoidStr IN VARCHAR2, snap IN NUMBER,
                         srcPlatformId IN NUMBER, tgtPlatformId IN NUMBER);

PROCEDURE testLoadAndLookup(fromPlatform IN NUMBER, toPlatform IN NUMBER);

END SnapshotDataTypeService;
/

